#include <sys/types.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <string.h>
#include <stdio.h>
#include <netdb.h>
#ifdef __FreeBSD__
#include <netinet/in.h>
#endif
#include <dirent.h>
#include <unistd.h>
#include <string.h>

/*
   This is just a sample application that connects to Sophie over network,
   sends a file and shows the response. It's late, I'm tried, app is not nice,
   but you'll get the point :)
*/

int main(int argc, char *argv[])
{
	int sock;
	int bread;
	int filesize;
	int fd;
	FILE *fp;
	struct sockaddr_in server;
	struct hostent *hp;
	char buf[4096];
	char hostname[512];
	char filename[512];
	char send_msg[1024];
	char *short_filename;
	char resp[256];
	int port = 4009;
	struct stat filestat;

	if (argc < 3)
	{
		printf("Usage: %s <host_to_connect_to> <filename> [<port>]\n", argv[0]);
		exit(0);
	}

	memset(send_msg, 0, sizeof(send_msg)-1);
	memset(resp, 0, sizeof(resp));

	strncpy(hostname, argv[1], sizeof(hostname)-1);
	strncpy(filename, argv[2], sizeof(filename)-1);

	if (argv[3])
		port = atoi(argv[3]);

	/* Create socket */
	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock < 0)
	{
		perror("socket");
		exit(1);
	}
	
	bzero((char *) &server, sizeof(server));
	server.sin_family = AF_INET;

	if ((hp = gethostbyname(argv[1])) == NULL)
	{
		sprintf(buf, "%s: unknown host\n", argv[1]);
		printf("%s", buf);
		exit(1);
	}

	bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
	server.sin_port = htons(port);

	if (connect(sock, (struct sockaddr *) &server, sizeof(struct sockaddr_in)) < 0)
	{
		perror("connect");
		exit(1);
	}

	if ((stat(filename, &filestat)) == -1)
	{
		perror("stat");
		exit(1);
	}

	filesize = filestat.st_size;

	if (rindex(filename, '/'))
		short_filename = rindex(filename, '/')+1;
	else
		short_filename = filename;

	snprintf(send_msg, sizeof(send_msg)-1, "%s/%d\n", short_filename, filesize);

	if (write(sock, send_msg, strlen(send_msg)) < 0)
		perror("write");

	fp = fdopen(sock, "r");
	fgets(resp, sizeof(resp), fp);

	if (strncmp("OK", resp, 2))
	{
		printf("'OK' not returned from Sophie\n");
		exit(0);
	}
	
	if (!(fd = open(filename, O_RDONLY)))
		perror("open");

	while ((bread = read(fd, buf, 4096)) > 0)
		write(sock, buf, bread);

	close(fd);
	
	fgets(resp, sizeof(resp), fp);
	printf("Response: %s", resp);

	close(sock);

	exit(0);

}
