#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <string.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <string.h>

/*
   This is just a sample application that takes a socket name (on a
   local filesystem) as an argument, tries to connect to it and send
   a request to Sophie. Then it waits for response, and displays it
*/
int main(int argc, char *argv[])
{
	int sock;
	int bread;
	struct sockaddr_un server;
	char path[512];
	char buf[512];
	char sockname[512];

	if (argc != 2)
	{
		printf("Usage: %s <socket_to_connect_to>\n", argv[0]);
		exit(0);
	}

	/* No, I don't want to use "char *sockname; sockname = argv[1];" */
	strncpy(sockname, argv[1], sizeof(sockname)-1);

	/* Create socket */
	sock = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sock < 0)
	{
		perror("socket");
		exit(1);
	}
	
	server.sun_family = AF_UNIX;
	strncpy(server.sun_path, sockname, sizeof(server.sun_path)-1);

	if (connect(sock, (struct sockaddr *) &server, sizeof(struct sockaddr_un)) < 0)
	{
		perror("connect");
		exit(1);
	}

	/* Read a line of input (file to scan) */
	memset(path, 0, sizeof(path));
	printf("INPUT PATH (FILENAME) TO SCAN: ");
	fgets(path, sizeof(path)-1, stdin);

	if (strchr(path, '\n'))
		*strchr(path, '\n') = '\0';

	if (write(sock, path, strlen(path)) < 0)
		perror("write");
	
	memset(buf, 0, sizeof(buf));
	if ((bread = read(sock, buf, sizeof(buf))) > 0)
	{
		if (strchr(buf, '\n'))
			*strchr(buf, '\n') = '\0';

		if (buf[0] == '1')
			printf("FILE INFECTED: [%s]\n", path);
		else if (!strncmp(buf, "-1", 2))
			printf("FILE NOT FOUND, OR ERROR OCCURED (-1 received)\n");
		else
			printf("FILE NOT INFECTED: [%s]\n", path);
	}
	else
	{
		printf("Ouch! read() from the socket failed :(\n");
	}

	close(sock);
	exit(0);

}
