#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <string.h>
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/*
   This is just a sample application that takes a socket name (on a
   local filesystem) as an argument, tries to connect to it and send
   a request to Sophie. Then it waits for response, and displays it
*/
int main(int argc, char *argv[])
{
	int sock;
	int bread;
	struct sockaddr_un server;
	char buf[512];
	char sockname[512];
	char filename[1024];

	if (argc != 3)
	{
		printf("Usage: %s <socket_to_connect_to> <filename>\n", argv[0]);
		exit(0);
	}

	memset(filename, 0, sizeof(filename));

	/* No, I don't want to use "char *sockname; sockname = argv[1];" */
	strncpy(sockname, argv[1], sizeof(sockname)-1);

	strncpy(filename, argv[2], sizeof(filename)-1);

	/* Create socket */
	sock = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sock < 0)
	{
		perror("socket");
		exit(1);
	}
	
	server.sun_family = AF_UNIX;
	strncpy(server.sun_path, sockname, sizeof(server.sun_path)-1);

	if (connect(sock, (struct sockaddr *) &server, sizeof(struct sockaddr_un)) < 0)
	{
		perror("connect");
		exit(1);
	}

	strncat(filename, "\n", sizeof(filename)-1);

	if (write(sock, filename, strlen(filename)) < 0)
		perror("write");
	
	memset(buf, 0, sizeof(buf));
	if ((bread = read(sock, buf, sizeof(buf))) > 0)
	{
		if (strchr(buf, '\n'))
			*strchr(buf, '\n') = '\0';
	
		/* Don't ask... */
		if (strchr(filename, '\n'))
			*strchr(filename, '\n') = '\0';

		if (buf[0] == '1')
		{
			char *vname = buf+2;
			printf("FILE INFECTED: [%s] (VIRUS: %s)\n", filename, vname);
		}
			
		else if (!strncmp(buf, "-1", 2))
		{
			char *errmsg = buf+3;
			printf("FILE ERROR [%s] (-1 received)\n", errmsg);
		}
		else
		{
			printf("FILE NOT INFECTED: [%s]\n", filename);
		}
	}
	else
	{
		printf("Ouch! read() from the socket failed :(\n");
	}

	close(sock);
	exit(0);

}
