#!/usr/bin/perl

use IO::Socket;
use strict;
$|=1;

my $hostname = $ARGV[0] || die "Usage: $0 <hostname> <filename> [<port>]\n";
my $filename = $ARGV[1] || die "Usage: $0 <hostname> <filename> [<port>]\n";
my $port = $ARGV[2] || 4009;

die "Filename '$filename' doesn't exist\n" if (! -e $filename);

my $response;
my $buffer;
my $buffer_size = 4096;
my $c = 1;

my $proto = getprotobyname('tcp');
my $in_addr = (gethostbyname($hostname))[4];
my $addr = sockaddr_in($port, $in_addr);

socket(SOCK, AF_INET, SOCK_STREAM, $proto) || die "Couldn't create socket ($!)\n";
connect(SOCK, $addr) || die "Couldn't connect() to the socket ($!)\n";

my $filesize = (stat($filename))[7];
my ($sendfile) = ($filename =~ m/^.*\/(.*)/);
my $sendmsg = "$sendfile/$filesize\n";
syswrite(SOCK, $sendmsg, length($sendmsg));

print "sendmsg = $sendmsg";

my $resp;
sysread(SOCK, $resp, 256);
$resp =~ s/[\r\n]//g;
if ($resp eq "OK")
{
	print "sending file.\n";
}
else
{
	print "'OK' not received by remote Sophie. Aborting.\n";
	exit;
}

open(INFILE, $filename) || die "Couldn't open filename '$filename'\n";
my $written = 0;
while($c > 0)
{
	$c = sysread(INFILE, $buffer, $buffer_size);

	if ($c != 0)
	{
		my $x = syswrite(SOCK, $buffer, length($buffer));
		$written += $x;
	}
}
close(INFILE);

sysread(SOCK, $resp, 256);
$resp =~ s/[\r\n]//g;
print "Response: [$resp]\n";

$sendmsg = "QUIT\n";
syswrite(SOCK, $sendmsg, length($sendmsg));

close(SOCK);
