#!/usr/bin/perl

use IO::Socket;
use strict;
$|=1;

my $hostname = $ARGV[0] || die "Usage: $0 <hostname> <dir> [<port>]\n";
my $dir = $ARGV[1] || die "Usage: $0 <hostname> <dir> [<port>]\n";
my $port = $ARGV[2] || 4009;

die "Directory '$dir' doesn't exist\n" if (! -d $dir);

my $response;
my $buffer;
my $buffer_size = 4096;

my $proto = getprotobyname('tcp');
my $in_addr = (gethostbyname($hostname))[4];
my $addr = sockaddr_in($port, $in_addr);

socket(SOCK, AF_INET, SOCK_STREAM, $proto) || die "Couldn't create socket ($!)\n";
connect(SOCK, $addr) || die "Couldn't connect() to the socket ($!)\n";

opendir(DIR, $dir);
my @files = readdir(DIR);
closedir(DIR);

my $fullfile;
foreach my $file (@files)
{
	my $c = 1;
	$fullfile = "$dir/$file";
	next if (! -f $fullfile);

	my $filesize = (stat($fullfile))[7];
	my ($sendfile) = ($fullfile =~ m/^.*\/(.*)/);
	my $sendmsg = "$sendfile/$filesize\n";
	syswrite(SOCK, $sendmsg, length($sendmsg));

	my $resp;
	sysread(SOCK, $resp, 256);
	$resp =~ s/[\r\n]//g;
	if ($resp eq "OK")
	{
		print "Sending file: '$file'\n";
	}
	else
	{
		print "'OK' not received by remote Sophie. Aborting.\n";
		exit;
	}

	open(INFILE, $fullfile) || die "Couldn't open filename '$file'\n";
	my $written = 0;
	while($c > 0)
	{
		$c = sysread(INFILE, $buffer, $buffer_size);
		if ($c != 0)
		{
			my $x = syswrite(SOCK, $buffer, length($buffer));
			$written += $x;
		}
	}
	close(INFILE);

	sysread(SOCK, $resp, 256);
	$resp =~ s/[\r\n]//g;
	print "Response: [$resp]\n";
}

print SOCK "QUIT\n";

close(SOCK);
