# hostSentry - Login Anomaly Detector TTY State Database Methods
#
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 10-6-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# $Id: hostSentryTTYDB.py,v 1.1 1999/03/22 04:56:54 crowland Exp crowland $


from hostSentryCore import *
import hostSentryConfig
import hostSentryTTY
import hostSentryLog

import sys
import shelve

class hostSentryTTYDB(hostSentryCore):

	def __init__(self, dbFile = None):
		self.setLogLevel()
		self.dbFile = dbFile
		self.dbHandle = None


#########################################
# open Method
#
# Opens DB.
#########################################
        def open(self, dbFile = None):
                if dbFile != None:
                        self.dbFile = dbFile
                if self.dbFile == None:
                        raise hostSentryError('adminalert: TTY database file not specified.')

                if self.getLogLevel() > 0:
                        hostSentryLog.log('debug: hostSentryTTYDB: open: opening database: ' + self.dbFile)

                try:
                        self.dbHandle = shelve.open(self.dbFile)   
                except:
                        raise hostSentryError(sys.exc_value)

#########################################
# store Method
#
# Store TTY object
#########################################
	def store(self, hostSentryTtyObj):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryTTYDB: store: storing login in tty database: ' + hostSentryTtyObj.getLoginStamp())

		# DB not open yet. Do it now.
		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		self.dbHandle[hostSentryTtyObj.getTty()] = hostSentryTtyObj

#########################################
# get Method
# 
# gets TTY object.
#########################################
	def get(self, tty):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryTTYDB: get: retrieving tty from database: ' + tty)

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		return self.dbHandle[tty]

#########################################
# delete Method
# 
# deletes TTY object.
#########################################
	def delete(self, tty):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryTTYDB: delete: deleting TTY session from database: ' + tty)

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		del self.dbHandle[tty]

#########################################
# exists Method
#
# check if TTY object exists in DB
#########################################
	def exists(self, tty):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryTTYDB: exists: checking for TTY in database: ' + tty)

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		return	self.dbHandle.has_key(tty)


#########################################
# dump Method
# 
# dump all DB records
#########################################
	def dump(self):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryTTYDB: dump: dumping all TTY keys from database.')

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		return self.dbHandle.keys()


#########################################
# close Method
#
# closes db.   
#########################################
	def close(self):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryTTYDB: close: closing TTY database: ' + self.dbFile)

		if self.dbHandle == None:
			return
		else:
			self.dbHandle.close()
		

if __name__ == '__main__':

	tty = sys.argv[1]
	testObj = hostSentryTTY.hostSentryTTY()

	test=hostSentryTTYDB('/tmp/test.tty')
	test.setLogLevel(99)
	test.open()

	testObj.setTty(tty)
	testObj.setLoginStamp('nobody@127.0.0.1@hostname.com@98080808')
	print 'TTY: ' + testObj.getTty()

	if test.exists(tty):
		print 'TTY ' + tty + ' already exists in database. Skipping'
	else:
		print 'TTY ' + tty + ' does NOT exist in database. Adding.'
		test.store(testObj)

	ttys = test.dump()
	totalTtys = 0

	for x in range(len(ttys)):
		testRetObj = test.get(ttys[x])
		totalTtys = totalTtys + 1
		print ''
		print 'Retrieved TTY: ' + testRetObj.getTty()
		print 'Login Stamp: ' + testRetObj.getLoginStamp()
		print ''
		print 'Total Ttys: %d' % totalTtys		


	print 'Deleting TTY Entry: ' + testObj.getTty()
	test.delete(testObj.getTty())

	if test.exists(tty):
		print 'TTY ' + tty + ' not removed from database.'
	else:
		print 'TTY ' + tty + ' successfully removed from database.'

	test.close()
