# Read "ReadMe.txt" for ...

push @plugins, 'httpd';
push @plugins, 'h8080';

sub h8080 {
$httpd_host = shift;
&httpd($httpd_host, 8080);
}

sub httpd {
$httpd_host = shift;
$httpd_port = shift;
$httpd_port = 80 if (!$httpd_port); 
if($debug) { print "Checking for httpd:$httpd_port ...\n"; }
$server="";
$remote = $httpd_host; $port = $httpd_port;
$iaddr = inet_aton($remote) || return 0;
$paddr = sockaddr_in($port, $iaddr);
$proto = getprotobyname('tcp');
socket(sock, PF_INET, SOCK_STREAM, $proto) || return 0;
connect(sock, $paddr) || return 0;
send(sock, "HEAD / HTTP/1.0\r\nConnection: close\r\n\r\n", 0);

while(<sock>) {
    if (/^Server: (.*)/) {
	$server=$1;
    }
}
close sock; chomp $server;
if(!$server) { return; }
$_=$server;
    if(/ncsa/i && /1.3/) {
	print "[$httpd_host] - [NCSA 1.3]\n";
	print LOG "[$httpd_host] - [NCSA 1.3]\n";
	return;
    }
    if(/ncsa/i && /1.4.1/) {
	print "[$httpd_host] - [NCSA 1.4.1]\n";
	print LOG "[$httpd_host] - [NCSA 1.4.1]\n";
	return;
    }
    if(/ncsa/i && /1.4.2/) {
	print "[$httpd_host] - [NCSA 1.4.2]\n";
	print LOG "[$httpd_host] - [NCSA 1.4.2]\n";
	return;
    }
    if(/ncsa/i && /1.5.1/) {
	print "[$httpd_host] - [NCSA 1.5.1]\n";
	print LOG "[$httpd_host] - [NCSA 1.5.1]\n";
	return;
    }
    if(/ncsa/i && /1.5.2/) {
	print "[$httpd_host] - [NCSA 1.5.2]\n";
	print LOG "[$httpd_host] - [NCSA 1.5.2]\n";
	return;
    }
    if(/ncsa/i && /1.4/) {
	print "[$httpd_host] - [NCSA 1.4]\n";
	print LOG "[$httpd_host] - [NCSA 1.4]\n";
	return;
    }
    if(/ncsa/i && /1.5/) {
	print "[$httpd_host] - [NCSA 1.5]\n";
	print LOG "[$httpd_host] - [NCSA 1.5]\n";
	return;
    }
    if(/dwhttpd/i && /3.1a4/) {
	print "[$httpd_host] - [dwhttpd 3.1a4]\n";
	print LOG "[$httpd_host] - [dwhttpd 3.1a4]\n";
	return;
    }
    if(/ews/i && /1.1/) {
	print "[$httpd_host] - [EWS 1.1]\n";
	print LOG "[$httpd_host] - [EWS 1.1]\n";
	return;
    }
    if(/microsoft-iis/i && /([1-4]).0/) {
	print "[$httpd_host] - [Microsoft-IIS $1.0]\n";
	print LOG "[$httpd_host] - [Microsoft-IIS $1.0]\n";
	return;
    }
    if(/vqserver/i) {
	print "[$httpd_host] - [VqServer]\n";
	print LOG "[$httpd_host] - [VqServer]\n";
	return;
    }
    if(/alibaba/i && /([2-3]).0/) {
	print "[$httpd_host] - [Alibaba $1.0]\n";
	print LOG "[$httpd_host] - [Alibaba $1.0]\n";
	return;
    }
    if(/teamtrack/i && /3.00/) {
	print "[$httpd_host] - [TeamTrack 3.00]\n";
	print LOG "[$httpd_host] - [TeamTrack 3.00]\n";
	return;
    }
    # Check out http://www.legion2000.cc/ (Under "INFO") for
    # more information ...
    if(/jweb/i && /1.([0-5])/) {
	print "[$httpd_host] - [JWeb 1.$1]\n";
	print LOG "[$httpd_host] - [JWeb 1.$1]\n";
	return;
    }
    if(/falcon/i && /1.0.0.1006/) {
	print "[$httpd_host] - [Falcon Web Server 1.0.0.1006]\n";
	print LOG "[$httpd_host] - [Falcon Web Server 1.0.0.1006]\n";
	return;
    }
    if(/url live/i && /1.0/) {
	print "[$httpd_host] - [URL Live! 1.0]\n";
	print LOG "[$httpd_host] - [URL Live! 1.0]\n";
	return;
    }
    if(/thttpd/i && /2.04/) {
	print "[$httpd_host] - [THTTPD 2.04]\n";
	print LOG "[$httpd_host] - [THTTPD 2.04]\n";
	return;
    }
    if(/eserv/i && /2.50/) {
	print "[$httpd_host] - [EServ 2.50]\n";
	print LOG "[$httpd_host] - [EServ 2.50]\n";
	return;
    }
    if(/lotus domino/i && /4.6.([4-6])/) {
	print "[$httpd_host] - [Lotus Domino Server 4.6.$1]\n";
	print LOG "[$httpd_host] - [Lotus Domino Server 4.6.$1]\n";
	return;
    }
    if(/sambar/i && /4.2.1/) {
	print "[$httpd_host] - [Sambar 4.2.1]\n";
	print LOG "[$httpd_host] - [Sambar 4.2.1]\n";
	return;
    }
    if(/zbserver/i && /1.5/) {
	print "[$httpd_host] - [ZBServer 1.5]\n";
	print LOG "[$httpd_host] - [ZBServer 1.5]\n";
	return;
    }
    if(/savant/i && /2.0/) {
	print "[$httpd_host] - [Savant Web Server 2.0]\n";
	print LOG "[$httpd_host] - [Savant Web Server 2.0]\n";
	return;
    }
    if(/camshot webcam/i && /2.5/) {
	print "[$httpd_host] - [CamShot WebCam 2.5]\n";
	print LOG "[$httpd_host] - [CamShot WebCam 2.5]\n";
	return;
    }
    if(/netscape fasttrack/i && /2.01a/) {
	print "[$httpd_host] - [Netscape FastTrack 2.01a]\n";
	print LOG "[$httpd_host] - [Netscape FastTrack 2.01a]\n";
	return;
    }
    if(/apache/i && /0.8.([0-99])/) {
	print "[$httpd_host] - [Apache Web Server 0.8.$1]\n";
	print LOG "[$httpd_host] - [Apache Web Server 0.8.$1]\n";
	return;
    }
    if(/apache/i && /1.0.([0-9])/) {
	print "[$httpd_host] - [Apache Web Server 1.0.$1]\n";
	print LOG "[$httpd_host] - [Apache Web Server 1.0.$1]\n";
	return;
    }
}
print;