/*
** Russian codepages recognition v.3.11
** (c)w_re -- Oleg A. Paraschenko
** Please visit http://beta.math.spbu.ru/~prof/w_re/ for more information.
** You can contact author by E-MAIL prof@beta.math.spbu.ru
** Return:
**  255:error  0:Can't guess   11:alt  12:koi  13:win 14:mac
** Flag '-s'	disables output and allow windows to close whatrus console.
** Flag '-h'	couse help ouput
*/

#ifndef _FOR_DOS_
#ifndef _FOR_UNIX_
#ifndef _FOR_WIN_
#error It is must be defined _FOR_DOS_, _FOR_WIN_ or _FOR_UNIX_
#endif
#endif
#endif
#ifdef _FOR_DOS_
#ifdef _FOR_UNIX_
#error It is cant be defined both _FOR_DOS_ and _FOR_UNIX_
#endif
#endif
#ifdef _FOR_WIN_
#ifdef _FOR_UNIX_
#error It is cant be defined both _FOR_WIN_ and _FOR_UNIX_
#endif
#endif
#ifdef _FOR_DOS_
#ifdef _FOR_WIN_
#error It is cant be defined both _FOR_DOS_ and _FOR_WIN_
#endif
#endif

#ifdef _FOR_WIN_
	#include <windows.h>
	#include <stdio.h>
   #include	<conio.h>
#endif
#ifdef _FOR_DOS_
	#include <stdio.h>
	#include <io.h>
	#include <fcntl.h>
#endif
#ifdef _FOR_UNIX_
	#include <unistd.h>
	#include <fcntl.h>
	#define O_BINARY 0
#endif

/*
** buf - .
** cur -      .
** ch  -  .
*/
#define bufSize 4096
unsigned char	buf[bufSize];
unsigned	char	*cur;
unsigned	char	ch;
/*
**    -  - .
*/
#ifdef _FOR_WIN_
	SECURITY_ATTRIBUTES sec_attr = {
		sizeof (SECURITY_ATTRIBUTES), NULL, FALSE
	};
#else
	#define HANDLE int
	#define DWORD int
	#define INVALID_HANDLE_VALUE -1
#endif
HANDLE	fin;
DWORD		bytesReaded;
int		i;
/*
**    -
** 1 -     
** 2 -   
** 3 -    'jo'
*/
unsigned long	alt1 = 0,	alt2 = 0,	alt3 = 0;
unsigned long	koi1 = 0,	koi2 = 0,	koi3 = 0;
unsigned long	win1 = 0,	win2 = 0,	win3 = 0;
unsigned long	mac1 = 0,	mac2 = 0,	mac3 = 0;
/*
** ,  .
*/
unsigned long	altScore = 0,	koiScore = 0,
					macScore = 0,	winScore = 0;

int
main (int argc, char *argv[]) {
	int	silence	= 0;
	int	findex	= 1;
	int	ccode		= 255;
	/*
	**  .
	*/
	if (argc < 2)	goto PrintHelp;
	if (argc > 3)	goto PrintHelp;
	if (argc == 3) {
		ch = *argv[1];
		if ((ch != '-') && (ch != '/'))
				goto PrintHelp;
		ch = *(argv[1] + 1);
		if ((ch != 's') && (ch!='S'))
				goto PrintHelp;
		silence	= 1;
		findex	= 2;
	};
	/*
	**   .
	*/
	#ifdef _FOR_UNIX_
	fin	= open (argv[findex], O_RDONLY);
	#endif
	#ifdef _FOR_DOS_
	fin	= open (argv[findex], O_RDONLY|O_BINARY);
	#endif
	#ifdef _FOR_WIN_
	fin	=	CreateFile (argv[findex], GENERIC_READ, FILE_SHARE_READ,
				&sec_attr, OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,
				INVALID_HANDLE_VALUE);
	#endif
	if (fin == INVALID_HANDLE_VALUE) {
		if (!silence) {
			printf ("Can't open file %s\n", argv[findex]);
		};
		return 255;
	};
	while (1) {
		/*
		**    .
		*/
		#ifdef _FOR_WIN_
			if (!ReadFile (fin, buf, bufSize, &bytesReaded, NULL)) {
				CloseHandle (fin);
				if (!silence)
					printf ("Error reading from file %s\n", argv[findex]);
				ccode = 255;
				goto exit_proc;
			};
		#else
			bytesReaded = read (fin, buf, bufSize);
			if (bytesReaded == -1) {
				close(fin);
			if (!silence)
				printf ("Error reading from file %s\n", argv[findex]);
				ccode = 255;
				goto exit_proc;
			};
		#endif
		if (!bytesReaded)
			goto countScores;
		/*
		**   .   cas  ,
		**       .  ,
		**        
		**   .
		*/
		cur = buf;
		for (i = 0; i < bytesReaded; i++) {
			ch = *cur++;
			/*
			**     .
			** alt:	80-af, e0-f1
			** koi:	c0-ff
			** mac:	80-9f, e0-fe, dd, de, df
			** win:	c0-ff, a8, b8
			*/
			if (ch < 0x80)		continue;
			if (ch < 0xb0)								alt1++;
			if ((ch >= 0xe0) && (ch <= 0xf1))	alt1++;
			if (ch >= 0xc0) {
															koi1++;
															win1++;	};
			if ((ch >= 0x80) && (ch <  0xa0))	mac1++;
			if ((ch >= 0xe0) && (ch < 0xff))		mac1++;
			switch (ch) {
				case 0xdd: case 0xde: case 0xdf:
					{ mac1++; break; };
				case 0xa8: case 0xb8:
					{ win1++; break; };
			};
			/*
			**     
			**  :
			**			,  ,  ,  ,  ,  ,  ,  ,  ,  .
			** alt:	80, 85, f0, 88, 8e, 93, 9b, 9d, 9e, 9f
			**		 	a0, a5, f1, a8, ae, e3, eb, ed, ee, ef
			** koi:	e1, e5, e5, e9, ef, f5, f9, fc, e0, f1
			**		 	c1, c5, c5, c9, cf, d5, d9, dc, c0, d1
			** mac:	80, 85, dd, 88, 8e, 93, 9b, 9d, 9e, 9f
			**			e0, e5, de, e8, ee, f3, fb, fd, fe, df
			** win:	c0, c5, a8, c8, ce, d3, db, dd, de, df
			**			e0, e5, b8, e8, ee, f3, fb, fd, fe, ff
			*/
			switch (ch) {
				case 0x80: case 0x85: case 0xf0: case 0x88: case 0x8e:
				case 0x93: case 0x9b: case 0x9d: case 0x9e: case 0x9f:
				case 0xa0: case 0xa5: case 0xf1: case 0xa8: case 0xae:
				case 0xe3: case 0xeb: case 0xed: case 0xee: case 0xef:
					{ alt2++; break; };
			};
			switch (ch) {
				case 0xe1: case 0xe5:				case 0xe9: case 0xef:
				case 0xf5: case 0xf9: case 0xfc: case 0xe0: case 0xf1:
				case 0xc1: case 0xc5:				case 0xc9: case 0xcf:
				case 0xd5: case 0xd9: case 0xdc: case 0xc0: case 0xd1:
					{ koi2++; break; };
			};
			switch (ch) {
				case 0x80: case 0x85: case 0xdd: case 0x88: case 0x8e:
				case 0x93: case 0x9b: case 0x9d: case 0x9e: case 0x9f:
				case 0xe0: case 0xe5: case 0xde: case 0xe8: case 0xee:
				case 0xf3: case 0xfb: case 0xfd: case 0xfe: case 0xdf:
					{ mac2++; break; };
			};
			switch (ch) {
				case 0xc0: case 0xc5: case 0xa8: case 0xc8: case 0xce:
				case 0xd3: case 0xdb: case 0xdd: case 0xde: case 0xdf:
				case 0xe0: case 0xe5: case 0xb8: case 0xe8: case 0xee:
				case 0xf3: case 0xfb: case 0xfd: case 0xfe: case 0xff:
					{ win2++; break; };
			};
			/*
			**     'jo'.
			** alt: f0, f1
			** koi: e5, c5 //     koi-8 'jo' ,   'e'.
			** mac: dd, de
			** win: a8, b8
			*/
			switch (ch) {
				case 0xf0: case 0xf1:
					{ alt3++; break; };
				case 0xe5: case 0xc5:
					{ koi3++; break; };
				case 0xdd: case 0xde:
					{ mac3++; break; };
				case 0xa8: case 0xe8:
					{ win3++; break; };
			};
		};	/* for (i = 0; i < bytesReaded; i++) */
	};		/* while (1) */
countScores:
	/*
	**   .
	*/
	#ifdef _FOR_WIN_
		CloseHandle (fin);
	#else
		close (fin);
	#endif
	/*
	**         .
	** 2 	-     'jo'
	** 3 	-      
	** 4 	-    
	*/
	if ((alt3 >= koi3) && (alt3 >= mac3) && (alt3 >= win3))	altScore += 2;
	if ((koi3 >= alt3) && (koi3 >= mac3) && (koi3 >= win3))	koiScore += 2;
	if ((mac3 >= alt3) && (mac3 >= koi3) && (mac3 >= win3))	macScore += 2;
	if ((win3 >= alt3) && (win3 >= koi3) && (win3 >= mac3))	winScore += 2;
	if ((alt1 >= koi1) && (alt1 >= mac1) && (alt1 >= win1))	altScore += 3;
	if ((koi1 >= alt1) && (koi1 >= mac1) && (koi1 >= win1))	koiScore += 3;
	if ((mac1 >= alt1) && (mac1 >= koi1) && (mac1 >= win1))	macScore += 3;
	if ((win1 >= alt1) && (win1 >= koi1) && (win1 >= mac1))	winScore += 3;
	if ((alt2 >= koi2) && (alt2 >= mac2) && (alt2 >= win2))	altScore += 4;
	if ((koi2 >= alt2) && (koi2 >= mac2) && (koi2 >= win2))	koiScore += 4;
	if ((mac2 >= alt2) && (mac2 >= koi2) && (mac2 >= win2))	macScore += 4;
	if ((win2 >= alt2) && (win2 >= koi2) && (win2 >= mac2))	winScore += 4;
	/*
	**     ...
	**    ANSI C (#)  
	**     .
	**  D    "altScore = 9".
	*/
	#ifdef _DEBUG_
		#define D(x) printf ("%s = %ld\n", #x, x)
		D (alt1);
		D (koi1);
		D (mac1);
		D (win1);
		D (alt2);
		D (koi2);
		D (mac2);
		D (win2);
		D (alt3);
		D (koi3);
		D (mac3);
		D (win3);
		D (altScore);
		D (koiScore);
		D (macScore);
		D (winScore);
	#endif
	/*
	**      -   .
	*/
	if (	(altScore > koiScore)	&&
			(altScore > macScore)	&&
			(altScore > winScore)
		) {
		if (!silence)
			printf("ALT detected.\n");
		ccode = 11;
		goto exit_proc;
	};
	if (	(koiScore > altScore)	&&
			(koiScore > macScore)	&&
			(koiScore > winScore)
		) {
		if (!silence)
			printf("KOI detected.\n");
		ccode = 12;
		goto exit_proc;
	};
	if (	(macScore > altScore)	&&
			(macScore > koiScore)	&&
			(macScore > winScore)
		) {
		if (!silence)
			printf("MAC detected.\n");
		ccode = 14;
		goto exit_proc;
	};
	if (	(winScore > altScore)	&&
			(winScore > koiScore)	&&
			(winScore > macScore)
		) {
		if (!silence)
			printf("WIN detected.\n");
		ccode = 13;
		goto exit_proc;
	};
	if (!silence)
		printf("Can't detect coding.\n");
	ccode = 0;
	goto exit_proc;
	/*
	**   .
	*/
PrintHelp:
	printf ("Recognizer of Rusian codepages, v.3.11.\n");
	printf ("Usage:\n");
	printf (" $whatrus [-s] <filename>\n");
	printf ("Flag '-s' is used to avoid messages.\n");
	printf ("          in windows version: close window after whatrus finished.\n");
	printf ("Return codes:\n");
	printf ("255: error detected.\n");
	printf ("  0: can't detect encoding.\n");
	printf (" 11: ALT detected.\n");
	printf (" 12: KOI detected.\n");
	printf (" 13: WIN detected.\n");
	printf (" 14: MAC detected.\n");
	printf ("(c)w_re -- Oleg A. Paraschenko.\n");
	printf ("prof@beta.math.spbu.ru\n");
	printf ("http://beta.math.spbu.ru/~prof/w_re/\n");
	ccode = 255;
exit_proc:
	/*
	**  windows-     .
	**  ,    whatrus, ,
	**     .
	*/
	#ifdef _FOR_WIN_
	if (!silence) {
		SetConsoleTitle ("Whatrus finished. Press any key to close this window.");
		getch ();
	};
	#endif
	return ccode;
};

