/*
** parser.h -    rusconv.c.
**     .
**   - 14  1998 .
** (c)w_re --  .
*/

/*
**  set_xxx_suffix    ,  
**      .   
**      xxx.
**  :
**  argi       -    
**  argv, argc -   main()
**  :
**    - 0,   - !0.
*/
int
set_alt_suffix (void) {
   int   ccode = 0;
   argi++;
   /*
   **       ( 
   ** ,   - 
   */
   if (argi == argc) {
      print_no_ext_arg ("aext");
      ccode = 1;
      goto exit_proc;
   };
   /*
   **    ,    - 
   */
   if (alt_suff != NULL) {
      print_ext_redefined ("aext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   /*
   **     
   */
   if (strlen (argv[argi]) + 1 > ext_size) {
      print_ext_too_long ("aext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   /*
   **    ,  
   */
   strcpy (alt_suff_user, ".");
   strcat (alt_suff_user, argv[argi]);
   alt_suff = alt_suff_user;
   ccode = 0;
exit_proc:
   /*
   **   -       
   **  parse_args().    ,  find_flag_and_set()
   **   ,     : '/', '-'  '+'.
   **   ,      .  
   **   ,  parse_args()    ,
   **    .    
   **  ...
   */
   if (ccode) {
      flag_silence = 1;
   };
   return ccode;
}; /* set_alt_suffix() */

int
set_koi_suffix (void) {
   int   ccode = 0;
   argi++;
   if (argi == argc) {
      print_no_ext_arg ("kext");
      ccode = 1;
      goto exit_proc;
   };
   if (koi_suff != NULL) {
      print_ext_redefined ("kext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   if (strlen (argv[argi]) > ext_size) {
      print_ext_too_long ("kext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   strcpy (koi_suff_user, ".");
   strcat (koi_suff_user, argv[argi]);
   koi_suff = koi_suff_user;
   ccode = 0;
exit_proc:
   if (ccode) {
      flag_silence = 1;
   };
   return ccode;
}; /* set_koi_suffix() */

int
set_mac_suffix (void) {
   int   ccode = 0;
   argi++;
   if (argi == argc) {
      print_no_ext_arg ("mext");
      ccode = 1;
      goto exit_proc;
   };
   if (mac_suff != NULL) {
      print_ext_redefined ("mext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   if (strlen (argv[argi]) > ext_size) {
      print_ext_too_long ("mext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   strcpy (mac_suff_user, ".");
   strcat (mac_suff_user, argv[argi]);
   mac_suff = mac_suff_user;
   ccode = 0;
exit_proc:
   if (ccode) {
      flag_silence = 1;
   };
   return ccode;
}; /* set_mac_suffix() */

int
set_win_suffix (void) {
   int   ccode = 0;
   argi++;
   if (argi == argc) {
      print_no_ext_arg ("wext");
      ccode = 1;
      goto exit_proc;
   };
   if (win_suff != NULL) {
      print_ext_redefined ("wext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   if (strlen (argv[argi]) > ext_size) {
      print_ext_too_long ("wext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   strcpy (win_suff_user, ".");
   strcat (win_suff_user, argv[argi]);
   win_suff = win_suff_user;
   ccode = 0;
exit_proc:
   if (ccode) {
      flag_silence = 1;
   };
   return ccode;
}; /* set_win_suffix() */

int
set_lat_suffix (void) {
   int   ccode = 0;
   argi++;
   if (argi == argc) {
      print_no_ext_arg ("lext");
      ccode = 1;
      goto exit_proc;
   };
   if (lat_suff != NULL) {
      print_ext_redefined ("lext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   if (strlen (argv[argi]) > ext_size) {
      print_ext_too_long ("lext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   strcpy (lat_suff_user, ".");
   strcat (lat_suff_user, argv[argi]);
   lat_suff = lat_suff_user;
   ccode = 0;
exit_proc:
   if (ccode) {
      flag_silence = 1;
   };
   return ccode;
}; /* set_lat_suffix() */

int
set_any_suffix (void) {
   int   ccode = 0;
   argi++;
   if (argi == argc) {
      print_no_ext_arg ("ext");
      ccode = 1;
      goto exit_proc;
   };
   if (any_suff != NULL) {
      print_ext_redefined ("ext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   if (strlen (argv[argi]) > ext_size) {
      print_ext_too_long ("ext", argv[argi]);
      ccode = 1;
      goto exit_proc;
   };
   strcpy (any_suff_user, ".");
   strcat (any_suff_user, argv[argi]);
   any_suff = any_suff_user;
   ccode = 0;
exit_proc:
   if (ccode) {
      flag_silence = 1;
   };
   return ccode;
}; /* set_any_suffix() */

/*
**    :
** "",    ,    .
**   - NULL   .
**   ,   
** ,   .
*/
void *minus_table[]={
 "?",        &flag_help,      NULL, /*   */
 "h",        &flag_help,      NULL, /*   */
 "-help",    &flag_help,      NULL, /*   */
 "alt",      &flag_from_alt,  NULL, /*     */
 "koi",      &flag_from_koi,  NULL, /*    -8 */
 "win",      &flag_from_win,  NULL, /*    Windows */
 "mac",      &flag_from_mac,  NULL, /*    Macintosh */
 "cr2crlf",  &flag_cr2crlf,   NULL, /*  UNIX-   DOS- */
 "crlf2cr",  &flag_crlf2cr,   NULL, /*  DOS-   UNIX- */
 "dos2unix", &flag_d2u,       NULL, /*   '-alt +koi -crlf2cr' */
 "unix2dos", &flag_u2d,       NULL, /*   '-koi +alt -cr2crlf' */
 "win2unix", &flag_w2u,       NULL, /*   '-win +koi -crlf2cr' */
 "unix2win", &flag_u2w,       NULL, /*   '-koi +win -cr2crlf' */
 "d2u",      &flag_d2u,       NULL, /* == dos2unix */
 "u2d",      &flag_u2d,       NULL, /* == unix2dos */
 "w2u",      &flag_w2u,       NULL, /* == win2unix */
 "u2w",      &flag_u2w,       NULL, /* == unix2win */
 "o",        &flag_overwrite, NULL, /*   */
 "s",        &flag_silence,   NULL, /*     */
 "v",        &flag_verbose,   NULL, /*    */
 "close",	 &flag_close,		NULL,	/*      */
 "noclose",	 &flag_noclose,	NULL,	/*  -'-    windows- */
 "aext",     NULL, set_alt_suffix, /*    */
 "kext",     NULL, set_koi_suffix, /*   -8 */
 "mext",     NULL, set_mac_suffix, /*   Macintosh */
 "lext",     NULL, set_lat_suffix, /*    */
 "wext",     NULL, set_win_suffix, /*   Windows */
 "ext",      NULL, set_any_suffix, /*   */
 NULL }; /* void *minus_table[] */

void *plus_table[]={
 "alt",  &flag_to_alt,  NULL, /*     */
 "koi",  &flag_to_koi,  NULL, /*    -8*/
 "win",  &flag_to_win,  NULL, /*    Windows*/
 "mac",  &flag_to_mac,  NULL, /*    Macintosh*/
 "lat",  &flag_to_lat,  NULL, /*     */
 NULL }; /* void *plus_table[] */

#ifdef _FOR_BC_
void *slash_table[]={
 "?",        &flag_help,      NULL,
 "h",        &flag_help,      NULL,
 "cr2crlf",  &flag_cr2crlf,   NULL,
 "crlf2cr",  &flag_crlf2cr,   NULL,
 "dos2unix", &flag_d2u,       NULL,
 "unix2dos", &flag_u2d,       NULL,
 "win2unix", &flag_w2u,       NULL,
 "unix2win", &flag_u2w,       NULL,
 "d2u",      &flag_d2u,       NULL,
 "u2d",      &flag_u2d,       NULL,
 "w2u",      &flag_w2u,       NULL,
 "u2w",      &flag_u2w,       NULL,
 "o",        &flag_overwrite, NULL,
 "s",        &flag_silence,   NULL,
 "v",        &flag_verbose,   NULL,
 "close",	 &flag_close,		NULL,
 "noclose",	 &flag_noclose,	NULL,
 "aext",    NULL, set_alt_suffix,
 "kext",    NULL, set_koi_suffix,
 "mext",    NULL, set_mac_suffix,
 "lext",    NULL, set_lat_suffix,
 "wext",    NULL, set_win_suffix,
 "ext",     NULL, set_any_suffix,
 NULL }; /* void *slash_table[] */
#endif


/*
**  find_flag_and_set()    tbl (minus_table,
** plus_table  slash_table)    str.   ,
**         - 0,
**    ,    -  .
**    - !0.  UNIX-    
** ,   -   .
*/
int
find_flag_and_set (void* tbl[], char *str) {
   int ccode = 1;
   while (*tbl != NULL) {
      /*
      ** ,    .
      */
      #ifdef _FOR_UNIX_
      if (strcmp (*tbl++, str)) {
         tbl += 2;
         continue;
      };
      #else
      if (strcmpi (*tbl++, str)) {
         tbl += 2;
         continue;
      };
      #endif
      /*
      **     .
      */
      if (*tbl != NULL) {
         *(int*)(*tbl) = 1;
         ccode = 0 ;
         goto exit_proc;
      };
      /*
      **    ,   
      ** .   -    :-)
      */
      tbl++;
      if (*tbl == NULL) {
         print_internal_error (__FILE__, __LINE__);
         ccode = 1;
         break;
      };
      /*
      **   .     
      **   -    .
      */
      ccode = ((int(*)(void))(*tbl))();
      goto exit_proc;
   }; /* while (*tbl != NULL) */
exit_proc:
   return ccode;
}; /* find_flag_and_set (void *tbl[], char *str) */

/*
**  parse_args()     
**   .   argc  argv
**  ,     main().    
**   argi,     
**  -     .
**  :
**   0 -  
**  !0 -  
*/
int
parse_args (void) {
   char ch, *pcur;
   int  ccode = 0;
   /*
   **     .
   */
   flag_from_alt  = 0; flag_from_koi = 0;
   flag_from_mac  = 0; flag_from_win = 0;
   flag_to_alt    = 0; flag_to_koi   = 0;
   flag_to_mac    = 0; flag_to_win   = 0;
   flag_to_lat    = 0;
   flag_cr2crlf   = 0; flag_crlf2cr  = 0;
   flag_u2d       = 0; flag_d2u      = 0;
   flag_u2w       = 0; flag_w2u      = 0;
   flag_help      = 0;
   flag_overwrite = 0;
   flag_silence   = 0; flag_verbose  = 0;
   alt_suff = NULL;  koi_suff = NULL;
   mac_suff = NULL;  lat_suff = NULL;
   win_suff = NULL;
   /*
   **   ,   .
   */
   if (argc == 1)
      flag_help = 1;
   /*
   **   ,   '-', '+'  '/'.
   **      ,   
   **   ,     
   ** .        
   ** ,    ,     
   **  .
   */
   for (argi = 1; argi < argc; argi++) {
      pcur = argv[argi];
      ch   = *pcur++;
      if (ch == '-') {
         /*
         **  '--'   
         */
         if ( (*pcur == '-') && (*(pcur + 1) == '\0') ) {
            argi++;
            ccode = 0;
            goto exit_proc;
         };
         /*
         **  '-'-.
         */
         if (find_flag_and_set (minus_table, pcur)) {
            print_parse_error (argv[argi]);
            ccode = 1;
            break;
         };
         continue;
      };
      /*
      **  '+'-.
      */
      if (ch == '+') {
         if (find_flag_and_set (plus_table, pcur)) {
            print_parse_error (argv[argi]);
            ccode = 1;
            break;
         };
      continue;
      };
      /*
      **  '/'-.   WIN-.
      */
      #ifdef _FOR_BC_
      if (ch == '/') {
         if (find_flag_and_set (slash_table, pcur)) {
            print_parse_error (argv[argi]);
            ccode = 1;
            break;
         };
      continue;
      };
      #endif
      /*
      **         '-', '+'  '/'.
      **    ,   .   .
      */
      ccode = 0;
      break;
   }; /*    for (argi = 1; argi < argc; argi++) */
exit_proc:
   return ccode;
}; /* parse_args (int argc, char *argv[]) */

/*
**     .    ,
**    .
*/
int
validate_flags (void) {
	int ccode = 0;
	/*
	**         -   .
	*/
	if (flag_help) {
		print_internal_error (__FILE__, __LINE__);
		ccode = 1;
		goto exit_proc;
	};
	/*
	**    ,     -  .
	*/
	#ifdef _FOR_WIN_
	if (flag_close && flag_noclose) {
		flag_close = 0;
		print_cant_use_both ("close", "noclose");
		ccode = 1;
		goto exit_proc;
	};
   #endif
	/*
	**      -  .
	*/
	if (flag_verbose && flag_silence) {
		flag_silence = 0;
		print_cant_use_both ("-s", "-v");
		ccode = 1;
		goto exit_proc;
	};
	/*
	**  unix2dos   '-koi +alt -cr2crlf'.
	**   .
	*/
	if (flag_u2d) {
		if (flag_d2u)
			print_cant_use_both ("unix2dos(u2d)", "dos2unix(d2u)");
		if (flag_w2u)
			print_cant_use_both ("unix2dos(u2d)", "win2unix(w2u)");
		if (flag_from_alt)
			print_cant_use_both ("unix2dos(u2d)", "-alt");
		if (flag_from_mac)
			print_cant_use_both ("unix2dos(u2d)", "-mac");
		if (flag_from_win)
			print_cant_use_both ("unix2dos(u2d)", "-win");
		if (flag_crlf2cr)
			print_cant_use_both ("unix2dos(u2d)", "crlf2cr");
		if (flag_d2u       || flag_w2u       ||	flag_from_alt ||
			 flag_from_win  || flag_from_mac  ||	flag_crlf2cr ) {
         ccode = 1;
         goto exit_proc;
      };
   };
   /*
   **  unix2win   '-koi +win -cr2crlf'.
   **   .
	*/
	if (flag_u2w) {
		if (flag_d2u)
			print_cant_use_both ("unix2win(u2w)", "dos2unix(d2u)");
		if (flag_w2u)
			print_cant_use_both ("unix2win(u2w)", "win2unix(w2u)");
		if (flag_from_alt)
			print_cant_use_both ("unix2win(u2w)", "-alt");
		if (flag_from_mac)
			print_cant_use_both ("unix2win(u2w)", "-mac");
		if (flag_from_win)
			print_cant_use_both ("unix2win(u2w)", "-win");
		if (flag_crlf2cr)
			print_cant_use_both ("unix2win(u2w)", "crlf2cr");
		if (flag_d2u       || flag_w2u       || flag_from_alt ||
		    flag_from_win  || flag_from_mac  || flag_crlf2cr ) {
			ccode = 1;
			goto exit_proc;
		};
	};
	/*
	**  win2unix   '-win +koi -crlf2cr'.
	**   .
	*/
	if (flag_w2u) {
		if (flag_d2u)
			print_cant_use_both ("win2unix(w2u)", "dos2unix(d2u)");
		if (flag_u2d)
			print_cant_use_both ("win2unix(w2u)", "unix2dos(u2d)");
		if (flag_u2w)
			print_cant_use_both ("win2unix(w2u)", "unix2win(u2w)");
		if (flag_from_alt)
			print_cant_use_both ("win2unix(w2u)", "-alt");
		if (flag_from_koi)
			print_cant_use_both ("win2unix(w2u)", "-koi");
		if (flag_from_mac)
			print_cant_use_both ("win2unix(w2u)", "-mac");
		if (flag_cr2crlf)
			print_cant_use_both ("win2unix(w2u)", "cr2crlf");
		if (flag_u2d      || flag_d2u       || flag_u2w       ||
			 flag_from_alt || flag_from_koi  || flag_from_mac  ||
			 flag_cr2crlf ) {
			ccode = 1;
			goto exit_proc;
		};
	};
	/*
	**  dos2unix   '-alt +koi -crlf2cr'.
	**   .
	*/
	if (flag_d2u) {
		if (flag_w2u)
			print_cant_use_both ("dos2unix(d2u)", "win2unix(w2u)");
		if (flag_u2d)
			print_cant_use_both ("dos2unix(d2u)", "unix2dos(u2d)");
		if (flag_u2w)
			print_cant_use_both ("dos2unix(d2u)", "unix2win(u2w)");
		if (flag_from_koi)
			print_cant_use_both ("dos2unix(d2u)", "-koi");
		if (flag_from_mac)
			print_cant_use_both ("dos2unix(d2u)", "-mac");
		if (flag_from_win)
			print_cant_use_both ("dos2unix(d2u)", "-win");
		if (flag_cr2crlf)
			print_cant_use_both ("dos2unix(d2u)", "cr2crlf");
		if (flag_w2u      || flag_u2d       || flag_u2w       ||
			 flag_from_koi || flag_from_mac  || flag_from_win  ||
			 flag_cr2crlf ) {
         ccode = 1;
         goto exit_proc;
      };
   };
   /*
   **      .
   */
   if (flag_from_alt && flag_from_koi)
      print_cant_use_both ("-alt", "-koi");
   if (flag_from_alt && flag_from_mac)
      print_cant_use_both ("-alt", "-mac");
   if (flag_from_alt && flag_from_win)
      print_cant_use_both ("-alt", "-win");
   if (flag_from_koi && flag_from_mac)
      print_cant_use_both ("-koi", "-mac");
   if (flag_from_koi && flag_from_win)
      print_cant_use_both ("-koi", "-win");
   if (flag_from_mac && flag_from_win)
      print_cant_use_both ("-mac", "-win");
   if (flag_from_alt + flag_from_koi + flag_from_mac + flag_from_win > 1) {
      ccode = 1;
      goto exit_proc;
   };
   /*
   **        
   */
   if (flag_cr2crlf && flag_crlf2cr) {
      print_cant_use_both ("cr2crlf", "crlf2cr");
      ccode = 1;
      goto exit_proc;
   };
   /*
   **    ,   ,
   **    .
   */
   if (! (flag_from_alt || flag_from_koi ||
			 flag_from_mac || flag_from_win)) {
      /*
		**    ,     - .
		** ,    u2d,u2w,d2u,w2u  '+'.
		*/
		if (flag_to_alt || flag_to_koi ||flag_to_mac ||
			 flag_to_lat || flag_to_win) {
			if (! (flag_u2d   || flag_u2w || flag_d2u || flag_w2u)) {
				print_no_src_coding ();
				ccode = 1;
				goto exit_proc;
			};
		};
		/*
		**    -   'dos2unix',
		**        ,
		**      .
		*/
		if (! (flag_cr2crlf || flag_crlf2cr ||
				 flag_u2d   || flag_u2w || flag_d2u || flag_w2u)) {
			print_no_src_coding ();
			ccode = 1;
			goto exit_proc;
		};
	};
	/*
	**    ,   ,
	**    .
	*/
	if (! (flag_to_alt || flag_to_koi || flag_to_mac ||
			 flag_to_lat || flag_to_win)) {
		/*
		**    ,     - 
		*/
		if (flag_from_alt || flag_from_koi ||
			 flag_from_mac || flag_from_win) {
			print_no_dest_coding ();
			ccode = 1;
			goto exit_proc;
		};
		/*
		**    -   'dos2unix',
		**        ,
		**  ,   ,   .
		*/
		if (! (flag_cr2crlf || flag_crlf2cr ||
				 flag_u2d   || flag_u2w || flag_d2u || flag_w2u)) {
			print_no_dest_coding ();
			ccode = 1;
			goto exit_proc;
		};
	};
	/*
	**      
	**    .
	*/
	if (any_suff) {
		if (alt_suff)  print_cant_use_both ("ext", "aext");
		if (koi_suff)  print_cant_use_both ("ext", "kext");
		if (lat_suff)  print_cant_use_both ("ext", "lext");
		if (mac_suff)  print_cant_use_both ("ext", "mext");
		if (win_suff)  print_cant_use_both ("ext", "wext");
		if (alt_suff || koi_suff || lat_suff || mac_suff || win_suff) {
			ccode = 1;
			goto exit_proc;
		};
	};
	/*
	**        
	**    ,   - .
	*/
	if (any_suff) {
		if (flag_to_alt + flag_to_koi + flag_to_lat +
			 flag_to_mac + flag_to_win > 1) {
			 print_anysuff_manyenc ();
			 ccode = 1;
			 goto exit_proc;
		};
	};
	/*
	** ,    .
	*/
	if (flag_overwrite) {
		if (flag_to_alt + flag_to_koi + flag_to_lat +
			 flag_to_mac + flag_to_win > 1) {
			 print_overwrite_manyenc ();
			 ccode = 1;
			 goto exit_proc;
		};
	};
	/*
	**   .
   */
   ccode = 0;
exit_proc:
   return ccode;
}; /* validate_flags() */

/*
** set_defaults    'unix2dos'  
**  ;     
** 'cr2crlf';  ,  
**   .
*/
int
set_defaults (void) {
   int ccode = 0;
   /*
   ** DOS/WIN-   .
   */
   #ifdef _FOR_BC_
   if (!flag_silence)
      flag_verbose = 1;
   #endif
   /*
   **    '$rusconv -cr2crlf <file list>'
   **   '$rusconv -cr2crlf -alt +alt <file list>'.
   **   .
   */
   if ((flag_cr2crlf || flag_crlf2cr) &&
      ! (flag_from_alt  || flag_from_koi  || flag_from_mac  ||
         flag_from_win  || flag_to_alt    || flag_to_koi    ||
         flag_to_mac    || flag_to_lat    || flag_to_win    ||
         flag_u2d       || flag_u2w       || flag_d2u       ||
         flag_w2u)) {
      flag_from_alt = 1;
      flag_to_alt   = 1;
      /*
      **       
      **      .
      **      'ext <>'.
      */
      if (!any_suff ) {
         if (flag_cr2crlf) {
            #ifdef   _FOR_DOS_
            strcpy (alt_suff_user, ".crl");
            #else
            strcpy (alt_suff_user, ".crlf");
            #endif
            alt_suff = alt_suff_user;
         };
         if (flag_crlf2cr) {
            strcpy (alt_suff_user, ".cr");
            alt_suff = alt_suff_user;
         };
      }; /* if (!alt_suff) */
   };    /* if (flag_cr2crlf || flag_crlf2cr)... */
   /*
   ** dos2unix == '-alt +koi -crlf2cr'
   ** win2unix == '-win +koi -crlf2cr'
   ** unix2dos == '-koi +alt -cr2crlf'
   ** unix2dos == '-koi +alt -cr2crlf'
   */
   if (flag_d2u) {
      flag_from_alt  = 1;
      flag_to_koi    = 1;
      flag_crlf2cr   = 1;
   };
   if (flag_w2u) {
      flag_from_win  = 1;
      flag_to_koi    = 1;
      flag_crlf2cr   = 1;
   };
   if (flag_u2d) {
      flag_from_koi  = 1;
      flag_to_alt    = 1;
      flag_cr2crlf   = 1;
   };
   if (flag_u2w) {
      flag_from_koi  = 1;
      flag_to_win    = 1;
      flag_cr2crlf   = 1;
   };
   /*
   **        .
   */
   if (any_suff) {
      alt_suff = any_suff;
      koi_suff = any_suff;
      lat_suff = any_suff;
      mac_suff = any_suff;
      win_suff = any_suff;
   };
   if (!alt_suff)
      alt_suff = alt_suff_def;
   if (!koi_suff)
      koi_suff = koi_suff_def;
   if (!mac_suff)
      mac_suff = mac_suff_def;
   if (!lat_suff)
      lat_suff = lat_suff_def;
   if (!win_suff)
      win_suff = win_suff_def;
   ccode = 0;
exit_proc:
   return ccode;
}; /* set_defaults() */

