#ifndef LM_LOSTMEM
#define LM_LOSTMEM
/*
** This file useful for lost memory detection.
** Before any malloc/freemem call LM_start(),
** change all 'malloc' on 'Malloc', 'freemme' on
** 'Freemem'. After all call LM_finish();
** Author:
** Oleg A. Paraschenko, prof@beta.math.spbu.ru
*/
#include<stdio.h>
#include<string.h>
#ifdef _FOR_BC_
#include<alloc.h>
#endif

#ifndef LM_DEBUG
#define Malloc(val) malloc(val)
#define Free(val) free(val)
#define LM_start()
#define LM_finish()
#else /* ifdef LM_DEBUG */
#define Malloc(val) LM_malloc(val, __FILE__, __LINE__);
#define Free(val)   LM_free(val, __FILE__, __LINE__);

typedef struct _LM_memNode {
 struct _LM_memNode *prev, *next;
 char *fname;
 int line;
 void *mem; } LM_memNode;

int LM_valid=0,   LM_waserror=0;
LM_memNode *LM_first=NULL, *LM_last=NULL;

void
LM_start(void) {
LM_waserror=0;
LM_valid=1;
LM_first=NULL;
LM_last=NULL; };

void*
LM_malloc(size_t size, char *fname, int line) {
void     *got;
char     *savename;
LM_memNode *node;
got=malloc(size);
if(!got) {
 fprintf(stderr,"** lostmem ** : malloc failed for file %s, line %d\n",fname,line);
 return got; };
if(!LM_valid) return got;
savename=(char *)malloc(strlen(fname)+2);
if(!savename) {
 LM_waserror=1;
 return got; };
node=(LM_memNode *)malloc(sizeof(LM_memNode));
if(!node) {
 LM_waserror=1;
 free(savename);
 return got; };
strcpy(savename,fname);
node->fname=savename;
node->line=line;
node->mem=got;
node->next=NULL;
if(!LM_first) {
 LM_first=LM_last=node;
 node->prev=NULL;
 return got; };
node->prev=LM_last;
LM_last->next=node;
LM_last=node;
return got; };

void
LM_free(void *mem, char *fname, int line) {
LM_memNode *cur;
if(!LM_valid) return;
for(cur=LM_first; cur; cur=cur->next)
 if(cur->mem==mem) break;
if(!cur) {
 fprintf(stderr,"** lostmem ** : bad free in file %s, line %d.\n",fname,line);
 return; };
if(cur->prev) cur->prev->next=cur->next;
if(cur->next) cur->next->prev=cur->prev;
if(cur==LM_first) LM_first=cur->next;
if(cur==LM_last) LM_last=cur->prev;
free(cur->fname);
free(cur);
free(mem); };

void
LM_finish(void) {
LM_memNode *cur, *tmp;
if(!LM_valid) return;
for(cur=LM_first; cur; cur=tmp) {
 fprintf(stderr,"** lostmem ** : lost memory from malloc at file %s, line %d\n",
  cur->fname,cur->line);
 free(cur->fname);
 tmp=cur->next;
 free(cur); };
if(LM_waserror)
 fprintf(stderr,"** lostmem ** : possible not all memory calls were tested.");
LM_valid=0;
LM_waserror=0;
LM_first=NULL;
LM_last=NULL; };

#endif /* #else ( ifdef LM_DEBUG ) */
#endif /* #ifndef LM_LOSTMEM */

