use strict;
use DBI;
use DBI qw(:sql_types);

#
# Connect
#
my $dbh = DBI->connect($ENV{DBI_DSN},
		       $ENV{DBI_USER},
		       $ENV{DBI_PASS},
		       {
			   RaiseError => 1,
			   AutoCommit => 0
                           }
		       ) || die "Database connection failed: $DBI::errstr";

#
# Print list of tables and delete the oob_example table if it exists.
#
my @names = $dbh->tables;
my $sth;
my $sql;
print "Printing tables:\n\n";
for(@names)
{
    print "TABLE: ";
    if ($_ eq "oob_example")
    {
	print $_;
	$sql = qq{drop table oob_example};
	print " - ", $sql, "\n";
	$sth = $dbh->prepare($sql);
	$sth->execute;
        $dbh->commit;
    }
    else
    {
	print $_, "\n";
    }
}
#
# Create a new oob_example table.
#
print "Creating oob_example table\n";
$sql = qq{ CREATE TABLE oob_example (id INTEGER NOT NULL, 
				     name VARCHAR(128), 
				     title VARCHAR(128), 
				     phone VARCHAR(8) 
				     ) };
print $sql, "\n";
$sth = $dbh->prepare($sql);
$sth->execute;
$dbh->commit;
$sth->finish();

my @records = (
	       [ 0, "Larry Wall",      "Perl Author",  "555-0101" ],
	       [ 1, "Tim Bunce",       "DBI Author",   "555-0202" ],
	       [ 2, "Randal Schwartz", "Guy at Large", "555-0303" ],
	       [ 3, "Doug MacEachern", "Apache Man",   "555-0404" ] 
	       );

$sql = qq{ INSERT INTO oob_example VALUES ( ?, ?, ?, ? ) };
$sth = $dbh->prepare( $sql );

for( @records )
{
    eval
    {
	$sth->bind_param( 1, @$_->[0], SQL_INTEGER );
	$sth->bind_param( 2, @$_->[1], SQL_VARCHAR );
	$sth->bind_param( 3, @$_->[2], SQL_VARCHAR );
	$sth->bind_param( 4, @$_->[3], SQL_VARCHAR );
	$sth->execute();
	$dbh->commit();
    };

    if( $@ )
    {
	warn "Database error: $DBI::errstr\n";
	$dbh->rollback(); #just die if rollback is failing
     }
}

$sth->finish();

$sql = qq{ SELECT id, name, title, phone FROM oob_example };
$sth = $dbh->prepare( $sql );
$sth->execute();

my( $id, $name, $title, $phone );
$sth->bind_columns( undef, \$id, \$name, \$title, \$phone );

while( $sth->fetch() ) {
    print "$name, $title, $phone\n";
}
$dbh->commit();
$sth->finish();

$dbh->disconnect();
