#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sql.h>
#include <sqlext.h>

static void extract_error(SQLHANDLE);
static int execute(SQLHANDLE, SQLCHAR *, int);

void extract_error(SQLHANDLE stmt)
{
    SQLINTEGER          i=0;
    SQLINTEGER          native;
    char                state[7];
    SQLCHAR             text[512];
    SQLSMALLINT         len;
    int                 ret;

    do 
    {
        ret = SQLGetDiagRec(SQL_HANDLE_STMT, stmt, ++i,
                            (unsigned char *)state,
                            &native, text, 256, &len);
        if (ret == SQL_SUCCESS || ret==SQL_SUCCESS_WITH_INFO)
            printf( "error %s:%ld:%ld:%s\n", state, i, native, text );
    }
    while(ret == SQL_SUCCESS);
}

int main(int argc, char *argv[])
{
    SQLHANDLE           hEnv;
    SQLHANDLE           hDbc;
    SQLHANDLE           hStmt;
    SQLRETURN           ret;
    SQLCHAR             text[512];
    SQLCHAR             state[7];
    SQLCHAR             sql[10240];
    SQLSMALLINT         len;
    SQLINTEGER          i=0;
    SQLINTEGER          native;
    char                filespec[512];
    FILE                *fp;

    printf("Content-type: text/plain\n\n");
    printf ("<html>\n");

    if (argc > 1)
    {
        fp = fopen(argv[1], "r");
        if (!fp)
        {
            fprintf(stderr, "Unable to open %s\n");
            exit(1);
        }
    }
    else
    {
        fp = stdin;
    }

    ret = SQLAllocHandle( SQL_HANDLE_ENV, 0, &hEnv);
    if (!SQL_SUCCEEDED(ret))
    {
        fprintf(stderr, "Failed to allocate environment handle\n");
        exit(2);
    }
    /* Set ODBC 3.0 behavior */
    SQLSetEnvAttr( hEnv, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3, 0);
    ret = SQLAllocHandle( SQL_HANDLE_DBC, hEnv, &hDbc );
    if (!SQL_SUCCEEDED(ret))
    {
        fprintf(stderr, "Failed to allocate connection handle\n");
        exit(3);
    }

    ret = SQLDriverConnect(hDbc, NULL, (unsigned char *)
                           "DSN=<put your DSN here>", SQL_NTS,
                           text, 256, &len, SQL_DRIVER_COMPLETE);
    if (!SQL_SUCCEEDED(ret))
    {
        do 
        {
            ret = SQLGetDiagRec(SQL_HANDLE_DBC, hDbc, ++i, state, &native,
                                text, 256, &len);
            if (ret == SQL_SUCCESS)
                printf( "error %s:%ld:%ld:%s\n", state, i, native, text);
        }
        while(ret == SQL_SUCCESS);
        exit(4);
    }

    ret = SQLAllocHandle( SQL_HANDLE_STMT, hDbc, &hStmt );
    if (ret != SQL_SUCCESS)
    {
        do 
        {
            ret = SQLGetDiagRec( SQL_HANDLE_DBC, hDbc, ++i, state, &native,
                                 text, 256, &len );
            if (ret == SQL_SUCCESS)
                printf( "error %s:%ld:%ld:%s\n", state, i, native, text );
        }
        while(ret == SQL_SUCCESS);
        exit(5);
    }

    strcpy (sql, "");
    while(fgets(sql, sizeof(sql), fp))
    {
        if (sql[strlen(sql) - 1] == '\n') sql[strlen(sql) - 1] = '\0';
        if (!strlen(sql))
        {
            return 0;
        }
        ret = execute (hStmt, sql, 0);

    }
    SQLFreeHandle( SQL_HANDLE_STMT, hStmt );
    SQLDisconnect( hDbc );
    SQLFreeHandle( SQL_HANDLE_DBC, hDbc );
    SQLFreeHandle( SQL_HANDLE_ENV, hEnv );
    printf("</html>\n");

    return 0;
}

int execute ( 
    SQLHANDLE	hStmt,
    SQLCHAR	*text,
    int		output)
{
    SQLRETURN   ret;
    SQLINTEGER  clen;
    SQLSMALLINT num_cols;
    double      dbl;
    char        tiny;
    int         slong;
    int	        rowcount = 0;
    int         i; 

    ret = SQLExecDirect(hStmt, text, SQL_NTS);
    extract_error(hStmt);

    if (SQL_SUCCEEDED(ret))
    {
	SQLNumResultCols(hStmt, &num_cols);
	if (num_cols > 0)
	{
	    SQLSMALLINT	    DataType[255];
	    SQLCHAR	    ColumnName[255];
	    SQLSMALLINT	    NameLength;
	    SQLUINTEGER	    ColumnSize;
	    SQLSMALLINT	    DecimalDigits;
	    SQLSMALLINT	    Nullable;
            /*
	    ** Output Table Headers
            */ 	
    	    printf ("<TABLE BORDER>\n");
    	    printf ("<TR>\n");

	    for (i = 0; i < num_cols; i++)
	    {
		ret = SQLDescribeCol(hStmt, i + 1, ColumnName, 254,
                                     &NameLength, &DataType[i],
                                     &ColumnSize, &DecimalDigits,
                                     &Nullable );
                printf("<td bgcolor=#000040><font color=#FFFFFF>"
                       "<strong>%s</strong></font></td>\n", ColumnName);
	    }
            printf ("</TR>\n");

	    rowcount = 0;
	    ret = SQLFetch(hStmt);
	    do
	    {
		if (SQL_SUCCEEDED(ret))
		{
		    printf("<TR>\n");
		    rowcount++;
    		    for (i = 0; i < num_cols; i++)
		    {
			switch (DataType[i])
			{
                          case SQL_DOUBLE:
                          {
                              ret = SQLGetData(hStmt, i + 1, SQL_C_DOUBLE,
                                               &dbl, 8, &clen);
                              if (SQL_SUCCEEDED(ret))
                              {
                                  if ( clen >= 0 )
                                      printf( "<TD>%.2f</TD>\n", dbl);
                                  else
                                      printf( "<TD>{NULL}</TD>\n");
                              }
                              break;
                          }
                          case SQL_TINYINT:
                          {
                              ret = SQLGetData( hStmt, i + 1, SQL_C_STINYINT, &tiny, 1, &clen );
                              if (SQL_SUCCEEDED(ret))
                              {
                                  if ( clen >= 0 )
                                      printf( "<TD>%d</TD>\n", tiny);
                                  else
                                      printf( "<TD>{NULL}</TD>\n" );
                              }
                              break;
                          }
                          case SQL_INTEGER:
                          {
                              ret = SQLGetData(hStmt, i + 1, SQL_C_SLONG,
                                               &slong, 4, &clen);
                              if (SQL_SUCCEEDED(ret))
                              {
                                  if (clen >= 0)
                                      printf("<TD>%d</TD>\n", slong);
                                  else
                                      printf("<TD>{NULL}/<TD>\n");
                              }
                              break;
                          }
                          default:
                          {
                              ret = SQLGetData(hStmt, i + 1, SQL_C_CHAR,
                                               text, 254, &clen);
                              if (SQL_SUCCEEDED(ret))
                              {
                                  if (clen >= 0)
                                      printf( "<TD>%s</TD>\n", text );
                                  else
                                      printf( "<TD>{NULL}</TD>" );
                              }
                              break;
                          }
                        }
                    }
                }
                printf("</TR>\n");
                ret = SQLFetch(hStmt);
            } while(ret == SQL_SUCCESS);
            /*
            ** End Table
            */
            printf("</TABLE>\n");
        }
    }
    SQLCloseCursor( hStmt );

    return 0;    
}
