

## Read Configuration File
. $CONFIG_DIR/pmfirewall.conf

case "$1" in

#####START FIREWALL#####
start)
     echo -n "Starting PMFirewall:"
     ## Flush rule sets, start from scratch
     $IPCHAINS -F input
     $IPCHAINS -F output   
     $IPCHAINS -F forward

     ## Read firewall rules
     . $CONFIG_DIR/pmfirewall.rules.1
     . $CONFIG_DIR/pmfirewall.rules.local

     # Allow incoming and outgoing ICMP
     $IPCHAINS -A input -p icmp -s $REMOTENET -d $OUTERNET -j ACCEPT
     $IPCHAINS -A output -p icmp -s $OUTERNET -d $REMOTENET -j ACCEPT
    
     # These are open to sockets created by connections allowed by ipchains
     $IPCHAINS -A input -p tcp -s $REMOTENET -d $OUTERNET 1023:65535 -j ACCEPT
     $IPCHAINS -A input -p udp -s $REMOTENET -d $OUTERNET 1023:65535 -j ACCEPT

     ## Set default policy
     $IPCHAINS -A output -j ACCEPT
     $IPCHAINS -A input -j DENY -l
     echo "		Done!"
     echo ""
     echo "External: $OUTERIF	$OUTERNET"
     echo "" ;;

#####STOP FIREWALL####
stop)
     echo ""
     echo -n "Shutting down PMFirewall:"
     $IPCHAINS -F input
     $IPCHAINS -F output
     $IPCHAINS -F forward
     $IPCHAINS -P forward DENY
     echo "		Done!"
     echo "" ;;

restart)
        $0 stop
        $0 start
        ;;

masqstart)
     echo ""
     echo "IP Masquerading was not enabled during the install process."
     echo ""     
     echo "You must reinstall to use this option."
     echo ""
      ;;


masqstop)
     echo ""
     echo "IP Masquerading was not enabled during the install process."
     echo ""     
     echo "You must reinstall to use this option."
     echo ""
      ;;


uninstall)
     $CONFIG_DIR/uninstall
     ;;


  *)
 
     echo ""
     echo "  USAGE:  pmfirewall [command] "
     echo ""
     echo "  COMMANDS:"
     echo "         start      Enables PMFirewall."
     echo "         stop       Disables PMFirewall."
     echo "         restart    Flushes and reloads the rules in PMFirewall."
     echo "         masqstart  Enables IP Masquerading only (no firewall)."
     echo "         masqstop   Disables IP Masquerading only (no firewall)."
     echo "         uninstall  Completely removes PMFirewall."
     echo "         help       Displays this list of options."
     echo ""
     exit 1 ;;

esac
exit 0

