<?
/***************************************************************************
 *                            mod_table_uninst.php
 *                            -------------------
 *   begin                : Monday, Jan 21, 2002
 *   copyright            : (C) 2002 Meik Sievertsen
 *   email                : acyd.burn@gmx.de
 *
 *   $Id: mod_table_uninst.php,v 2.0.8 2002/02/27 meik Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);

$phpbb_root_path='./';
include($phpbb_root_path.'extension.inc');
include($phpbb_root_path.'common.'.$phpEx);	
	
//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX, $board_config['session_length']);
init_userprefs($userdata);
//
// End session management
//

if( !$userdata['session_logged_in'] )
{
	header("Location: " . append_sid("./login.$phpEx"));
}

if( $userdata['user_level'] != ADMIN )
{
	message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
}

if ( (!isset($dbms)) || (($dbms != "mysql") && ($dbms != "mysql4") && ($dbms != "mssql") && ($dbms != "mssql-odbc") && ($dbms != "postgres")) )
{
	message_die(GENERAL_MESSAGE, "This Mod is only tested with MySQL, please contact me at acyd.burn@gmx.de.");
}
else if( isset($dbms) )
{
	include($phpbb_root_path.'includes/db.'.$phpEx);
}

//
// Here we go
//
include($phpbb_root_path.'includes/sql_parse.'.$phpEx);

//
// drop table schema
//
$sql_array = array();

$sql_array['drop_schema'][] = "DROP TABLE phpbb_attach_types";
$sql_array['drop_schema'][] = "DROP TABLE phpbb_attach_typeconfig";
$sql_array['drop_schema'][] = "DROP TABLE phpbb_attach_extensions";
$sql_array['drop_schema'][] = "DROP TABLE phpbb_attach_config";
$sql_array['drop_schema'][] = "DROP TABLE phpbb_attach_desc";

//
// build sql query
//
$sql_query = preg_replace('/phpbb_/', $table_prefix, $sql_array['drop_schema']);
$sql_count = count($sql_query);

//
// from update_to_rc3.php
//
echo "<html>\n";
echo "<body>\n";
for($i = 0; $i < $sql_count; $i++)
{
	echo "Running :: " . $sql_query[$i];
	flush();

	if ( !($result = $db->sql_query($sql_query[$i])) )
	{
		$errored = true;
		$error = $db->sql_error();
		echo " -> <b>FAILED</b> ---> <u>" . $error['message'] . "</u><br /><br />\n\n";
	}
	else
	{
		echo " -> <b>COMPLETED</b><br /><br />\n\n";
	}
}

if ( $errored )
{
	$message = "<br />Some queries failed. Please contact me via email, pm, at the board or whatever, so we can solve your problems...<br />";
}
else
{
	$message = "<br />Attachment Mod Tables successfully deleted.";
}

echo "\n<br />\n<b>COMPLETE!</b><br />\n";
echo $message . "<br />";
echo "</body>";
echo "</html>";

?>