<?php
/***************************************************************************
 *							admin_attach_cp.php
 *							-------------------
 *	begin				: Sat, Feb 09, 2002
 *	copyright			: (C) 2002 Meik Sievertsen
 *	email				: acyd.burn@gmx.de
 *
 *	$Id: admin_attach_cp.php,v 2.1.0 2002/03/20 meik Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Attachments']['Control_Panel'] = $filename;
	return;
}

//
// Load default header
//
$phpbb_root_dir = "./../";
require('pagestart.inc');

$attach_config = array();

$sql = "SELECT * 
FROM " . ATTACH_CONFIG_TABLE;

if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not query attachment information", "", __LINE__, __FILE__, $sql);
}

while($row = $db->sql_fetchrow($result))
{
	$attach_config[$row['config_name']] = $row['config_value'];
}

$upload_dir = ( $attach_config['upload_dir'][0] == '/' ) ? $attach_config['upload_dir'] : "../" . $attach_config['upload_dir'];

//
// Begin Functions
//

//
// sort multi-dimensional array function
//
function sort_multi_array ($sort_array, $key, $sort_order) 
{
	$last_element = count($sort_array) - 1;

	$string_sort = ( is_string($sort_array[$last_element-1][$key]) ) ? TRUE : FALSE;

	for ($i = 0; $i < $last_element; $i++) 
	{
		$num_iterations = $last_element - $i;

		for ($j = 0; $j < $num_iterations; $j++) 
		{
			$next = 0;

			//
			// do checks based on key
			//
			$switch = FALSE;
			if ( !($string_sort) )
			{
				if ( ( ($sort_order == "DESC") && (intval($sort_array[$j][$key]) < intval($sort_array[$j + 1][$key])) ) || ( ($sort_order == "ASC") &&    (intval($sort_array[$j][$key]) > intval($sort_array[$j + 1][$key])) ) )
				{
					$switch = TRUE;
				}
			}
			else
			{
				if ( ( ($sort_order == "DESC") && (strcasecmp($sort_array[$j][$key], $sort_array[$j + 1][$key]) < 0) ) || ( ($sort_order ==   "ASC") && (strcasecmp($sort_array[$j][$key], $sort_array[$j + 1][$key]) > 0) ) )
				{
					$switch = TRUE;
				}
			}

			if ($switch)
			{
				$temp = $sort_array[$j];
				$sort_array[$j] = $sort_array[$j + 1];
				$sort_array[$j + 1] = $temp;
			}
		}
	}

	return ($sort_array);
}

//
// perform LIMIT statement on arrays
//
function limit_array($array, $start, $pagelimit)
{
	//
	// array from start - start+pagelimit
	//
	$limit = ( count($array) < $start + $pagelimit ) ? count($array) : $start + $pagelimit;

	$limit_array = array();

	for ($i = $start; $i < $limit; $i++)
	{
		$limit_array[] = $array[$i];
	}

	return $limit_array;
}

//
// Build SQL-Statement for the search feature
//
function search_attachments($order_by)
{
	global $db, $HTTP_POST_VARS, $HTTP_GET_VARS, $lang, $upload_dir;
	
	$where_sql = array();

	//
	// Get submitted Vars
	//
	$search_vars = array("search_keyword_fname", "search_keyword_comment", "search_author", "search_size_smaller", "search_size_greater", "search_count_smaller", "search_count_greater", "search_days_greater", "search_forum", "search_cat");
	
	for ($i = 0; $i < count($search_vars); $i++)
	{
		if( isset($HTTP_POST_VARS[$search_vars[$i]]) || isset($HTTP_GET_VARS[$search_vars[$i]]) )
		{
			eval("\$$search_vars[$i] = ( isset(\$HTTP_POST_VARS[\$search_vars[\$i]]) ) ? \$HTTP_POST_VARS[\$search_vars[\$i]] : \$HTTP_GET_VARS[\$search_vars[\$i]];");
		}
		else
		{
			eval("\$$search_vars[$i] = '';");
		}
	}

	//
	// Author name search 
	//
	if ( $search_author != '')
	{
		$search_author = str_replace("*", "%", trim(str_replace("\'", "''", $search_author)));

		//
		// We need the post_id's, because we want to query the Attachment Table
		//
		$sql = "SELECT user_id
		FROM " . USERS_TABLE . "
		WHERE username LIKE '" . $search_author . "'";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain list of matching users (searching for: $search_author)", "", __LINE__, __FILE__, $sql);
		}

		$matching_userids = '';
		if ( $row = $db->sql_fetchrow($result) )
		{
			do
			{
				$matching_userids .= ( ( $matching_userids != '' ) ? ', ' : '' ) . $row['user_id'];
			}
			while( $row = $db->sql_fetchrow($result) );
		}
		else
		{
			message_die(GENERAL_MESSAGE, $lang['No_attach_search_match']);
		}

		$sql = "SELECT post_id 
		FROM " . POSTS_TABLE . " 
		WHERE poster_id IN ($matching_userids)";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain matched posts list", "", __LINE__, __FILE__, $sql);
		}

		$matching_postids = '';
		if ( $row = $db->sql_fetchrow($result) )
		{
			do
			{
				$matching_postids .= ( ( $matching_postids != '' ) ? ', ' : '' ) . $row['post_id'];
			}
			while( $row = $db->sql_fetchrow($result) );
		}
		else
		{
			message_die(GENERAL_MESSAGE, $lang['No_attach_search_match']);
		}

		$where_sql[] = " (a.post_id IN (" . $matching_postids . ")) ";
	}

	//
	// Search Keyword
	//
	if ( $search_keyword_fname != '' )
	{
		$match_word = str_replace("*", "%", $search_keyword_fname);
		$where_sql[] = " (a.filename LIKE '" . $match_word . "') ";
	}

	if ( $search_keyword_comment != '' )
	{
		$match_word = str_replace("*", "%", $search_keyword_comment);
		$where_sql[] = " (a.comment LIKE '" . $match_word . "') ";
	}

	//
	// Search Download Count
	//
	if ( $search_count_smaller != '' || $search_count_greater != '' )
	{
		if ($search_count_smaller != '')
		{
			$where_sql[] = " (a.download_count < " . $search_count_smaller . ") ";
		}
		else if ($search_count_greater != '')
		{
			$where_sql[] = " (a.download_count > " . $search_count_greater . ") ";
		}
	}

	//
	// Search Filesize
	//
	if ( $search_size_smaller != '' || $search_size_greater != '' )
	{
		if ($search_size_smaller != '')
		{
			$where_sql = " (a.filesize < " . $search_size_smaller . ") ";
		}
		else if ($search_size_greater != '')
		{
			$where_sql = " (a.filesize > " . $search_size_greater . ") ";
		}
	}

	//
	// Search Attachment Time
	//
	if ( $search_days_greater != '' )
	{
		$where_sql = " (a.filetime < " . time() - ( $search_days_greater * 86400 ) . ") ";
	}

	$sql = "SELECT a.*, p.post_time, p.topic_id
	FROM " . ATTACH_DESC_TABLE . " a, " . POSTS_TABLE . " p WHERE ";
	
	if (count($where_sql) > 0)
	{
		$sql .= implode("AND", $where_sql) . " AND ";
	}

	$sql .= "(a.post_id = p.post_id) " . $order_by;

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't query attachments", "", __LINE__, __FILE__, $sql);
	}

	if ( ($db->sql_numrows($result)) > 0 )
	{
		$attachments = $db->sql_fetchrowset($result);

		for ($i = 0; $i < count($attachments); $i++)
		{
			$types = explode("/", $attachments[$i]['mimetype']);
			$attachments[$i]['mimetype'] = $types[1];
			$attachments[$i]['mimegroup'] = $types[0];
		}
	}
	
	if (count($attachments) == 0)
	{
		message_die(GENERAL_MESSAGE, $lang['No_attach_search_match']);
	}

	return ($attachments);
}

//
// End Functions
//

//
// Init Variables
//
$start = ( isset($HTTP_GET_VARS['start']) ) ? $HTTP_GET_VARS['start'] : 0;

if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == "ASC") ? "ASC" : "DESC";
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == "ASC") ? "ASC" : "DESC";
}
else
{
	$sort_order = "";
}

if(isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']))
{
	$mode = (isset($HTTP_POST_VARS['mode'])) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = "";
}

if( isset($HTTP_GET_VARS['view']) || isset($HTTP_POST_VARS['view']) )
{
	$view = ( isset($HTTP_POST_VARS['view']) ) ? $HTTP_POST_VARS['view'] : $HTTP_GET_VARS['view'];
}
else
{
	$view = "";
}

if(isset($HTTP_GET_VARS['uid']) || isset($HTTP_POST_VARS['u_id']))
{
	$uid = (isset($HTTP_POST_VARS['u_id'])) ? $HTTP_POST_VARS['u_id'] : $HTTP_GET_VARS['uid'];
}
else
{
	$uid = "";
}

$view = ( $HTTP_POST_VARS['search'] ) ? "attachments" : $view;

//
// process modes based on view
//
if ($view == "username")
{
	$mode_types_text = array($lang['Sort_Username'], $lang['Sort_Attachments'], $lang['Sort_Size']);
	$mode_types = array("username", "attachments", "filesize");

	if (empty($mode))
	{
		$mode = "attachments";
		$sort_order = "DESC";
	}
}
else if ($view == "attachments")
{
	$mode_types_text = array($lang['Sort_Filename'], $lang['Sort_Comment'], $lang['Sort_Mimegroup'], $lang['Sort_Mimetype'], $lang['Sort_Size'], $lang['Sort_Downloads'], $lang['Sort_Posttime'], $lang['Sort_Posts']);
	$mode_types = array("filename", "comment", "mimegroup", "mimetype", "filesize", "downloads", "post_time", "posts");

	if (empty($mode))
	{
		$mode = "filename";
		$sort_order = "ASC";
	}
}
else if ($view == "search")
{
	$mode_types_text = array($lang['Sort_Filename'], $lang['Sort_Comment'], $lang['Sort_Mimegroup'], $lang['Sort_Mimetype'], $lang['Sort_Size'], $lang['Sort_Downloads'], $lang['Sort_Posttime'], $lang['Sort_Posts']);
	$mode_types = array("filename", "comment", "mimegroup", "mimetype", "filesize", "downloads", "post_time", "posts");

	$sort_order = "DESC";
}
else
{
	$view = "stats";
	$mode_types_text = array();
	$sort_order = '';
}


//
// Pagination ?
//
$do_pagination = ( ($view != "stats") && ($view != "search") ) ? TRUE : FALSE;

//
// Set Order
//
$order_by = "";

if ($view == "username")
{
	switch($mode)
	{
		case 'username':
			$order_by = "ORDER BY u.username " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		case 'attachments':
			$order_by = "ORDER BY total_attachments " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		case 'filesize':
			$order_by = "ORDER BY total_size " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		default:
			$mode = "attachments";
			$sort_order = "DESC";
			$order_by = "ORDER BY total_attachments " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
	}
}
else if ($view == "attachments")
{
	switch($mode)
	{
		case 'filename':
			$order_by = "ORDER BY a.filename " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		case 'comment':
			$order_by = "ORDER BY a.comment " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		case 'mimegroup':
			$order_by = "";
			break;
		case 'mimetype':
			$order_by = "";
			break;
		case 'filesize':
			$order_by = "ORDER BY a.filesize " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		case 'downloads':
			$order_by = "ORDER BY a.download_count " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		case 'post_time':
			$order_by = "ORDER BY p.post_time " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		case 'posts':
			$order_by = "ORDER BY a.post_id " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
		default:
			$mode = "filename";
			$sort_order = "ASC";
			$order_by = "ORDER BY a.filename " . $sort_order . " LIMIT " . $start . ", " . $board_config['topics_per_page'];
			break;
	}
}

//
// Set select fields
//
$view_types_text = array($lang['View_Statistic'], $lang['View_Search'], $lang['View_Username'], $lang['View_Attachments']);
$view_types = array("stats", "search", "username", "attachments");

$select_view = "<select name=\"view\">";
for($i = 0; $i < count($view_types_text); $i++)
{
	$selected = ($view == $view_types[$i]) ? " selected=\"selected\"" : "";
	$select_view .= "<option value=\"" . $view_types[$i] . "\"$selected>" . $view_types_text[$i] . "</option>";
}
$select_view .= "</select>";

if (count($mode_types_text) > 0)
{
	$select_sort_mode = "<select name=\"mode\">";
	for($i = 0; $i < count($mode_types_text); $i++)
	{
		$selected = ($mode == $mode_types[$i]) ? " selected=\"selected\"" : "";
		$select_sort_mode .= "<option value=\"" . $mode_types[$i] . "\"$selected>" . $mode_types_text[$i] . "</option>";
	}
	$select_sort_mode .= "</select>";
}

if (!empty($sort_order))
{
	$select_sort_order = "<select name=\"order\">";
	if($sort_order == "ASC")
	{
		$select_sort_order .= "<option value=\"ASC\" selected=\"selected\">" . $lang['Sort_Ascending'] . "</option><option value=\"DESC\">" . $lang['Sort_Descending'] . "</option>";
	}
	else
	{
		$select_sort_order .= "<option value=\"ASC\">" . $lang['Sort_Ascending'] . "</option><option value=\"DESC\" selected=\"selected\">" . $lang['Sort_Descending'] . "</option>";
	}
	$select_sort_order .= "</select>";
}

$delete = ( isset($HTTP_POST_VARS['delete']) ) ? TRUE : FALSE;
$delete_id_list = ( isset($HTTP_POST_VARS['delete_id_list']) ) ?  $HTTP_POST_VARS['delete_id_list'] : array();

$confirm = ( $HTTP_POST_VARS['confirm'] ) ? TRUE : FALSE;

if ( ($confirm) && (count($delete_id_list) > 0) )
{
	$attachments = array();

	$whereclause = "WHERE attach_id IN ( ";
	$whereclause .= implode(", ", $delete_id_list);
	$whereclause .= " )";

	$sql = "SELECT attach_filename 
	FROM " . ATTACH_DESC_TABLE . " " .
	$whereclause;
	
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Can't query attach description table", "", __LINE__, __FILE__, $sql);
	}

	while ($row = $db->sql_fetchrow($result))
	{
		$attachments[] = $row['attach_filename'];
	}

	if ( count($attachments) > 0)
	{

		for ($i = 0; $i < count($attachments); $i++)
		{
			@unlink($upload_dir . "/" . $attachments[$i]);
		}

		//
		// Delete rows
		//
		$sql = "DELETE FROM " . ATTACH_DESC_TABLE . " " . $whereclause;

		if ( !($db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, $lang['Error_deleted_attachments'], __LINE__, __FILE__, $sql);
		}
	}

}
else if ( ($delete) && (count($delete_id_list)) > 0 )
{
	//
	// Not confirmed, show confirmation message
	//	
	$hidden_fields = '<input type="hidden" name="view" value="' . $view . '" />';
	$hidden_fields .= '<input type="hidden" name="mode" value="' . $mode . '" />';
	$hidden_fields .= '<input type="hidden" name="order" value="' . $sort_order . '" />';
	$hidden_fields .= '<input type="hidden" name="u_id" value="' . $uid . '" />';
	$hidden_fields .= '<input type="hidden" name="start" value="' . $start . '" />';

	for($i = 0; $i < count($delete_id_list); $i++)
	{
		$hidden_fields .= '<input type="hidden" name="delete_id_list[]" value="' . $delete_id_list[$i] . '" />';
	}

	$template->set_filenames(array(
		"confirm" => "confirm_body.tpl")
	);

	$template->assign_vars(array(
		"MESSAGE_TITLE" => $lang['Confirm'],
		"MESSAGE_TEXT" => $lang['Confirm_delete_attachments'],

		"L_YES" => $lang['Yes'],
		"L_NO" => $lang['No'],

		"S_CONFIRM_ACTION" => append_sid("admin_attach_cp.$phpEx"),
		"S_HIDDEN_FIELDS" => $hidden_fields)
	);

	$template->pparse("confirm");
	
	include('page_footer_admin.'.$phpEx);

	exit;
}

//
// Assign Default Template Vars
//
$template->assign_vars(array(
	"L_VIEW" => $lang['View'],
	"L_SUBMIT" => $lang['Submit'],
	"L_CONTROL_PANEL_TITLE" => $lang['Control_panel_title'],
	"L_CONTROL_PANEL_EXPLAIN" => $lang['Control_panel_explain'],

	"S_VIEW_SELECT" => $select_view,
	"S_MODE_ACTION" => append_sid("admin_attach_cp.$phpEx"))
);

//
// Statistics
//
if ($view == "stats")
{

	$template->set_filenames(array(
		"body" => "admin/attach_cp_body.tpl")
	);

	$upload_dir_size = 0;

	if ($dirname = @opendir($upload_dir))
	{
		while( $file = @readdir($dirname) )
		{
			if( $file != "." && $file != ".." )
			{
				$upload_dir_size += @filesize($upload_dir . "/" . $file);
			}
		}
		@closedir($dirname);

		if($upload_dir_size >= 1048576)
		{
			$upload_dir_size = round($upload_dir_size / 1048576 * 100) / 100 . " " . $lang['MB'];
			$attachment_quota = round($attach_config['attachment_quota'] / 1048576 * 100) / 100 . " " . $lang['MB'];
		}
		else if($upload_dir_size >= 1024)
		{
			$upload_dir_size = round($upload_dir_size / 1024 * 100) / 100 . " " . $lang['KB'];
			$attachment_quota = round($attach_config['attachment_quota'] / 1024 * 100) / 100 . " " . $lang['KB'];
		}
		else
		{
			$upload_dir_size = $upload_dir_size . " " . $lang['Bytes'];
			$attachment_quota = $attach_config['attachment_quota'] . " " . $lang['Bytes'];
		}

	}
	else
	{
		$upload_dir_size = $lang['Not_available'];
	}

	$sql = "SELECT count(*) AS total
	FROM " . ATTACH_DESC_TABLE;

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Error getting total attachments.", "", __LINE__, __FILE__, $sql);
	}

	$total = $db->sql_fetchrow($result);
	$number_of_attachments = $total['total'];

	$sql = "SELECT post_id
	FROM " . ATTACH_DESC_TABLE . "
	GROUP BY post_id";

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Error getting total posts.", "", __LINE__, __FILE__, $sql);
	}

	$number_of_posts = $db->sql_numrows($result);

	$sql = "SELECT p.topic_id
	FROM " . ATTACH_DESC_TABLE . " a, " . POSTS_TABLE . " p
	WHERE a.post_id = p.post_id
	GROUP BY p.topic_id";

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Error getting total topics.", "", __LINE__, __FILE__, $sql);
	}

	$number_of_topics = $db->sql_numrows($result);

	$sql = "SELECT u.user_id
	FROM " . ATTACH_DESC_TABLE . " a, " . USERS_TABLE . " u, " . POSTS_TABLE . " p
	WHERE (a.post_id = p.post_id) AND (u.user_id = p.poster_id)
	GROUP BY u.user_id";

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Error getting total users.", "", __LINE__, __FILE__, $sql);
	}

	$number_of_users = $db->sql_numrows($result);

	$template->assign_vars(array(
		"L_STATISTIC" => $lang['Statistic'],
		"L_VALUE" => $lang['Value'],
		"L_NUMBER_OF_ATTACHMENTS" => $lang['Number_of_attachments'],
		"L_TOTAL_FILESIZE" => $lang['Total_filesize'],
		"L_ATTACH_QUOTA" => $lang['Attach_quota'],
		"L_NUMBER_OF_POSTS" => $lang['Number_posts_attach'],
		"L_NUMBER_OF_TOPICS" => $lang['Number_topics_attach'],
		"L_NUMBER_OF_USERS" => $lang['Number_users_attach'],
		
		"TOTAL_FILESIZE" => $upload_dir_size,
		"ATTACH_QUOTA" => $attachment_quota,
		"NUMBER_OF_ATTACHMENTS" => $number_of_attachments,
		"NUMBER_OF_POSTS" => $number_of_posts,
		"NUMBER_OF_TOPICS" => $number_of_topics,
		"NUMBER_OF_USERS" => $number_of_users)
	);

}

//
// Search
//
if ($view == "search")
{

	//
	// Get Forums and Categories
	//
	$sql = "SELECT c.cat_title, c.cat_id, f.forum_name, f.forum_id  
	FROM " . CATEGORIES_TABLE . " c, " . FORUMS_TABLE . " f
	WHERE f.cat_id = c.cat_id 
	ORDER BY c.cat_id, f.forum_order";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain forum_name/forum_id", "", __LINE__, __FILE__, $sql);
	}

	$s_forums = "";
	while( $row = $db->sql_fetchrow($result) )
	{
		$s_forums .= "<option value=\"" . $row['forum_id'] . "\">" . $row['forum_name'] . "</option>";

		if( empty($list_cat[$row['cat_id']]) )
		{
			$list_cat[$row['cat_id']] = $row['cat_title'];
		}
	}

	if( $s_forums != "" )
	{
		$s_forums = "<option value=\"-1\">" . $lang['All_available'] . "</option>" . $s_forums;

		//
		// Category to search
		//
		$s_categories = "<option value=\"-1\">" . $lang['All_available'] . "</option>";
		while( list($cat_id, $cat_title) = @each($list_cat))
		{
			$s_categories .= "<option value=\"$cat_id\">$cat_title</option>";
		}
	}
	else
	{
		message_die(GENERAL_MESSAGE, $lang['No_searchable_forums']);
	}
	
	$template->set_filenames(array(
		"body" => "admin/attach_cp_search.tpl")
	);

	$template->assign_vars(array(
		"L_ATTACH_SEARCH_QUERY" => $lang['Attach_search_query'],
		"L_FILENAME" => $lang['File_name'],
		"L_COMMENT" => $lang['File_comment'],
		"L_SEARCH_OPTIONS" => $lang['Search_options'],
		"L_SEARCH_AUTHOR" => $lang['Search_author'],
		"L_WILDCARD_EXPLAIN" => $lang['Search_wildcard_explain'],
		"L_SIZE_SMALLER_THAN" => $lang['Size_smaller_than'],		
		"L_SIZE_GREATER_THAN" => $lang['Size_greater_than'],
		"L_COUNT_SMALLER_THAN" => $lang['Count_smaller_than'],		
		"L_COUNT_GREATER_THAN" => $lang['Count_greater_than'],
		"L_MORE_DAYS_OLD" => $lang['More_days_old'],
		"L_CATEGORY" => $lang['Category'], 
		"L_ORDER" => $lang['Order'],
		"L_SORT_BY" => $lang['Select_sort_method'],
		
		"S_FORUM_OPTIONS" => $s_forums, 
		"S_CATEGORY_OPTIONS" => $s_categories,
		"S_SORT_OPTIONS" => $select_sort_mode,
		"S_SORT_ORDER" => $select_sort_order)
	);
}

//
// Username
//
if ($view == "username")
{

	$template->set_filenames(array(
		"body" => "admin/attach_cp_user.tpl")
	);

	$template->assign_vars(array(
		"L_SELECT_SORT_METHOD" => $lang['Select_sort_method'],
		"L_ORDER" => $lang['Order'],
		"L_SIZE" => $lang['Size_in_kb'],
		"L_ATTACHMENTS" => $lang['Attachments'],

		"S_MODE_SELECT" => $select_sort_mode,
		"S_ORDER_SELECT" => $select_sort_order)
	);

	$sql = "SELECT u.username, u.user_id, count(*) as total_attachments, sum(a.filesize) as total_size
	FROM " . ATTACH_DESC_TABLE . " a, " . USERS_TABLE . " u, " . POSTS_TABLE . " p
	WHERE (a.post_id = p.post_id) AND (u.user_id = p.poster_id)
	GROUP BY u.user_id, u.username " . 
	$order_by;

	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't query attachments", "", __LINE__, __FILE__, $sql);
	}

	if( ( $db->sql_numrows($result) ) > 0 )
	{
		$members = $db->sql_fetchrowset($result);

		for ($i = 0; $i < count($members); $i++)
		{
			$username = $members[$i]['username'];
			$total_attachments = $members[$i]['total_attachments'];
			$total_size = $members[$i]['total_size'];

			$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
			$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

			$template->assign_block_vars("memberrow", array(
				"ROW_NUMBER" => $i + ( $HTTP_GET_VARS['start'] + 1 ),
				"ROW_COLOR" => "#" . $row_color,
				"ROW_CLASS" => $row_class,
				"USERNAME" => $username,
				"TOTAL_ATTACHMENTS" => $total_attachments,
				"TOTAL_SIZE" => intval($total_size/1024),
				"U_VIEW_MEMBER" => append_sid("admin_attach_cp.$phpEx?view=attachments&amp;uid=" . $members[$i]['user_id']))
			);
		}
	}

	$sql = "SELECT u.user_id
	FROM " . ATTACH_DESC_TABLE . " a, " . USERS_TABLE . " u, " . POSTS_TABLE . " p
	WHERE (a.post_id = p.post_id) AND (u.user_id = p.poster_id)
	GROUP BY u.user_id";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Error getting total users.", "", __LINE__, __FILE__, $sql);
	}

	$total_rows = $db->sql_numrows($result);

}

//
// Attachments
//
if ($view == "attachments")
{
	$user_based = ( !empty($uid) ) ? TRUE : FALSE;
	$search_based = ( $HTTP_POST_VARS['search'] ) ? TRUE : FALSE;
	
	$hidden_fields = "";
	
	$template->set_filenames(array(
		"body" => "admin/attach_cp_attachments.tpl")
	);

	$template->assign_vars(array(
		"L_SELECT_SORT_METHOD" => $lang['Select_sort_method'],
		"L_ORDER" => $lang['Order'],

		"L_FILENAME" => $lang['File_name'],
		"L_FILECOMMENT" => $lang['File_comment_cp'],
		"L_MIMETYPE" => $lang['Mimetype'],
		"L_SIZE" => $lang['Size_in_kb'],
		"L_DOWNLOADS" => $lang['Downloads'],
		"L_POST_TIME" => $lang['Post_time'],
		"L_POSTED_IN_TOPIC" => $lang['Posted_in_topic'],
		"L_DELETE" => $lang['Delete'],

		"S_MODE_SELECT" => $select_sort_mode,
		"S_ORDER_SELECT" => $select_sort_order)
	);

	// 
	// Are we called from Username ?
	//
	if ($user_based)
	{
		$sql = "SELECT username 
		FROM " . USERS_TABLE . " 
		WHERE user_id = " . $uid;

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Error getting username.", "", __LINE__, __FILE__, $sql);
		}

		$username = $db->sql_fetchrow($result);
		$username = $username[0];

		$s_hidden = "<input type=\"hidden\" name=\"u_id\" value=\"" . $uid . "\">";
	
		$template->assign_block_vars("switch_user_based", array());

		$template->assign_vars(array(
			"S_USER_HIDDEN" => $s_hidden,
			"L_STATISTICS_FOR_USER" => sprintf($lang['Statistics_for_user'], $username))
		);

		$sql = "SELECT a.*, p.post_time, p.topic_id
		FROM " . ATTACH_DESC_TABLE . " a, " . POSTS_TABLE . " p 
		WHERE (a.post_id = p.post_id) AND (p.poster_id = " . $uid . ") " . 
		$order_by;
	}
	else if ($search_based)
	{
		//
		// we are called from search
		//
		$attachments = search_attachments($order_by);
	}
	else
	{
		$sql = "SELECT a.*, p.post_time, p.topic_id
		FROM " . ATTACH_DESC_TABLE . " a, " . POSTS_TABLE . " p 
		WHERE (a.post_id = p.post_id) " .
		$order_by;
	}

	if (!$search_based)
	{
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Couldn't query attachments", "", __LINE__, __FILE__, $sql);
		}

		if ( ($db->sql_numrows($result)) > 0 )
		{
			$attachments = $db->sql_fetchrowset($result);

			for ($i = 0; $i < count($attachments); $i++)
			{
				$types = explode("/", $attachments[$i]['mimetype']);
				$attachments[$i]['mimetype'] = $types[1];
				$attachments[$i]['mimegroup'] = $types[0];
			}
		}
	}
	
	if (count($attachments) > 0)
	{

		if ($mode == "mimegroup")
		{
			$attachments = sort_multi_array($attachments, "mimegroup", $sort_order);
			$attachments = limit_array($attachments, $start, $board_config['topics_per_page']);
		}
		else if ($mode == "mimetype")
		{
			$attachments = sort_multi_array($attachments, "mimetype", $sort_order);
			$attachments = limit_array($attachments, $start, $board_config['topics_per_page']);
		}

		for ($i = 0; $i < count($attachments); $i++)
		{
			$delete_box = "<input type=\"checkbox\" name=\"delete_id_list[]\" value=\"" . $attachments[$i]['attach_id'] . "\" />";

			for ($j = 0; $j < count($delete_id_list); $j++)
			{
				if ($delete_id_list[$j] == $attachments[$i]['attach_id'])
				{
					$delete_box = "<input type=\"checkbox\" name=\"delete_id_list[]\" value=\"" . $attachments[$i]['attach_id'] . "\" checked />";
					break;
				}
			}

			$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
			$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

			$sql = "SELECT topic_title
			FROM " . TOPICS_TABLE . "
			WHERE topic_id = " . $attachments[$i]['topic_id'];

			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, "Couldn't query topic", "", __LINE__, __FILE__, $sql);
			}

			$post_title = $db->sql_fetchrow($result);
			$post_title = $post_title[0];

			if (strlen($post_title) > 32)
			{
				$post_title = substr($post_title, 0, 30) . "...";
			}

			$template->assign_block_vars("attachrow", array(
				"ROW_NUMBER" => $i + ( $HTTP_GET_VARS['start'] + 1 ),
				"ROW_COLOR" => "#" . $row_color,
				"ROW_CLASS" => $row_class,

				"FILENAME" => $attachments[$i]['filename'],
				"COMMENT" => $attachments[$i]['comment'],
				"MIMETYPE" => $attachments[$i]['mimegroup'] . "/" . $attachments[$i]['mimetype'],
				"SIZE" => intval($attachments[$i]['filesize']/1024),
				"DOWNLOAD_COUNT" => $attachments[$i]['download_count'],
				"POST_TIME" => create_date($board_config['default_dateformat'], $attachments[$i]['post_time'], $board_config['board_timezone']),
				"POST" => $post_title,
//				"TOPIC" => $attachments[$i]['topic_id'],

				"S_DELETE_BOX" => $delete_box,
				"U_VIEW_ATTACHMENT" => append_sid("../attachment_mod." . $phpEx . "?download=" . $attachments[$i]['attach_id']),
				"U_VIEW_POST" => append_sid("../viewtopic." . $phpEx . "?" . POST_POST_URL . "=" . $attachments[$i]['post_id'] . "#" . $attachments[$i]['post_id']))
			);
		}
	}

	$sql = "SELECT a.*, p.post_time, p.topic_id 
	FROM " . ATTACH_DESC_TABLE . " a, " . POSTS_TABLE . " p 
	WHERE (a.post_id = p.post_id) " . $user_id_clause;

	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't query attachments", "", __LINE__, __FILE__, $sql);
	}

	$total_rows = $db->sql_numrows($result);
}

//
// Generate Pagination
//
if ($do_pagination)
{
	$pagination = generate_pagination("admin_attach_cp.$phpEx?view=$view&amp;mode=$mode&amp;order=$sort_order&amp;uid=$uid", $total_rows, $board_config['topics_per_page'], $start)."&nbsp;";

	$template->assign_vars(array(
		"PAGINATION" => $pagination,
		"PAGE_NUMBER" => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $total_rows / $board_config['topics_per_page'] )), 

		"L_GOTO_PAGE" => $lang['Goto_page'])
	);
}

$template->pparse("body");

include('page_footer_admin.'.$phpEx);

?>