/*
 * powercom.h - defines for the newpowercom.c driver
 *
 * Read docs/powercom.txt for other models and manufactures
 *
 * $Id: - will be filled in on next CVS add/update $
 *
 * Copyrights:
 * (C) 2002 Simon Rozman <simon@rozman.net>
 *  Added support for Egys
 *
 * (C) 2001 Peter Bieringer <pb@bieringer.de>
 *  Porting old style "powercom" to new style "newpowercom", cleanup header file
 *
 * (C) 2000  Shaul Karl <shaulk@israsrv.net.il>
 *  Creating old style "powercom"
 *   Heavily based on
 *    ups-trust425+625.c - model specific routines for Trust UPS 425/625
 *    Copyright (C) 1999  Peter Bieringer <pb@bieringer.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Changes
 * 20011208/PB: add support for subtypes
 * 20020629/SR: add support for calc. parameters
 * 20020701/SK: subtypes as structures
 */

/* C-libary includes */
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/termios.h>
#include <limits.h>

/* nut includes */
#include "timehead.h"
#include "shared-tables.h"

/* general constants */
enum general {
       	SEC_FOR_POWERKILL         = 10U,
	MAX_NUM_OF_BYTES_FROM_UPS = 16U,
};

/* values for sending to UPS */
enum commands {
	SEND_DATA    = '\x01',
	BATTERY_TEST = '\x03',
	SHUTDOWN     = '\xbc',
};

/* location of data in received string */
enum data {
	LOAD_LEVEL  = 0U,
       	BAT_LEVEL   = 1U,
       	IN_AC_VOLT  = 2U,
       	OUT_AC_VOLT = 3U,
	IN_AC_FREQ  = 4U,
        OUT_AC_FREQ = 6U,
};

/* status bits */
enum status {
	SUMMARY       = 0U,
       	MAINS_FAILURE = 1U,
       	LOW_BAT       = 2U, 
	BAD_BAT       = 2U,
       	TEST          = 4U,
	AVR_ON        = 8U,
       	OVERLOAD      = 32U,
       	OFF           = 128U,
	STATUS_A      = 9U,
	STATUS_B      = 10U,
};

/* supported subtypes */
struct subtype {
	char          *name;
	unsigned char num_of_bytes_from_ups;
	void          (*setup_flow_control)(void);
	int           (*validate_raw_data)(void);
	
	/* parameters to calculate input and output freq., one pair for each
	 * subtype:
	 *  Each pair defines parameters for 1/(A*x+B) to calculate freq.
	 *  from raw data
	 */
	float         freq[2];
	
	/* parameters to calculate load %, two pairs for each subtype:
	 *  First pair defines the parameters for A*x+B to calculate load
	 *  from raw data when offline and the second pair is used when
	 *  online
	 */
	float         loadpct[4];
	
	/* parameters to calculate battery %, five parameters for each subtype:
	 *  First three params defines the parameters for A*x+B*y+C to calculate
	 *  battery % (x is raw data, y is load %) when offline.
	 *  Fourth and fifth parameters are used to calculate D*y+E when online.
	 */
	float         battpct[5];

	/* parameters to calculate utility and output voltage, two pairs for
	 * each subtype:
	 *  First pair defines the parameters for A*x+B to calculate utility
	 *  from raw data when line voltage is >=220 and the second pair
	 *  is used otherwise.
	 */
	float         voltage[4];
};
