/* upsc - simple "client" to test communications 

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "common.h"

#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>

#include "upsclient.h"

static void help(char *prog)
{
	printf("Network UPS Tools upsc %s\n\n", UPS_VERSION);

	printf("usage: %s <host> [<variable>]\n", prog);

	printf("\nDemo program to display UPS variables.\n\n");

	printf("  <host>     - UPS, [<upsname>@]host[:port] form\n");
	printf("  <variable> - optional, display this variable only.\n");
	printf("               Default: list all variables for <host>\n");

	exit(0);
}

static void clean_exit(UPSCONN *ups, char *upsname, char *hostname, int code)
{
	if (upsname)
		free(upsname);

	if (hostname)
		free(hostname);

	upscli_disconnect(ups);

	exit(code);
}

static void printvar(UPSCONN *ups, const char *upsname, const char *var)
{
	char	value[SMALLBUF];

	if (upscli_getvar(ups, upsname, var, value, sizeof(value)) < 0) {
		fprintf(stderr, "Error: %s\n", upscli_strerror(ups));
		return;
	}

	printf("%s\n", value);
}

int main(int argc, char **argv)
{
	int	port;
	char	*upsname, *hostname, vars[LARGEBUF], *v, *ptr;
	UPSCONN	ups;

	if (argc < 2)
		help(argv[0]);

	upscli_splitname(argv[1], &upsname, &hostname, &port);

	if (upscli_connect(&ups, hostname, port, UPSCLI_CONN_TRYSSL) < 0) {
		fprintf(stderr, "Error: %s\n", upscli_strerror(&ups));

		clean_exit(&ups, upsname, hostname, 1);
	}

	if (argc >= 3) {
		printvar(&ups, upsname, argv[2]);
		clean_exit(&ups, upsname, hostname, 0);
	}

	if (upscli_getlist(&ups, upsname, UPSCLI_LIST_VARS, vars, 
		sizeof(vars)) < 0) {
		fprintf(stderr, "Unable to get variable list - %s\n", 
		        upscli_strerror(&ups));

		clean_exit(&ups, upsname, hostname, 1);
	}

	printf("UPS: %s\n", argv[1]);

	if (strlen(vars) == 0) {
		fprintf(stderr, "No data available - check your "
			"configuration (ups.conf)\n");

		clean_exit(&ups, upsname, hostname, 1);
	}

	v = vars;
	while (v != NULL) {
		ptr = strchr(v, ' ');
		if (ptr)
			*ptr++ = '\0';

		printf("%s: ", v);
		printvar(&ups, upsname, v);

		v = ptr;
	}		

	clean_exit(&ups, upsname, hostname, 0);

	/* NOTREACHED */
	return 0;
}
