/*
 *	Copyright (c) 1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "bbsuser.h"

extern int errno;

/* callsign entry */
static struct callsign_ent {
	int slen;	/* sign length */
	char *sign;	/* short name */
	int nlen;	/* name length */
	char *name;	/* full name */
} *callsign = NULL;

int
initcallsign(orgdir)
	char *orgdir;
{
	register i;
	register char *ptr;
	int fd;
	char *line, *sign, fpath[1024];
	struct stat st;

	/* Prepare CallSignList if exist */
	callsign = NULL;
	sprintf(fpath, "%s/%s", orgdir, CALLSIGNLIST);
	if (stat(fpath, &st) < 0 || !st.st_size) return 0;
	if ((ptr = alloca(st.st_size + 2)) == NULL) return 0;
	if ((fd = open(fpath, O_RDONLY|O_SHLOCK)) < 0) return 0;
	while ((i = read(fd, ptr, st.st_size)) < 0 && errno == EINTR);
	close(fd);
	if (i != st.st_size) return 0;
	if (ptr[i-1] != '\n') ptr[i++] = '\n';
	ptr[i] = '\0';

	for (i = 0; (line = index(ptr, '\n')) != NULL; ptr = line) {
		*line++ = '\0';
		while ((u_char)*ptr <= 0x20 && *ptr) ptr++;
		if (!*ptr || *ptr == '#') continue;
		sign = ptr;
		while ((u_char)*ptr > 0x20) ptr++;
		if (*ptr) for (*ptr++ = 0; *ptr && (u_char)*ptr <= 0x20; ptr++);
		if (!*ptr) continue;
		callsign = realloc(callsign, (i + 1) * sizeof(struct callsign_ent));
		if (callsign == NULL) break;
		callsign[i].slen = strlen(sign);
		callsign[i].nlen = strlen(ptr);
		if ((callsign[i].sign = strdup(sign)) == NULL ||
		    (callsign[i].name = strdup(ptr)) == NULL) return i;
		i++;
	}
	if (i) {
		callsign = realloc(callsign, (i + 1) * sizeof(struct callsign_ent));
		if (callsign == NULL) i--;
		callsign[i].slen = callsign[i].nlen = 0;
		callsign[i].sign = callsign[i].name = NULL;
	}
	return i;
}

char *
getnamebysign(sign)
	register char *sign;
{
	if (callsign != NULL && sign != NULL && *sign != '\0') {
		register i, len;
		len = strlen(sign);
		for (i = 0; callsign[i].sign != NULL; i++)
			if (callsign[i].slen == len &&
			    !strcasecmp(callsign[i].sign, sign)) break;
		return callsign[i].name;
	}
	return NULL;
}

char *
getsignbyname(name)
	register char *name;
{
	if (callsign != NULL && name != NULL && *name != '\0') {
		register i, len;
		len = strlen(name);
		for (i = 0; callsign[i].name != NULL; i++)
			if (callsign[i].nlen == len &&
			    !strcasecmp(callsign[i].name, name)) break;
		return callsign[i].sign;
	}
	return NULL;
}

static int signentry = 0;

char *
getsignent()
{
	static char buf[80];

	if (callsign[signentry].sign != NULL &&
	    callsign[signentry].name != NULL) {
		snprintf(buf, sizeof(buf), "%-16.16s %s",
			 callsign[signentry].sign, callsign[signentry].name);
		signentry++;
		return buf;
	}
	signentry = 0;
	return NULL;
}

closesignent()
{
	signentry = 0;
}
