/*
 *	Copyright (c) 1995 The CAD lab of the
 *	Sibirian State Academy of Telecommunication, RU
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <stdio.h>
#include <string.h>
#include "group.h"

int
main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j, l, n, m;
	char *ptr;
	struct group_keyword *p;
	grp_ent grpent;
	grp_desc grpdesc;

	i = 1;
	if (argc > 2 &&
	    argv[i][0] == '-' && argv[i][1] == 'f' && argv[i][2] == '\0') {
		i++;
		ptr = argv[i++];
		argc -= 2;
	} else	ptr = NULL;

	if ((j = initgrpbase(ptr)) < 1) {
		if (j < 0) fprintf(stderr, "Can't initialize groups\n");
		else fprintf(stderr, "No groups found\n");
		exit(1);
	}
	for (grpent = grp_first; grpent; grpent = grpent->next) {
		for (j = i; j < argc; j++)
			if (!strcasecmp(grpent->name, argv[j])) break;
		if (j > i && j == argc) continue;
		printf("\n%-10.10s%s\n", "GROUP", grpent->name);
		for (p = &group_keywords[BEGIN_GSID]; p->word; ++p)
			for (m = 0, grpdesc = grpent->entry; grpdesc;
			     grpdesc = grpdesc->next) {
				if (grpdesc->gsid != p->key) continue;
				if (!m++) ptr = p->word;
				else ptr = " ";
				printf("%-10.10s", ptr);
				n = printf("%-.40s", grpdesc->expr);
				for (l = n; l < 40; l++)
					if (l == n) putchar(' ');
					else putchar('.');
				printf(" [");
				if (grpdesc->grf & GRF_S) putchar('S');
				else putchar('-');
				if (grpdesc->grf & GRF_R) putchar('R');
				else putchar('-');
				if (grpdesc->grf & GRF_W) putchar('W');
				else putchar('-');
				if (grpdesc->grf & GRF_D) putchar('D');
				else putchar('-');
				printf("]\n");
			}
	}
}
