#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef	HAVE_SNPRINTF

#include <sys/types.h>
#include <stdio.h>
#ifdef	__STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <string.h>

int
#ifdef	__STDC__
vsnprintf(char *str, size_t n, char *fmt, va_list ap)
#else
vsnprintf(str, n, fmt, va_list)
	char *str;
	size_t n;
	char *fmt;
	va_list ap;
#endif
{
	int ret;
	char buff[2048]; /* big buffer */

	if (n < 1) return EOF;
	ret = vsprintf(buff, fmt, ap);
	(void) strncpy(str, buff, n-1);
	str[n-1] = 0;

	return (ret > n - 1 ? n - 1 : ret);
}

int
#ifdef	__STDC__
snprintf(char *str, size_t n, char *fmt, ...)
#else
snprintf(str, n, fmt, va_alist)
	char *str;
	size_t n;
	char *fmt;
	va_dcl
#endif
{
	int ret;
	va_list ap;

#ifdef	__STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	ret = vsnprintf(str, n, fmt, ap);
	va_end(ap);

	return ret;
}

#endif	/* HAVE_SNPRINTF */
