#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef	HAVE_FLOCK

/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include "compat.h"

int
flock(fd, operation)
	int fd, operation;
{
	struct flock lck;

	lck.l_start = lck.l_len = 0;
	lck.l_whence = 0;
	lck.l_pid = getpid();

	switch (operation) {
		case LOCK_SH: lck.l_type = F_RDLCK; break;
		case LOCK_EX: lck.l_type = F_WRLCK; break;
		case LOCK_UN: lck.l_type = F_UNLCK; break;
		default: return -1;
	}

	return fcntl(fd, F_SETLKW, &lck);
}

#endif	/* HAVE_FLOCK */
