/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_SCANDIR_H_
#define	_TNS_SCANDIR_H_

#include <sys/types.h>

struct dir_ent {
	char	*name;		/* file name */
	int	len;		/* name length */
	mode_t	mode;		/* file mode */
	time_t	date;		/* file mtime */
	off_t	size;		/* file size */
	uid_t	uid;		/* user-id of file owner */
	gid_t	gid;		/* group-id of file owner */
	int	priv;		/* user privlevel to access item */
	int	key;		/* item hot key */
};

#define	SCAN_SORTBYNAME	1	/* sort by name order */
#define	SCAN_SORTBYDATE	2	/* sort by date order */
#define	SCAN_SORTBYSIZE	3	/* sort by size order */

extern int scan_dir(char *path,
		    struct dir_ent **files,
		    int (*select)(char *, struct dir_ent *),
		    int sort);

extern void free_dir(struct dir_ent **files, int num);

extern int files_only(char *path, struct dir_ent *file);
extern int dirs_only(char *path, struct dir_ent *file);

#endif	/* !_TNS_SCANDIR_H_ */
