/*
 *	Copyright (c) 1997 Rinet Corp., Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#ifndef	_TNS_COMPAT_H_
#define	_TNS_COMPAT_H_

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/param.h>
#ifdef	__STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif


/*
 * Defines for system depended external programs.
 */

#if defined(SVR4)
#ifndef	PROG_LS
#define	PROG_LS		"/usr/bin/ls"
#endif
#ifndef	PROG_MV
#define	PROG_MV		"/usr/bin/mv"
#endif
#ifndef	PROG_RM
#define	PROG_RM		"/usr/bin/rm"
#endif
#else	/* BSD, SVR3, Linux */
#ifndef	PROG_LS
#define	PROG_LS		"/bin/ls"
#endif
#ifndef	PROG_MV
#define	PROG_MV		"/bin/mv"
#endif
#ifndef	PROG_RM
#define	PROG_RM		"/bin/rm"
#endif
#endif

#ifndef	PROG_LS_ARGS
#define	PROG_LS_ARGS	"-lLFq"		/* long ls output switches */
#endif

#ifndef	PROG_RM_ARGS
#define	PROG_RM_ARGS	"-rf"		/* quiet remove a file hierarchy */
#endif

#if defined(SVR3)
#ifndef	PROG_TALK
#define	PROG_TALK	"/usr/ucb/talk"
#endif
#ifndef	PROG_FINGER
#define	PROG_FINGER	"/usr/ucb/finger"
#endif
#else	/* BSD, SVR4, Linux */
#ifndef	PROG_TALK
#define	PROG_TALK	"/usr/bin/talk"
#endif
#ifndef	PROG_FINGER
#define	PROG_FINGER	"/usr/bin/finger"
#endif
#endif

/*
 * The dirent compatibility.
 */

#ifdef HAVE_DIRENT_H
# include <dirent.h>
#else
# define dirent direct
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

/*
 * The following functions maybe absent in your operating system.
 */

#ifndef	HAVE_CFMAKERAW
#include <termios.h>

#ifdef	__STDC__
extern void cfmakeraw(struct termios *t);
#else
extern void cfmakeraw();
#endif

#endif

#ifdef	HAVE_FLOCK
#include <fcntl.h>
#else

#define	LOCK_SH		1	/* shared lock */
#define	LOCK_EX		2	/* exclusive lock */
#define	LOCK_UN		8	/* unlock */

#ifdef	__STDC__
extern int flock(int fd, int operation);
#else
extern int flock();
#endif

#endif

#ifdef	HAVE_FNMATCH
#include <fnmatch.h>
#else

#define	FNM_NOMATCH	1	/* Match failed. */
#define	FNM_NOESCAPE	0x01	/* Disable backslash escaping. */
#define	FNM_PATHNAME	0x02	/* Slash must be matched by slash. */
#define	FNM_PERIOD	0x04	/* Period must be matched by period. */

#ifdef	__STDC__
extern int fnmatch(const char *pattern, const char *string, int flags);
#else
extern int fnmatch();
#endif

#endif

#ifndef	HAVE_GETLOADAVG

#ifdef	__STDC__
extern int getloadavg(double loadavg[], int nelem);
#else
extern int getloadavg();
#endif

#endif

#ifndef	HAVE_RANDOM

#ifdef	__STDC__
extern long random(void);
extern void srandom(unsigned seed);
extern char *initstate(unsigned seed, char *state, int n);
extern char *setstate(char *state);
#else
extern long random();
extern void srandom();
extern char *initstate();
extern char *setstate();
#endif

#endif

#ifndef	HAVE_SNPRINTF

#ifdef	__STDC__
extern int snprintf(char *buf, size_t size, char *fmt, ...);
extern int vsnprintf(char *buf, size_t size, char *fmt, va_list ap);
#else
extern int snprintf();
extern int vsnprintf();
#endif

#endif

#ifndef	HAVE_STRCASECMP

#ifdef	__STDC__
extern int strcasecmp(char *s1, char *s2);
extern int strncasecmp(char *s1, char *s2, size_t len);
#else
extern int strcasecmp();
extern int strncasecmp();
#endif

#endif

#endif	/* !_TNS_COMPAT_H_ */
