/*
 *	Copyright (c) 1994,1995 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	TNSDrive $Id$
 *
 *	$Log$
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 *
 * THIS SOURCE CODE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include "loginfo.h"

extern struct loginfo process;
static FILE *xferfp = NULL;
char *xferproto;

int
initxferlog(log)
	char *log;
{
	xferproto = NULL;
	xferfp = fopen(log, "a");
	return xferfp != NULL;
}

setxferproto(proto)
	char *proto;
{
	if (xferproto != NULL) free(xferproto);
	if (proto != NULL) xferproto = strdup(proto);
	else xferproto = NULL;
}

void
xferlog(marker, size, cps, file)
	int marker, size, cps;
	char *file;
{
	char buf[20];
	time_t clocknow = time(NULL);

	if (xferfp != NULL && xferproto != NULL) {
		strftime(buf, sizeof(buf), "%d/%m/%y %H:%M:%S", localtime(&clocknow));
		(void)fprintf(xferfp, "%c %s %-20.20s %-8.8s %6d %5d %8d %s\n",
			      marker,
			      buf,
			      process.name,
			      xferproto,
			      process.baud,
			      cps,
			      size,
			      file);
		(void)fflush(xferfp);
	}
}

xferlog_dlm(path, avf, cps)
	char *path, *avf[];
	int cps;
{
	int i;
	char buf[1024];
	struct stat st;

	if (xferfp != NULL && xferproto != NULL) {
		for (i = 0; avf[i] != NULL; i++) {
			sprintf(buf, "%s/%s", path, avf[i]);
			if (stat(buf, &st) == 0)
				xferlog('D', (int)st.st_size, cps, buf);
		}
	}
}

xferlog_dl(file, size, cps)
	char *file;
	int size, cps;
{
	if (xferfp != NULL && xferproto != NULL)
		xferlog('D', size, cps, file);
}

xferlog_ulm(avf, avs, cps)
	char *avf[];
	int *avs[], cps;
{
	int i;
	char *path, buf[1024];
	extern char *uploadpath, *defuploadpath;

	if (xferfp != NULL && xferproto != NULL) {
		if (uploadpath != NULL) path = uploadpath;
		else path = defuploadpath;
		for (i = 0; avf[i] != NULL; i++) {
			sprintf(buf, "%s/%s", path, avf[i]);
			xferlog('U', avs[i], cps, buf);
		}
	}
}

xferlog_ul(file, size, cps)
	char *file;
	int size, cps;
{
	if (xferfp != NULL && xferproto != NULL)
		xferlog('U', size, cps, file);
}
