#include "conf.h"
#include "extern.h"

void squidver(char * version)
{

   FILE *ptr;
   char cmd[100];

   strcpy(cmd,SQUID_DIR);
   strcat(cmd,"/bin/squid");

   if(access(cmd,X_OK) != 0){
      fprintf(stderr, "SQMGRLOG: %s\n",msg53);
      fprintf(stderr, "SQMGRLOG:   %s\n",msg54);
      exit(1);
   }

   strcat(cmd," -v");

   if ( (ptr = popen(cmd, "r")) != NULL ) {
      fgets(version, 100, ptr);
   }

   version[strlen(version)-1]='\0';

   return;

}


void getword(char *word, char *line, char stop)
{
  int x = 0,y;

  for(x=0;((line[x]) && (line[x] != stop ));x++)
     word[x] = line[x];

  word[x] = '\0';
  if(line[x]) ++x;
    y=0;

  while((line[y++] = line[x++]));
}


void builddia(char *dia, char *mes, char *ano, char *df)
{
   char ndia[9];
   char nmes[3];
   char *str;
   char mtab1[12][4]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
   char mtab2[12][3]={"01","02","03","04","05","06","07","08","09","10","11","12"};
   int  x;

   ndia[0]='\0';
   nmes[0]='\0';

   for(x=0; x<=12; x++) {
      if(strcmp(mtab1[x],mes) == 0)
         strcpy(nmes,mtab2[x]);
   }

   if(strncmp(df,"u",1) != 0)
      sprintf(ndia,"%s/%s/%s",dia,nmes,ano);
    else
      sprintf(ndia,"%s/%s/%s",nmes,dia,ano);

   strcpy(dia,ndia);

   return;

}


void fixper(char *df, char *tbuf, char *periodo, char *cduntil)
{

   char warea[50];  
   char anof[5];  
   char anou[5];  
   struct tm *t;  

   strcpy(warea,cduntil);  
   t->tm_mday = atoi(warea+6);  
   warea[6] = '\0';  
   t->tm_mon = atoi(warea+4)-1;  
   warea[4] = '\0';  
   t->tm_year = atoi(warea)-1900;  
   warea[0] = '\0';  
   strftime(warea,10,"%Y%b%d",t);     
   strcat(periodo,warea);

//   char warea[100];
//
//   strcpy(warea,periodo);
//   if(strcmp(df,"e") == 0) {
//      strncat(warea,cduntil+4,2);
//      strcat(warea,tbuf+2);
//    } else {
//      strncat(warea,tbuf,7);
//      strncat(warea,cduntil+4,2);
//   }
//
//   strcpy(periodo,warea);

   return;
      
}


void debuga(char *msg)
{
  fprintf(stderr, "SQMGRLOG: %s\n",msg);

  return;
}


void debugaz(char *head, char *msg)
{
  fprintf(stderr, "SQMGRLOG: (util) %s=%s\n",head, msg);

  return;
}


void fixip(char *ip)
{
   char n1[MAXLEN], n2[MAXLEN], n3[MAXLEN];
   char wip[MAXLEN];
   char sep[2]=".";
   int iflag=0;

   strcpy(wip,ip);

   if(strstr(ip,".") != 0) {
      strcpy(sep,"_");
      iflag++;
   }

   if(iflag) {
      getword(n1,wip,'.');
      getword(n2,wip,'.');
      getword(n3,wip,'.');
   } else {
      getword(n1,wip,'_');
      getword(n2,wip,'_');
      getword(n3,wip,'_');
   }
   ip[0]='\0';
   sprintf(ip,"%s%s%s%s%s%s%s",n1,sep,n2,sep,n3,sep,wip);

   return;
}


char *fixnum(LONGLONGINT inteiro)
#define MAXIMO 1024
{
   char num[MAXIMO];
   char buf[MAXIMO * 2];
   char *pbuf;
   char ret[MAXIMO * 2];
   char *pret;
   register int i, j, k;

#if defined(__FreeBSD__)
   sprintf(num, "%qu", inteiro);
#elif defined(__alpha) || __ALPHA
   sprintf(num, "%ld", inteiro);
#else
   sprintf(num, "%lld", inteiro);
#endif

   for(i=0;i<MAXIMO*2;i++)
   buf[i]='\0';

   pbuf = buf;
   pret = ret;
   k = 0;

   for ( i = strlen(num) - 1, j = 0 ; i > -1; i--) {
      if ( k == 2 && i != 0 )  {
         k = 0;
         pbuf[j++] = num[i];
         pbuf[j++] = '.';
         continue;
      }
      pbuf[j] = num[i];
      j++;
      k++;
   }

   pret[0]='\0';

   for ( i = strlen(pbuf) - 1, j = 0 ; i > -1; i--, j++)
      pret[j] = pbuf[i];

      pret[j] = '\0';

      return pret;
}


void buildhref(char * href)
{
   char whref[MAXLEN];

   if(strcmp(href,"./") == 0){
      href[0]='\0';
      strcat(href,"<a href='");
      return;
   }

   href[strlen(href)-1]='\0';
   sprintf(whref,"%s",strrchr(href,'/'));

   strcpy(href,"<a href='");
   strcat(href,whref);
   strcat(href,"/");

   return;

}


char *buildtime(LONGLONGINT elap)
{

   int num = elap / 1000;
   int hor = 0;
   int min = 0;
   int sec = 0;
   size_t size = 11;
   static char buf[12];

   buf[0]='\0';

   hor=num / 3600;
   min=(num % 3600) / 60;
   sec=num % 60;
   sprintf(buf,"%02d:%02d:%02d",hor,min,sec);

   return(buf);

}


char obtdate(char *dirname, char *name, char *data)
{

   FILE *fp_in;
   char wdir[MAXLEN];

   sprintf(wdir,"%s%s/date",dirname,name);

   if ((fp_in = fopen(wdir, "r")) == 0) {
      data[0]='\0';
      return;
   }

   fgets(data,80,fp_in);
   fclose(fp_in);
   data[strlen(data)-1]='\0';

   return;

}


char obtuser(char *dirname, char *name, char *tuser)
{

   FILE *fp_in;
   char wdir[MAXLEN];

   sprintf(wdir,"%s%s/usuarios",dirname,name);

   if((fp_in=fopen(wdir,"r"))==NULL){    
      tuser[0]='\0';
      return;
   }

   fgets(tuser,20,fp_in);
   tuser[strlen(tuser)-1]='\0';
   fclose(fp_in);

   return;

}


char obttotal(char *dirname, char *name, char *tbytes, char *tuser, char *media)
{

   FILE *fp_in;
   char wdir[MAXLEN];
   LONGLONGINT wtuser=0;
   LONGLONGINT wtbytes=0;
   LONGLONGINT med=0;

   sprintf(wdir,"%s%s/geral",dirname,name);

   if ((fp_in = fopen(wdir, "r")) == 0) {
      tbytes=0;
      return;
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if(strncmp(buf,"TOTAL",5) == 0) {
#ifdef SOLARIS
         wtbytes=atoll(buf+20);
#else
         wtbytes=atol(buf+20);
#endif
         sprintf(tbytes,"%s",fixnum(wtbytes));
      }
   }

   if(tuser[0] == '\0') {
      wtuser=0;
      sprintf(media,"%s","0");
      fclose(fp_in);
      return;
   }
   

#ifdef SOLARIS
   wtuser=atoll(tuser);
   med=atoll(buf+19) / wtuser;
#else
   wtuser=atol(tuser);
   med=atol(buf+19) / wtuser;
#endif
   sprintf(media,"%s",fixnum(med));
   fclose(fp_in);

   return;

}


char gperiodo(char *dirname, char *periodo, int *debug)
{
 
   FILE *fp_ou;
 
   char wdirname[MAXLEN];

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,"periodo");
 
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,wdirname);
      exit(1);
   }
 
   fputs(periodo,fp_ou);
   fclose(fp_ou);

   if(debug)
      debuga((char *)msg47);
 
   return;
 
}

void vrfydir(char *dir, char *dirname, char *per1, char *addr, char *site, char *us, int *debug, char *form)
{
   int  num=1, count=0;
   char wdir[MAXLEN];
   char per2[MAXLEN];

   while(num) {
      if(access(dirname,R_OK) == 0){
         sprintf(dirname,"%s.%d",dir,num);
         sprintf(per2,"%s.%d",per1,num);
         num++;
         count++;
      } else
         break;
   }

   if(count > 0) {
      if(debug)
         fprintf(stderr, "SQMGRLOG: %s: %s %s %s\n",msg48,dir,msg49,dirname);
      rename(dir,dirname);
   }

   sprintf(wdir,"mkdir -p %s",dir);

   if(strlen(us) > 0) {
      strcat(wdir,"-");
      strcat(wdir,us);
   }
   if(strlen(addr) > 0) {
      strcat(wdir,"-");
      strcat(wdir,addr);
   }
   if(strlen(site) > 0) {
      strcat(wdir,"-");
      strcat(wdir,site);
   }

   system(wdir);

   sprintf(dirname,"%s",wdir+9);

   sprintf(wdir,"date >%s/%s",dirname,"date");
   system(wdir);

   return;

}


void strip_latin(char *line)
{
   char buf[255];
   char warea[255];

   while(strstr(line,"&") != 0){
      getword(warea,line,'&');
      strncat(warea,line,1);
      getword(buf,line,';');
      strcat(warea,line);
      strcpy(line,warea);
   }

   return;

}

void zdate(char *ftime, char *DateFormat)
{

   time_t t;
   struct tm *local;

   t = time(NULL);
   local = localtime(&t);
   if(strcmp(DateFormat,"u") == 0)
      strftime(ftime, 127, "%b/%d/%Y %H:%M", local);
   if(strcmp(DateFormat,"e") == 0)
      strftime(ftime, 127, "%d/%b/%Y-%H:%M", local);

   return;
}


char *fixtime(long int elap)
{

   int num = elap / 1000;
   int hor = 0;
   int min = 0;
   int sec = 0;
   static char buf[12];

   buf[0]='\0';

   hor=num / 3600;
   min=(num % 3600) / 60;
   sec=num % 60;

   sprintf(buf,"%01d:%02d:%02d",hor,min,sec);

   if(strcmp(buf,"0:00:00") == 0)
      strcpy(buf,"0");

   return buf;

}


void date_from(char *date, char *dfrom, char *duntil)
{

   char diaf[10];
   char mesf[10];
   char anof[10];
   char diau[10];
   char mesu[10];
   char anou[10];
   static char wdate[50];


   strcpy(wdate,date);
   if(strstr(wdate,"-") == 0) {
      strcat(wdate,"-");
      strcat(wdate,date);
      strcpy(date,wdate);
   }

   getword(diaf,wdate,'/');
   getword(mesf,wdate,'/');
   getword(anof,wdate,'-');
   getword(diau,wdate,'/');
   getword(mesu,wdate,'/');
   strcpy(anou,wdate);

   sprintf(dfrom,"%s%s%s",anof,mesf,diaf);
   sprintf(duntil,"%s%s%s",anou,mesu,diau);

   return;
}


char *strlow(char *string)
{
      char *s;

      if (string)
      {
            for (s = string; *s; ++s)
                  *s = tolower(*s);
      }

printf("STRING1=%s\n",string);
      return string;
}

char *subs(char *str, char *from, char *to)
{
   char *tmp;
   char *ret;
   int ss, st;
   int x=0;

   if(strstr(str,from) == 0)
      return (char *) str;

    ss = strlen(str); st = strlen(to);
    ret = (char *) malloc(ss + st);
    for(x==0;x<=strlen(ret);x++)
       ret[x]='\0';

    tmp = strstr(str, from);
    if ( tmp == (char *) NULL )
       return (char *) NULL;
    strncpy(ret, str, ss - strlen(tmp));
    strcat(ret, to);
    strcat(ret, (tmp+strlen(from)));
    return (char *) ret;
}
