/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

int totalger(const char *dirname, int *debug, const char *outdir)

{


   FILE *fp_in, *fp_ou;
   unsigned long int tnacc=0;
   LONGLONGINT tnbytes=0;
   LONGLONGINT telap=0;
   LONGLONGINT tincache=0, toucache=0;
   char wger[MAXLEN], user[MAXLEN], nacc[10], nbytes[10], url[1024];
   char ip[MAXLEN], hora[9], data[9], elap[15];
   char incac[15], oucac[15];

   strcpy(wger,dirname);
   strcat(wger,"/geral");

   if((fp_in=fopen(wger,"r"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (totger) %s: %s\n",msg42,wger);
      exit(1);
   }

   fscanf(fp_in,"%s",user);
   fscanf(fp_in,"%s",nacc);
   fscanf(fp_in,"%s",nbytes);
   fscanf(fp_in,"%s",url);
   fscanf(fp_in,"%s",ip);
   fscanf(fp_in,"%s",hora);
   fscanf(fp_in,"%s",data);
   fscanf(fp_in,"%s",elap);
   fscanf(fp_in,"%s",incac);
   fscanf(fp_in,"%s",oucac);

   while(!feof(fp_in))
   {

      tnacc+=atol(nacc);
      tnbytes+=atol(nbytes);
      telap+=atol(elap);
      tincache+=atol(incac);
      toucache+=atol(oucac);

      fscanf(fp_in,"%s",user);
      fscanf(fp_in,"%s",nacc);
      fscanf(fp_in,"%s",nbytes);
      fscanf(fp_in,"%s",url);
      fscanf(fp_in,"%s",ip);
      fscanf(fp_in,"%s",hora);
      fscanf(fp_in,"%s",data);
      fscanf(fp_in,"%s",elap);
      fscanf(fp_in,"%s",incac);
      fscanf(fp_in,"%s",oucac);
   }

   fclose(fp_in);

   strcpy(wger,dirname);
   strcat(wger,"/geral");

   if((fp_ou=fopen(wger,"a"))==NULL) {
    fprintf(stderr, "SQMGRLOG: (totger) %s: %s\n",msg42,wger);
    exit(1);
   }

   url[0]='\0';

#if defined(__FreeBSD__)
   sprintf(url,"TOTAL   %010d %015qu %015qu %015qu %015qu\n",tnacc,tnbytes,telap,tincache,toucache);
#elif defined(__alpha) || __ALPHA
   sprintf(url,"TOTAL   %010d %015ld %015ld %015ld %015ld\n",tnacc,tnbytes,telap,tincache,toucache);
#else
   sprintf(url,"TOTAL   %010d %015lld %015lld %015lld %015lld\n",tnacc,tnbytes,telap,tincache,toucache);
#endif
   fputs(url,fp_ou);
   fclose(fp_ou);

   return (0);
}
