/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"


void totaliza_day(const char *dirname, char *user, int *indexonly)
{

   FILE *fp_in, *fp_ou;
      
   char data[15];
   char hora[15];
   char elap[15];
   char odata[15];
   char ohora[15];
   char oelap[15];
   char whora[3];
   char csort[255];
   char wdirname[MAXLEN];
   char sortout[MAXLEN];
   char arqout[MAXLEN];
   int  regs=0;
   long int telap=0;

   if(indexonly)
      return;

   sprintf(wdirname,"%s/%s.htmp",dirname,user);
   sprintf(arqout,"%s/%s.day",dirname,user);
   sprintf(sortout,"%s/%s.sort",dirname,user);

   sprintf(csort,"sort  -k 1,1 -k 2,2 -o %s %s",sortout,wdirname);
   system(csort);

   unlink(wdirname);

   if((fp_in=fopen(sortout,"r"))==NULL) {
     fprintf(stderr, "SQMGRLOG: (totday) %s: %s\n",msg05,sortout);
     exit(1);
   }

   if((fp_ou=fopen(arqout,"w"))==NULL) {
     fprintf(stderr, "SQMGRLOG: (totday) %s: %s\n",msg05,arqout);
     exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(data,buf,' ');
      getword(hora,buf,':');
      getword(elap,buf,' ');
      getword(elap,buf,' ');
      elap[strlen(elap)-1]='\0';

      if(!regs) {
         strcpy(odata,data);
         strcpy(ohora,hora);
         strcpy(oelap,elap);
         regs++;
      }

      if(strcmp(hora,ohora) != 0) {
         sprintf(buf,"%s %s %010d\n",odata,ohora,telap);
         fputs(buf, fp_ou);
         strcpy(odata,data);
         strcpy(ohora,hora);
         telap=0;
      }

      telap+=atol(elap);
   }
   sprintf(buf,"%s %s %010d\n",data,hora,telap);
   fputs(buf, fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(sortout);

   return;

}
