/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

int topuser(const char *dirname, int *debug, const char *outdir, int *userip, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *SortField1, char *SortOrder1, char *UserAgentLog, char *DateFormat)

{

   FILE *fp_in, *fp_ou, *fp_top1, *fp_top2, *fp_top3, *fp_tusr;
   LONGLONGINT ttnbytes=0, ttnacc=0, tnacc=0;
   LONGLONGINT tnbytes=0, ttnelap=0, tnelap=0;
   LONGLONGINT tnincache=0, tnoucache=0, ttnincache=0, ttnoucache=0;
   float perc=0.00;
   float perc2=0.00;
   float inperc=0.00, ouperc=0.00;
   int posicao=0;
   char olduser[MAXLEN], csort[MAXLEN], periodo[MAXLEN], arqper[MAXLEN];
   char wger[MAXLEN], top1[MAXLEN], top2[MAXLEN], top3[MAXLEN];
   char user[MAXLEN], nacc[10], nbytes[10], url[1024], preg[8000], tusr[MAXLEN];
   char ip[MAXLEN], hora[9], data[9], elap[15], incac[15], oucac[15], user2[MAXLEN], html[MAXLEN];
   char ipantes[MAXLEN], nameantes[MAXLEN];
   char href[MAXLEN];
   char href2[MAXLEN];
   char lhtm23[50];
   char sfield[10]="2,2";
   char order[3]="-r";
   char wheader[50];
   char ftime[128];
   int *str, totuser=0;
   char *s;


   ipantes[0]='\0';
   nameantes[0]='\0';

   strcpy(wger,dirname);
   strcpy(top1,dirname);
   strcpy(top2,dirname);
   strcpy(top3,dirname);
   strcpy(tusr,dirname);
   strcat(wger,"/geral");
   strcat(top1,"/top");
   strcat(top2,"/top.tmp");
   strcat(tusr,"/usuarios");
   strcat(top3,"/index.html");

   if((fp_in=fopen(wger,"r"))==NULL) {
    fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,wger);
    exit(1);
   }

   if((fp_top1=fopen(top1,"w"))==NULL) {
    fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,top1);
    exit(1);
   }

   if((fp_top2=fopen(top2,"w"))==NULL) {
    fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,top2);
    exit(1);
   }

   fscanf(fp_in,"%s",user);
   fscanf(fp_in,"%s",nacc);
   fscanf(fp_in,"%s",nbytes);
   fscanf(fp_in,"%s",url);
   fscanf(fp_in,"%s",ip);
   fscanf(fp_in,"%s",hora);
   fscanf(fp_in,"%s",data);
   fscanf(fp_in,"%s",elap);
   fscanf(fp_in,"%s",incac);
   fscanf(fp_in,"%s",oucac);

   strcpy(olduser,user);
   totuser=1;

   while(!feof(fp_in)) {
      if(strcmp(olduser,user) != 0) {
         if(strcmp(user,"TOTAL") != 0)
            totuser++;

#if defined(__FreeBSD__)
         sprintf(preg,"%s %15qu %15qu %15qu %15qu %15qu\n",olduser,tnbytes,tnacc,tnelap,tnincache,tnoucache);
#elif defined(__alpha) || __ALPHA
         sprintf(preg,"%s %15ld %15ld %15ld %15ld %15ld\n",olduser,tnbytes,tnacc,tnelap,tnincache,tnoucache);
#else
         sprintf(preg,"%s %15lld %15lld %15lld %15lld %15lld\n",olduser,tnbytes,tnacc,tnelap,tnincache,tnoucache);
#endif
         fputs(preg,fp_top2);
	 strcpy(olduser,user);
         ttnbytes+=tnbytes;
	 ttnacc+=tnacc;
	 ttnelap+=tnelap;
         ttnincache+=tnincache;
         ttnoucache+=tnoucache;
         tnbytes=0;
         tnacc=0;
         tnelap=0; 
         tnincache=0;
         tnoucache=0;
      }

      tnbytes+=atol(nbytes);
      tnacc+=atol(nacc);
      tnelap+=atol(elap);
      tnincache+=atol(incac);
      tnoucache+=atol(oucac);

      fscanf(fp_in,"%s",user);
      fscanf(fp_in,"%s",nacc);
      fscanf(fp_in,"%s",nbytes);
      fscanf(fp_in,"%s",url);
      fscanf(fp_in,"%s",ip);
      fscanf(fp_in,"%s",hora);
      fscanf(fp_in,"%s",data);
      fscanf(fp_in,"%s",elap);
      fscanf(fp_in,"%s",incac);
      fscanf(fp_in,"%s",oucac);

      if(strcmp(user,"TOTAL") == 0)
         continue;
   }

#if defined(__FreeBSD__)
   sprintf(preg,"%s %15qu %15qu %15qu %15qu %15qu\n",olduser,tnbytes,tnacc,tnelap,tnincache,tnoucache);
#elif defined(__alpha) || __ALPHA
   sprintf(preg,"%s %15ld %15ld %15ld %15ld %15ld\n",olduser,tnbytes,tnacc,tnelap,tnincache,tnoucache);
#else
   sprintf(preg,"%s %15lld %15lld %15lld %15lld %15lld\n",olduser,tnbytes,tnacc,tnelap,tnincache,tnoucache);
#endif
   fputs(preg,fp_top2);

   ttnbytes+=tnbytes;
   ttnacc+=tnacc;
   ttnelap+=tnelap;
   ttnincache+=tnincache;
   ttnoucache+=tnoucache;

#if defined(__FreeBSD__)
   sprintf(preg,"TOTAL %15qu %15qu %15qu %15qu %15qu\n",ttnbytes,ttnacc,ttnelap,ttnincache,ttnoucache);
#elif defined(__alpha) || __ALPHA
   sprintf(preg,"TOTAL %15ld %15ld %15ld %15ld %15ld\n",ttnbytes,ttnacc,ttnelap,ttnincache,ttnoucache);
#else
   sprintf(preg,"TOTAL %15lld %15lld %15lld %15lld %15lld\n",ttnbytes,ttnacc,ttnelap,ttnincache,ttnoucache);
#endif

   fclose(fp_in);
   fclose(fp_top2);

   if(strcmp(SortField1,"USER") == 0)
      strcpy(sfield,"1,1");

   if(strcmp(SortField1,"CONNECTION") == 0)
      strcpy(sfield,"3,3");

   if(strcmp(SortField1,"TIME") == 0)
      strcpy(sfield,"4,4");

   if(strcmp(SortOrder1,"normal") == 0)
      order[0]='\0';

   sprintf(csort,"sort -T %s %s -k %s -o %s %s", TempDir, order, sfield, top1, top2);
   system(csort);

   unlink(top2);

   if((fp_top1=fopen(top1,"a"))==NULL) {
    fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,top1);
    exit(1);
   }
   fputs(preg,fp_top1);
   fclose(fp_top1);

   if((fp_top1=fopen(top1,"r"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,top1);
      exit(1);
   }

   if((fp_top3=fopen(top3,"w"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,top3);
      exit(1);
   }

 /*
 * Obtem o periodo
 */

   strcpy(arqper,dirname);
   strcat(arqper,"/periodo");

   if ((fp_in = fopen(arqper, "r")) == 0) {
      fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,arqper);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   fputs("<html>\n",fp_top3);

   if(strlen(FontFace) > 0) {
      sprintf(preg,"<font face=%s>\n",FontFace);
      fputs(preg,fp_top3);
   }

   sprintf(preg,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   fputs(preg,fp_top3);

   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_top3);

   if(strlen(LogoImage) > 0) {
      sprintf(preg,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(preg,fp_top3);
   }

   sprintf(preg,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(preg,fp_top3);

   sprintf(preg,"<tr><td align=center bgcolor=%s><font size=%s>%s: %s</font></td></tr>\n",HeaderBgColor,FontSize,htm02,periodo);
   fputs(preg,fp_top3);
   strcat(wheader,(char *)htm17);
   strcat(wheader,": ");
   strcat(wheader,SortField1);
   strcat(wheader,", ");
   strcat(wheader,SortOrder1);
   sprintf(preg,"<tr><td align=center bgcolor=%s><font size=%s>%s</font></td></tr>\n",HeaderBgColor,FontSize,wheader);
   fputs(preg,fp_top3);

   fputs("</table></center>\n",fp_top3);
   fputs("<center><table cellpadding=1 cellspacing=1>\n",fp_top3);
   fputs("<tr><td></td><td></td></tr>",fp_top3);

   sprintf(preg,"<tr><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s></font></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%%%s</font></th><th bgcolor=%s colspan=2><font size=%s color=%s>%s-%s-%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%%%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm13,HeaderBgColor,FontSize,HeaderColor,HeaderBgColor,FontSize,HeaderColor,htm11,HeaderBgColor,FontSize,HeaderColor,htm05,HeaderBgColor,FontSize,HeaderColor,htm06,HeaderBgColor,FontSize,HeaderColor,htm06,HeaderBgColor,FontSize,HeaderColor,htm27,htm28,htm26,HeaderBgColor,FontSize,HeaderColor,htm07,HeaderBgColor,FontSize,HeaderColor,htm08,HeaderBgColor,FontSize,HeaderColor,htm12);
   fputs(preg,fp_top3);

   strcpy(preg,"<tr><td></td></tr>\n");
   fputs(preg,fp_top3);

   fscanf(fp_top1,"%s",user);
   fscanf(fp_top1,"%s",nbytes);
   fscanf(fp_top1,"%s",nacc);
   fscanf(fp_top1,"%s",elap);
   fscanf(fp_top1,"%s",incac);
   fscanf(fp_top1,"%s",oucac);

   while(!feof(fp_top1)) {
      strcpy(user2,user);
      tnbytes=atol(nbytes);

      if(tnbytes) {
         perc=tnbytes * 100;
         perc=perc / ttnbytes;
      } else perc = 0;

      if(atol(elap)) {
         perc2=atol(elap) * 100;
         perc2=perc2 / ttnelap;
      } else perc2 = 0;

      if(atol(incac)) {
         inperc=atol(incac) * 100;
         inperc=inperc / tnbytes;
      } else inperc = 0;

      if(atol(oucac)) {
         ouperc=atol(oucac) * 100;
         ouperc=ouperc / tnbytes;
      } else ouperc = 0;

      strcpy(href," ");
      strcpy(href2," ");
      if(strcmp(user,"TOTAL") != 0){
         strcpy(href,"<a href='");
         strcpy(href2,"<a href='d");
         strcat(href,user);
         strcat(href2,user);
         strcat(href,".html'>");
         strcat(href2,".html'>");
      }

      posicao++;

      tnelap=atol(elap);

      if(userip) {
         fixip(user2);
         if(strcmp(Ip2Name,"yes") == 0) {
            if(strcmp(user2,ipantes) != 0) {
               strcpy(ipantes,user2);
               ip2name(user2);
               strcpy(nameantes,user2);
            } else strcpy(user2,nameantes);
         }
      }
    
      sprintf(lhtm23,"%s",htm23);
      if(lhtm23){
            for(s=lhtm23; *s; ++s)
                  *s=tolower(*s);
      }

#if defined(__FreeBSD__)
      sprintf(preg,"<tr><td align=right border=0 bgcolor=%s><font size=%s>%d</font></td><td bgcolor=%s><font size=%s>%s%s</font></td><td bgcolor=%s><font size=%s>%s%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%15s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%qu</font><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td></tr>\n",TxBgColor,FontSize,posicao,TxBgColor,FontSize,href2,lhtm23,TxBgColor,FontSize,href,user2,TxBgColor,FontSize,nacc,TxBgColor,FontSize,fixnum(tnbytes),TxBgColor,FontSize,perc,TxBgColor,FontSize,inperc,TxBgColor,FontSize,ouperc,TxBgColor,FontSize,buildtime(tnelap),TxBgColor,FontSize,tnelap,TxBgColor,FontSize,perc2);
#elif defined(__alpha) || __ALPHA
      sprintf(preg,"<tr><td align=right border=0 bgcolor=%s><font size=%s>%d</font></td><td bgcolor=%s><font size=%s>%s%s</font></td><td bgcolor=%s><font size=%s>%s%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%15s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%ld</font><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td></tr>\n",TxBgColor,FontSize,posicao,TxBgColor,FontSize,href2,lhtm23,TxBgColor,FontSize,href,user2,TxBgColor,FontSize,nacc,TxBgColor,FontSize,fixnum(tnbytes),TxBgColor,FontSize,perc,TxBgColor,FontSize,inperc,TxBgColor,FontSize,ouperc,TxBgColor,FontSize,buildtime(tnelap),TxBgColor,FontSize,tnelap,TxBgColor,FontSize,perc2);
#else
      sprintf(preg,"<tr><td align=right border=0 bgcolor=%s><font size=%s>%d</font></td><td bgcolor=%s><font size=%s>%s%s</font></td><td bgcolor=%s><font size=%s>%s%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%15s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%lld</font><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td></tr>\n",TxBgColor,FontSize,posicao,TxBgColor,FontSize,href2,lhtm23,TxBgColor,FontSize,href,user2,TxBgColor,FontSize,nacc,TxBgColor,FontSize,fixnum(tnbytes),TxBgColor,FontSize,perc,TxBgColor,FontSize,inperc,TxBgColor,FontSize,ouperc,TxBgColor,FontSize,buildtime(tnelap),TxBgColor,FontSize,tnelap,TxBgColor,FontSize,perc2);
#endif

      if(strstr(user,"TOTAL") != 0){

	 strcpy(preg,"<tr><td></td></tr><tr><td></td></tr>");
         fputs(preg,fp_top3);

         if(atol(incac)) {
            inperc=ttnbytes / 100;
            inperc=atol(incac) / inperc;
         } else inperc = 0;

         if(atol(oucac)) {
            ouperc=ttnbytes / 100;
            ouperc=atol(oucac) / ouperc;
         } else ouperc = 0;

#if defined(__FreeBSD__)
         sprintf(preg,"<tr><td></td><th align=left bgcolor=%s><font size=%s color=%s>%s</th><td></td><th align=right bgcolor=%s><font size=%s color=%s>%qu</th><th align=right bgcolor=%s><font size=%s color=%s>%15s</th><td></td><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=center bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%qu</th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm20,HeaderBgColor,FontSize,HeaderColor,ttnacc,HeaderBgColor,FontSize,HeaderColor,fixnum(ttnbytes),HeaderBgColor,FontSize,HeaderColor,inperc,HeaderBgColor,FontSize,HeaderColor,ouperc,HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap),HeaderBgColor,FontSize,HeaderColor,ttnelap);
#elif defined(__alpha) || __ALPHA
         sprintf(preg,"<tr><td></td><th align=left bgcolor=%s><font size=%s color=%s>%s</th><td></td><th align=right bgcolor=%s><font size=%s color=%s>%ld</th><th align=right bgcolor=%s><font size=%s color=%s>%15s</th><td></td><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=center bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%ld</th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm20,HeaderBgColor,FontSize,HeaderColor,ttnacc,HeaderBgColor,FontSize,HeaderColor,fixnum(ttnbytes),HeaderBgColor,FontSize,HeaderColor,inperc,HeaderBgColor,FontSize,HeaderColor,ouperc,HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap),HeaderBgColor,FontSize,HeaderColor,ttnelap);
#else
         sprintf(preg,"<tr><td></td><th align=left bgcolor=%s><font size=%s color=%s>%s</th><td></td><th align=right bgcolor=%s><font size=%s color=%s>%lld</th><th align=right bgcolor=%s><font size=%s color=%s>%15s</th><td></td><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=center bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%lld</th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm20,HeaderBgColor,FontSize,HeaderColor,ttnacc,HeaderBgColor,FontSize,HeaderColor,fixnum(ttnbytes),HeaderBgColor,FontSize,HeaderColor,inperc,HeaderBgColor,FontSize,HeaderColor,ouperc,HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap),HeaderBgColor,FontSize,HeaderColor,ttnelap);

#endif
      }

      fputs(preg,fp_top3);

      fscanf(fp_top1,"%s",user);
      fscanf(fp_top1,"%s",nbytes);
      fscanf(fp_top1,"%s",nacc);
      fscanf(fp_top1,"%s",elap);
      fscanf(fp_top1,"%s",incac);
      fscanf(fp_top1,"%s",oucac);
   }

   if(ttnbytes) {
      tnbytes=ttnbytes / totuser;
   } else tnbytes=0;

#if defined(__FreeBSD__)
   sprintf(preg,"<tr><th></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th></th><th align=right bgcolor=%s><font size=%s color=%s>%qu</font></th><th align=right bgcolor=%s><font size=%s color=%s>%15s</font></th><th></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%qu</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm09,HeaderBgColor,FontSize,HeaderColor,ttnacc/totuser,HeaderBgColor,FontSize,HeaderColor,fixnum(tnbytes),HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap/totuser),HeaderBgColor,FontSize,HeaderColor,ttnelap/totuser);
#elif defined(__alpha) || __ALPHA
   sprintf(preg,"<tr><th></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th></th><th align=right bgcolor=%s><font size=%s color=%s>%ld</font></th><th align=right bgcolor=%s><font size=%s color=%s>%15s</font></th><th></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%ld</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm09,HeaderBgColor,FontSize,HeaderColor,ttnacc/totuser,HeaderBgColor,FontSize,HeaderColor,fixnum(tnbytes),HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap/totuser),HeaderBgColor,FontSize,HeaderColor,ttnelap/totuser);
#else
   sprintf(preg,"<tr><th></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th></th><th align=right bgcolor=%s><font size=%s color=%s>%lld</font></th><th align=right bgcolor=%s><font size=%s color=%s>%15s</font></th><td></td><td></td><td></td><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%lld</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm09,HeaderBgColor,FontSize,HeaderColor,ttnacc/totuser,HeaderBgColor,FontSize,HeaderColor,fixnum(tnbytes),HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap/totuser),HeaderBgColor,FontSize,HeaderColor,ttnelap/totuser);
#endif
   fputs(preg,fp_top3);

   if(strlen(UserAgentLog) > 0) {
      fputs("<tr><td></td></tr>\n",fp_top3);
      fputs("<tr><td></td></tr>\n",fp_top3);
      fputs("<td align=left colspan=8><font size=-1><a href='useragent.html'>Useragent</a> Report</td>\n",fp_top3);
   }

   strcpy(preg,"</table></center>");
   fputs(preg,fp_top3);

   zdate(ftime, DateFormat);
   sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",htm21,URL,PGM,VERSION,htm22,ftime);
   fputs(html,fp_top3);

   fclose(fp_top1);
   unlink(top1);

   fclose(fp_top3);

   if((fp_ou=fopen(tusr,"w"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (topuser) %s: %s\n",msg42,tusr);
      exit(1);
   }

   sprintf(preg,"%d\n",totuser);
   fputs(preg,fp_ou);

   fclose(fp_ou);

   return (0);
}
