/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

void splitlog(char *arq, char *df, int dfrom, int duntil, char *convert)
{

   FILE *fp_in;
   char buf[8192];
   char data[30];
   char dia[9];
   char hora[9];
   char wdata[20];
   time_t tt;
   int idata=0;
   struct tm *t;

   if(arq[0] == '\0')
      strcpy(arq,"/usr/local/squid/logs/access.log");

   if((fp_in=fopen(arq,"r"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (splitlog) %s: %s\n",msg05,arq);
      exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(data,buf,' ');
      tt=atoi(data);
      t=localtime(&tt);

      if(dfrom) {
         strftime(wdata, 127, "%Y%m%d", t);
         idata=atoi(wdata);
	 if(idata < dfrom || idata > duntil)
         continue;
      }

      if(strcmp(convert,"onvert") != 0) {
         printf("%s %s",data,buf);
         continue;
      }

      if(strncmp(df,"e",1) == 0)
         strftime(dia, 127, "%d/%m/%Y", t);
       else
         strftime(dia, 127, "%m/%d/%Y", t);

      sprintf(hora,"%02d:%02d:%02d",t->tm_hour,t->tm_min,t->tm_sec);
      printf("%s %s %s",dia,hora,buf);
   }

   fclose(fp_in);
}
