/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

int gerarel(char *tmp, int *debug, const char *periodo, int *debugz, int *iprel, char* outdir, char *addr, char *site, char *us, int *userip, char *email, char *temp2, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *SortField1, char *SortField2, char *SortOrder1, char *SortOrder2, char *UserAgentLog, char *abuse, char *DateFormat, int *indexonly, char *PerUserLimitFile, char *PerUserLimit)
{

   FILE *fp_in, *fp_ou;

   time_t tt;
   char accdia[9], acchora[9], accuser[MAXLEN], accip[MAXLEN], accurl[MAXLEN], acctam[12], accelap[10];
   char oldaccdia[9], oldacchora[9], oldaccip[MAXLEN], wdir[MAXLEN], per1[MAXLEN];
   char dirname[MAXLEN], wdirname[MAXLEN], accnome[50], oldurl[MAXLEN], oldaccuser[MAXLEN], struser[MAXLEN];
   char olduser[MAXLEN], oldmsg[50], acccode[50], oldaccelap[10], oldacccode[50];
   char ipantes[MAXLEN], nameantes[MAXLEN]; 
   char wcrc[50];
   char crc2[50];
   char *userfile;
   unsigned long nbytes=0; 
   unsigned long nelap=0; 
   unsigned long nacc=0;
   unsigned long rtotal=0;
   unsigned long incache=0;
   unsigned long oucache=0;

   ipantes[0]='\0';
   nameantes[0]='\0';

   sprintf(dirname, "%s%s", outdir, periodo);
   sprintf(wdir, "%s%s", outdir, periodo);
   strcpy(per1,periodo);
   vrfydir(wdir, dirname, per1, addr, site, us, debug, email, temp2);

   if(debugz){
      debugaz("dirname",dirname);
      debugaz("wdir",wdir);
   }
 
   strcpy(wdirname,dirname);
   gperiodo(wdirname, periodo, debug);

   if(strlen(UserAgentLog) > 0 && email[0] == '\0') {
      strcpy(wdirname,dirname);
      useragent(wdirname,debug,outdir,TempDir,UserAgentLog,periodo,BgColor,TxColor,TxBgColor,TiColor,LogoImage,LogoText,LogoTextColor,Width,Height,Title,BgImage,FontFace,HeaderColor,HeaderBgColor,FontSize,Ip2Name, DateFormat);
   }

   olduser[0]='\0';

   if((fp_in=fopen(tmp,"r"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,tmp);
      exit(1);}

   fscanf(fp_in,"%s",accdia);
   fscanf(fp_in,"%s",acchora);
   fscanf(fp_in,"%s",accuser);
   fscanf(fp_in,"%s",accip);
   fscanf(fp_in,"%s",accurl);
   fscanf(fp_in,"%s",acctam);
   fscanf(fp_in,"%s",acccode);
   fscanf(fp_in,"%s",accelap);

   while(!feof(fp_in)) {
      if(strcmp(Ip2Name,"yes") == 0) {
         if(strcmp(accip,ipantes) != 0) {
            strcpy(ipantes,accip);
            ip2name(accip);
            strcpy(nameantes,accip);
         } else strcpy(accip,nameantes);
      }
     
      if(strcmp(olduser,accuser) != 0){
         strcpy(wdirname,dirname);
	 criatmp(accuser,wdirname,debug,indexonly);
	 criatmp_hora(accuser,wdirname,indexonly);
         strcpy(olduser,accuser);
      }

      strcpy(wdirname,dirname);
      gravatmp_hora(wdirname,accuser,accdia,acchora,accelap,indexonly);

      if(iprel){
         strcpy(wdirname,dirname);
         gravaporuser(accuser,wdirname,accurl,accip,accdia,acchora,acctam,accelap,indexonly);
      }

      if(!rtotal){
         strcpy(oldurl,accurl);
         strcpy(oldacccode,acccode);
         strcpy(oldaccelap,accelap);
         strcpy(oldaccuser,accuser);
         strcpy(oldaccip,accip);
         strcpy(oldaccdia,accdia);
         strcpy(oldacchora,acchora);
         rtotal++;
      }
        
      if(strcmp(oldurl,accurl) != 0){
         strcpy(oldmsg,"OK");
         if(strstr(oldacccode,"DENIED") != 0)
            sprintf(oldmsg,"%s",msg43);
         strcpy(wdirname,dirname);
         gravatmp(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
         strcpy(wdirname,dirname);
         gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
         nacc=0;
         nbytes=0;
         nelap=0;
         incache=0;
         oucache=0;
      }
      nacc++;
      nbytes=nbytes+atol(acctam);
      nelap=nelap+atol(accelap);

      strcpy(wcrc,acccode);
      getword(crc2,wcrc,'/');

      if(strcmp(crc2,"TCP_MISS") == 0)
         oucache+=atol(acctam);
       else incache+=atol(acctam);

      strcpy(oldurl,accurl);

      if(strcmp(accuser,oldaccuser) != 0) {
         strcpy(wdirname,dirname);
         totaliza_day(wdirname,oldaccuser,indexonly);
      }

      strcpy(oldaccuser,accuser);
      strcpy(oldacccode,acccode);
      strcpy(oldaccelap,accelap);
      strcpy(oldaccip,accip);
      strcpy(oldaccdia,accdia);
      strcpy(oldacchora,acchora);

      fscanf(fp_in,"%s",accdia);
      fscanf(fp_in,"%s",acchora);
      fscanf(fp_in,"%s",accuser);
      fscanf(fp_in,"%s",accip);
      fscanf(fp_in,"%s",accurl);
      fscanf(fp_in,"%s",acctam);
      fscanf(fp_in,"%s",acccode);
      fscanf(fp_in,"%s",accelap);

   }
//   nacc--;
//   nbytes-=atol(acctam);
//   nelap-=atol(accelap);

   strcpy(oldmsg,"OK");
   if(strstr(oldacccode,"DENIED") != 0)
      sprintf(oldmsg,"%s",msg43);
   strcpy(wdirname,dirname);
   gravatmpf(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
   strcpy(wdirname,dirname);
   gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
   strcpy(wdirname,dirname);
   totaliza_day(wdirname,oldaccuser,indexonly);
 
   fclose(fp_in);

   strcpy(wdirname,dirname);
   tmpsort(wdirname, debug, TempDir, SortField1, SortField2, SortOrder1, SortOrder2, indexonly);

   strcpy(wdirname,dirname);
   totalger(wdirname, debug, outdir, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir);

   if(strlen(email) == 0) {
      strcpy(wdirname,dirname);
      topuser(wdirname, debug, outdir, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, Ip2Name, SortField1, SortOrder1, UserAgentLog, DateFormat);

      strcpy(wdirname,dirname);
      htmlrel(wdirname, debug, iprel, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, SortField2, SortOrder2, DateFormat, indexonly, PerUserLimitFile, PerUserLimit);

      strcpy(wdirname,outdir);
      geraindex(wdirname, debug, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, DateFormat);

      fprintf(stderr, "SQMGRLOG: %s %s\n",msg44,dirname);
    } else {
      strcpy(wdirname,dirname);
      geramail(wdirname, debug, outdir, userip, email, TempDir);

      if(strcmp(email,"stdout") != 0)
         fprintf(stderr, "SQMGRLOG: %s %s\n",msg45,email);
   }

   if(indexonly) {
      strcpy(wdirname,dirname);
      index_only(wdirname, debug);
   }

   return;
}


int criatmp(char *user, char *dirname, int debug, int indexonly)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly)
      return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);

   if(debug){
      sprintf(msg,"%s: %s",msg46,wdirname);
      debuga(msg);
   }

   strcat(wdirname,".tmp");
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,wdirname);
      exit(1);
   }

   fclose(fp_ou);
   return;
}


int criatmp_hora(char *user, char *dirname, int indexonly)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly)
      return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);

   strcat(wdirname,".htmp");
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,wdirname);
      exit(1);
   }

   fclose(fp_ou);
   return;
}


int gravatmp(char *oldaccuser, char *dirname, char *oldurl, unsigned long nacc, unsigned long nbytes, char *oldmsg, unsigned long nelap, int indexonly, unsigned long incache, unsigned long oucache)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly)
      return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,oldaccuser);
   strcat(wdirname,".tmp");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,wdirname);
      exit(1);
   } 

   sprintf(reg,"%010d %010d %s %s %010d %010d %010d\n",nacc,nbytes,oldurl,oldmsg,nelap,incache,oucache);
   fputs(reg,fp_ou);

   fclose(fp_ou);

   return(0);

}


int gravatmp_hora(char *dirname, char *user, char *data, char *hora, char *elap, int indexonly)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly)
      return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);
   strcat(wdirname,".htmp");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,wdirname);
      exit(1);
   }

   sprintf(reg,"%s %s %s\n",data,hora,elap);
   fputs(reg,fp_ou);

   fclose(fp_ou);

   return(0);
}


int gravaporuser(char *user, char *dirname, char *url, char *ip, char *data, char *hora, char *tam, char *elap, int indexonly)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly)
      return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);
   strcat(wdirname,".ip");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,wdirname);
      exit(1);
   } 

   sprintf(reg,"%s %s %s %s %s %s\n",ip,url,data,hora,tam,elap);
   fputs(reg,fp_ou);

   fclose(fp_ou);

   return(0);

}


int gravatmpf(char *oldaccuser, char *dirname, char *oldurl, unsigned long nacc, unsigned long nbytes, char *oldmsg, unsigned long nelap, int indexonly, unsigned long incache, unsigned long oucache)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly)
      return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,oldaccuser);
   strcat(wdirname,".tmp");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,wdirname);
      exit(1);
   }

   sprintf(reg,"%010d %010d %s %s %010d %010d %010d\n",nacc,nbytes,oldurl,oldmsg,nelap,incache,oucache);
   fputs(reg,fp_ou);

   fclose(fp_ou);
   return;
     
}


int gravager(char *dirname, char *user, unsigned long *nacc, char *url, unsigned long *nbytes, char *ip, char *hora, char *dia, unsigned long *nelap, unsigned long incache, unsigned long oucache)
{

   FILE *fp_ou;
   char reg[MAXLEN];

   strcat(dirname,"/");
   strcat(dirname,"geral");
   
   if((fp_ou=fopen(dirname,"a"))==NULL){
      fprintf(stderr, "SQMGRLOG: (report) %s: %s\n",msg42,dirname);
      exit(1);
   }

   sprintf(reg,"%s %010d %010d %s %s %s %s %010d %010d %010d\n",user,nacc,nbytes,url,ip,hora,dia,nelap,incache,oucache);
   fputs(reg,fp_ou);

   fclose(fp_ou);
   return;

}
