/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "language.h"

char *userfile;
char *excludefile;
char *excludeuser;
void getusers(char *pwdfile, int debug);
void gethexclude(char *hexfile, int debug);
void getuexclude(char *uexfile, int debug);
void ttx(char *user);

main(argc,argv)
   int argc;
   char *argv[];
{

   FILE *fp_in, *fp_ou;
   DIR *dirp;
   struct dirent *direntp;

   extern int optind;
   extern char *optarg;

   char ConfigFile[MAXLEN];
   char AccessLog[MAXLEN];
   char Title[MAXLEN];
   char BgColor[MAXLEN];
   char BgImage[MAXLEN];
   char TxColor[MAXLEN];
   char TxBgColor[MAXLEN];
   char TiColor[MAXLEN];
   char LogoImage[MAXLEN];
   char LogoText[MAXLEN];
   char LogoTextColor[MAXLEN];
   char Width[MAXLEN];
   char Height[MAXLEN];
   char FontFace[MAXLEN];
   char HeaderColor[MAXLEN];
   char HeaderBgColor[MAXLEN];
   char FontSize[MAXLEN];
   char PasswdFile[MAXLEN];
   char TempDir[MAXLEN];
   char OutputDir[MAXLEN];
   char OutputEmail[MAXLEN];
   char Ip2Name[5];
   char SortField1[30];
   char SortField2[30];
   char SortOrder1[10];
   char SortOrder2[10];
   char UserAgentLog[255];
   char ExcludeHosts[255];
   char ExcludeUsers[255];
   char Abuse[5];
   char DateFormat[2];
   char PerUserLimitFile[255];
   char PerUserLimit[20];

   char w[MAXLEN];

   char data[255], elap[255], welap[255], none[255], ip[MAXLEN], msg[MAXLEN], tam[255], fun[255];
   char url[1024], user[MAXLEN], proxyserv[MAXLEN], content[MAXLEN], wuser[MAXLEN]; 
   char code[MAXLEN], code2[MAXLEN], wip[MAXLEN];
   time_t tt;
   struct tm *t;
   char *time_string;
   char periodo[MAXLEN], df[20];
   char dia[128], wdata[128], mes[30], ano[30], hora[30];
   char tmp[MAXLEN], tmp2[MAXLEN], tmp3[MAXLEN], wtemp[MAXLEN], wtemp2[255];
   char us[50], date[255];
   char arq[MAXLEN], addr[MAXLEN], hm[6], site[MAXLEN], uagent[MAXLEN];
   char hexclude[MAXLEN];
   char csort[MAXLEN], tbuf[128], email[MAXLEN], zip[20];
   char *str;
   char version[100];
   char outdir[MAXLEN];
   char cdfrom[30], cduntil[30];
   int  common, common_log=0, squid_log=0, userip=0, abuse=0, indexonly=0;
   char bufz[8192];

   int zz=0, ch, x, errflg=0, l, debug=0, debugz=0, debugm=0;
   int iprel=0, puser=0, fhost=0, dns=0, fuser=0;
   long totregsl=0, totregsg=0, totregsx=0, totper=0;
   int  dfrom=0, duntil=0, idata=0;
   int z1, z2;

   BgImage[0]='\0';
   LogoImage[0]='\0';
   LogoText[0]='\0';
   FontFace[0]='\0';
   PasswdFile[0]='\0';
   OutputEmail[0]='\0';
   Ip2Name[0]='\0';
   UserAgentLog[0]='\0';
   ExcludeHosts[0]='\0';
   ExcludeUsers[0]='\0';
   ConfigFile[0]='\0';
   code[0]='\0';

   strcpy(AccessLog,"/usr/local/squid/logs/access.log");
   strcpy(Title,(char *)htm01);
   strcpy(BgColor,"white");
   strcpy(TxColor,"black");
   strcpy(TxBgColor,"beige");
   strcpy(TiColor,"green");
   strcpy(Width,"80");
   strcpy(Height,"45");
   strcpy(LogoTextColor,"black");
   strcpy(HeaderColor,"brown");
   strcpy(HeaderBgColor,"blanchedalmond");
   strcpy(FontSize,"-1");
   strcpy(TempDir,"/tmp");
   strcpy(OutputDir,"/usr/local/etc/httpd/htdocs/squid-reports");
   strcpy(Ip2Name,"no");
   strcpy(SortField1,"BYTES");
   strcpy(SortField2,"BYTES");
   strcpy(SortOrder1,"reverse");
   strcpy(SortOrder2,"reverse");
   strcpy(DateFormat,"u");

   dia[0]='\0';
   mes[0]='\0';
   ano[0]='\0';
   hora[0]='\0';
   tmp[0]='\0';
   tmp2[0]='\0';
   tmp3[0]='\0';
   wtemp[0]='\0';
   wtemp2[0]='\0';
   us[0]='\0';
   date[0]='\0';
   df[0]='\0';
   arq[0]='\0';
   uagent[0]='\0';
   hexclude[0]='\0';
   addr[0]='\0';
   hm[0]='\0';
   site[0]='\0';
   version[0]='\0';
   outdir[0]='\0';
   elap[0]='\0';
   email[0]='\0';
   zip[0]='\0';

   while((ch = getopt(argc, argv, "a:b:c:d:e:f:g:u:l:o:r:s:t:v:w:hijmnpxz")) != -1){
      switch(ch)
      {
         case 'a':
            strcpy(addr,optarg);
            break;
         case 'b':
            strcpy(uagent,optarg);
            break;
         case 'c':
            strcpy(hexclude,optarg);
            break;
         case 'd':
            strcpy(date,optarg);
            strcpy(cduntil,optarg);
            getword(cdfrom,cduntil,'-');
            date_from(date, cdfrom, cduntil);
            dfrom=atoi(cdfrom);
            duntil=atoi(cduntil);
            break;
         case 'e':
            strcpy(email,optarg);
            break;
         case 'f':
            strcpy(ConfigFile,optarg);
            break;
         case 'g':
            strcpy(df,optarg);
            break;
   	 case 'h':
  	    usage(argv[0]);
            exit(0);
 	    break;
         case 'i':
            iprel++;
            break;
         case 'j':
            abuse++;
            break;
         case 'l':
            strcpy(arq,optarg);
            break;
         case 'm':
            debugm++;
            break;
         case 'n':
            dns++;
            break;
         case 'o':
            strcpy(outdir,optarg);
            break;
         case 'p':
            userip++;
            break;
         case 's':
            strcpy(site,optarg);
            break;
         case 't':
            strcpy(hm,optarg);
            break;
         case 'u':
            strcpy(us,optarg);
            break;
         case 'v':
            strcpy(version,optarg);
            break;
         case 'w':
            strcpy(tmp,optarg);
            break;
         case 'x':
            debug++;
            break;
         case 'z':
            debugz++;
            break;
         case ':':
	    fprintf(stderr, "%s -%c %s\n",msg01,optopt,msg02);
	    errflg++;
	    break;
         case '?':
            usage(argv[0]);
            exit(1);
            break;
      }

   }

   if (errflg) {
      usage(argv[0]);
      exit(2);
   }
   
   if(strcmp(hexclude,"onvert") == 0 && strcmp(site,"plit") != 0) {
      convlog(arq, df, dfrom, duntil);
      exit(0);
   }
   
   if(strcmp(site,"plit") == 0) {
      splitlog(arq, df, dfrom, duntil, hexclude);
      exit(0);
   }

   if(debug)
      debuga(msg03);

   if(ConfigFile[0] == '\0')
      sprintf(ConfigFile,"%s/sqmgrlog.conf",PREFIX);
    else {
      if(access(ConfigFile, R_OK) != 0) {
         sprintf(msg,"%s %s: %s",msg42,msg67,ConfigFile);
         debuga(msg);
         exit(1);
      }
   }
    
   if(access(ConfigFile, R_OK) == 0)
      getconf(debugm, ConfigFile, AccessLog, debug, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, PasswdFile, TempDir, OutputDir, OutputEmail, Ip2Name, SortField1, SortField2, SortOrder1, SortOrder2, UserAgentLog, ExcludeHosts, Abuse, DateFormat, ExcludeUsers, PerUserLimitFile, PerUserLimit);

   if(access(PasswdFile, R_OK) == 0) {
      getusers(PasswdFile,debug);
      puser++;
   }

   if(hexclude[0] == '\0')
      strcpy(hexclude,ExcludeHosts);
   if(access(hexclude, R_OK) == 0) {
      gethexclude(hexclude,debug);
      fhost++;
   }

   if(access(ExcludeUsers, R_OK) == 0) {
      getuexclude(ExcludeUsers,debug);
      fuser++;
   }

   indexonly=0;
   if(fuser) {
      if(strstr(excludeuser,"indexonly") != 0)
         indexonly++;
   }
   if(strcmp(ExcludeUsers,"indexonly") == 0)
      indexonly++;

   if(dns)
      strcpy(Ip2Name,"yes");

   if(strlen(outdir)<1)
      strcpy(outdir,OutputDir);
   strcat(outdir,"/");

   if(arq[0] == '\0')
      strcpy(arq,AccessLog);

   if(uagent[0] == '\0')
      strcpy(uagent,UserAgentLog);

   if(tmp[0] == '\0')
     strcpy(tmp,TempDir);
    else
     strcpy(TempDir,tmp);

   if(df[0] == '\0')
      strcpy(df,DateFormat);
    else
      strcpy(DateFormat,df);

   if(df[0] == '\0') {
      strcpy(df,"u");
      strcpy(DateFormat,"u");
   }

   if(strlen(email)<1){
      if(strlen(OutputEmail)>0)
         strcpy(email,OutputEmail);
   }

   strcpy(tmp2,tmp);

   if(strlen(email) > 0 && abuse<1) {
      sprintf(wtemp2,"mkdir -p %s/sqmgrlog_tmp",tmp2);
      system(wtemp2);
      strcat(tmp2,"/sqmgrlog_tmp");
      strcpy(outdir,tmp2);
      strcat(outdir,"/");
    }

   strcat(tmp2,"/sqmgrlog.log");

   strcpy(tmp3,tmp2);
   strcat(tmp3,".unsort");

   if(strlen(version) == 0)
      squidver(version);

   if(debug) {
      fprintf(stderr, "SQMGRLOG: %s:\nSQMGRLOG:\n",msg19);
      fprintf(stderr, "SQMGRLOG: %35s (-a) = %s\n",msg20,addr);
      fprintf(stderr, "SQMGRLOG: %35s (-b) = %s\n",msg68,uagent);
      fprintf(stderr, "SQMGRLOG: %35s (-c) = %s\n",msg66,hexclude);
      fprintf(stderr, "SQMGRLOG: %35s (-d) = %s\n",msg21,date);
      fprintf(stderr, "SQMGRLOG: %35s (-e) = %s\n",msg38,email);
      fprintf(stderr, "SQMGRLOG: %35s (-f) = %s\n",msg67,ConfigFile);
      if(strcmp(df,"e") == 0)
         fprintf(stderr, "SQMGRLOG: %35s (-g) = %s (dd/mm/yyyy)\n",msg22,msg23);
      if(strcmp(df,"u") == 0)
         fprintf(stderr, "SQMGRLOG: %35s (-g) = %s (mm/dd/yyyy)\n",msg22,msg24);
      if(iprel)
         fprintf(stderr, "SQMGRLOG: %35s (-i) = %s\n",msg25,yes);
       else
         fprintf(stderr, "SQMGRLOG: %35s (-i) = %s\n",msg25,no);
      if(abuse)
         fprintf(stderr, "SQMGRLOG: %35s (-j) = %s\n",msg69,yes);
       else
         fprintf(stderr, "SQMGRLOG: %35s (-j) = %s\n",msg69,no);
      fprintf(stderr, "SQMGRLOG: %35s (-l) = %s\n",msg34,arq);
      if(strcmp(Ip2Name,"yes") == 0)
         fprintf(stderr, "SQMGRLOG: %35s (-n) = %s\n",msg62,yes);
       else
         fprintf(stderr, "SQMGRLOG: %35s (-n) = %s\n",msg62,no);
      fprintf(stderr, "SQMGRLOG: %35s (-o) = %s\n",msg35,outdir);
      if(userip)
         fprintf(stderr, "SQMGRLOG: %35s (-p) = %s\n",msg26,yes);
       else
         fprintf(stderr, "SQMGRLOG: %35s (-p) = %s\n",msg26,no);
      fprintf(stderr, "SQMGRLOG: %35s (-s) = %s\n",msg27,site);
      fprintf(stderr, "SQMGRLOG: %35s (-t) = %s\n",msg28,hm);
      fprintf(stderr, "SQMGRLOG: %35s (-u) = %s\n",msg29,us);
      fprintf(stderr, "SQMGRLOG: %35s (-v) = %s\n",msg30,version);
      fprintf(stderr, "SQMGRLOG: %35s (-w) = %s\n",msg31,tmp);
      if(debug)
         fprintf(stderr, "SQMGRLOG: %35s (-x) = %s\n",msg32,yes);
       else
         fprintf(stderr, "SQMGRLOG: %35s (-x) = %s\n",msg32,no);
      if(debugz)
         fprintf(stderr, "SQMGRLOG: %35s (-z) = %s\n",msg33,yes);
       else
         fprintf(stderr, "SQMGRLOG: %35s (-z) = %s\n",msg33,no);
      fprintf(stderr, "SQMGRLOG:\n");
   }

   if(debugm) {
      printf("%s:\nSQMGRLOG:\n",msg19);
      printf("%35s (-a) = %s\n",msg20,addr);
      printf("%35s (-b) = %s\n",msg68,uagent);
      printf("%35s (-c) = %s\n",msg66,hexclude);
      printf("%35s (-d) = %s\n",msg21,date);
      printf("%35s (-e) = %s\n",msg38,email);
      printf("%35s (-f) = %s\n",msg67,ConfigFile);
      if(strcmp(df,"e") == 0)
         printf("%35s (-g) = %s (dd/mm/yyyy)\n",msg22,msg23);
      if(strcmp(df,"u") == 0)
         printf("%35s (-g) = %s (mm/dd/yyyy)\n",msg22,msg24);
      if(iprel)
         printf("%35s (-i) = %s\n",msg25,yes);
       else
         printf("%35s (-i) = %s\n",msg25,no);
      if(abuse)
         printf("%35s (-j) = %s\n",msg69,yes);
       else
         printf("%35s (-j) = %s\n",msg69,no);
      printf("%35s (-l) = %s\n",msg34,arq);
      if(strcmp(Ip2Name,"yes") == 0)
         printf("%35s (-n) = %s\n",msg62,yes);
       else
         printf("%35s (-n) = %s\n",msg62,no);
      printf("%35s (-o) = %s\n",msg35,outdir);
      if(userip)
         printf("%35s (-p) = %s\n",msg26,yes);
       else
         printf("%35s (-p) = %s\n",msg26,no);
      printf("%35s (-s) = %s\n",msg27,site);
      printf("%35s (-t) = %s\n",msg28,hm);
      printf("%35s (-u) = %s\n",msg29,us);
      printf("%35s (-v) = %s\n",msg30,version);
      printf("%35s (-w) = %s\n",msg31,tmp);
      if(debug)
         printf("%35s (-x) = %s\n",msg32,yes);
       else
         printf("%35s (-x) = %s\n",msg32,no);
      if(debugz)
         printf("%35s (-z) = %s\n",msg33,yes);
       else
         printf("%35s (-z) = %s\n",msg33,no);
      printf("\n%s\n",version);
      printf("sqmgrlog %s: %s\n",msg72,VERSION);
      printf("Language=%s\n\n",language);
   }

   if(debug){
      sprintf(msg,"sqmgrlog %s: %s",msg72,VERSION);
      debuga(msg);
      if(strstr(version,"ersion") == 0){
         sprintf(msg,"Squid version=%s",version);
         debuga(msg);
      } else debuga(version);
   }

   if(strcmp(Abuse,"yes") == 0)
      abuse=1;
   if(abuse) {
      abuserel(tmp2,debug,periodo,debugz,iprel,outdir,addr,site,us,userip,email,wtemp2,BgColor,TxColor, TxBgColor,TiColor,LogoImage,LogoText,LogoTextColor,Width,Height,Title,BgImage,FontFace,HeaderColor,HeaderBgColor,FontSize,TempDir,Ip2Name,SortField1,SortField2,SortOrder1,SortOrder2,uagent,abuse);
      exit(0);
   }

   if((fp_ou=fopen(tmp3,"w"))==NULL) {
     fprintf(stderr, "%s: (log) %s: %s\n",argv[0],msg06,tmp3);
     exit(1);
   }

   decomp(arq,zip);
   if(debug) {
      sprintf(msg, "%s: %s",msg04,arq);
      debuga(msg);
   }

   if((fp_in=fopen(arq,"r"))==NULL) {
     fprintf(stderr, "%s: (log) %s: %s\n",argv[0],msg05,arq);
     exit(1);
   }

  while(fgets(bufz,sizeof(bufz),fp_in)!=NULL) {
        if(!bufz[0]) continue;
        
        if ((str = strchr(bufz, '\n')) != NULL)
           *str = '\0';          /* strip \n */       

        totregsl++;
        
        common=0;
        if(debugm)
       	   printf("BUF=%s\n",bufz);

	getword(data,bufz,' ');
        if ( (str = (char *) strstr(data, ".")) != (char *) NULL ) {
           if ( (str = (char *) strstr(str+1, ".")) != (char *) NULL ) {
	      strcpy(ip,data);
	      strcpy(elap,"0");
	      getword(user,bufz,' ');
	      getword(none,bufz,' ');
	      getword(data,bufz,']');
	      getword(fun,bufz,'"');
	      getword(fun,bufz,' ');
	      getword(url,bufz,' ');

	      if(strstr(version," 1.1") != 0){
   	         getword(code,bufz,' ');
	         strcpy(tam,bufz);
	         tam[strlen(tam)-1]='\0';
	      } else{
	         getword(code2,bufz,' ');
	         getword(tam,bufz,' ');
	         strcpy(code,bufz);
	      }
	      code[strlen(code)-1]='\0';
              if(code[0] == '\0') {
                 strcpy(code,code2);
                 if ((str = strchr(code, ':')) != NULL)
                 *str = '/'; 
              }

	      if(strcmp(tam,"\0") == 0)
	         strcpy(tam,"0");

	      common++;
	      common_log=1;
	   }
	}
	if(!common) {
	      getword(elap,bufz,' ');
	      while(strcmp(elap,"") == 0)
	         getword(elap,bufz,' ');
	      getword(ip,bufz,' ');
	      getword(code,bufz,' ');
	      getword(tam,bufz,' ');
	      getword(fun,bufz,' ');
	      getword(url,bufz,' ');
	      getword(user,bufz,' ');
	      squid_log=1;
	}

        if(strstr(user,"%5c") != 0) {
           getword(w,user,'%');
           strcpy(wuser,user+2);
           sprintf(user,"%s.%s",w,wuser);
        }

        z1=0;
        z2=0;
        str=user;
        for(z1==0; z1<=strlen(str); z1++) {
           if(isalnum(str[z1])) {
              user[z2]=str[z1];
              z2++;
           }
        } 
           
	getword(w,url,'/');
	getword(w,url,'/');
	getword(w,url,'/');
        strcpy(url,w);

        if(!common) {
           tt=atoi(data);
           t=localtime(&tt);

           if(strcmp(df,"u") == 0)
	      strftime(tbuf, 127, "%Y%b%d", t);
           if(strcmp(df,"e") == 0)
	      strftime(tbuf, 127, "%d%b%Y", t);

           strftime(dia, 127, "%d/%m/%Y", t);
           strftime(wdata, 127, "%Y%m%d", t);
          
           idata=atoi(wdata);

           if(strncmp(df,"u",1)==0)
              strftime(dia, 127, "%m/%d/%Y", t);
           sprintf(hora,"%02d:%02d:%02d",t->tm_hour,t->tm_min,t->tm_sec);
	 } else {
	   strcpy(wtemp,data+1);
	   getword(data,wtemp,':');
	   getword(hora,wtemp,' ');
	   getword(dia,data,'/');
	   getword(mes,data,'/');
	   getword(ano,data,'/');
	   sprintf(tbuf,"%s%s%s",ano,mes,dia);
	   builddia(dia,mes,ano,df);
	}

        if(debugm)
           printf("DATE=%s IDATA=%d DFROM=%d DUNTIL=%d\n",date,idata,dfrom,duntil);

        l=1;
        if(strlen(us)>0){
  	   if(strcmp(user,us)==0)
	      l=1;else l=0;
 	}
           
        if(l){
           if(strlen(addr)>0){
  	      if(strcmp(addr,ip)==0)
	         l=1;else l=0;
 	   }
           if(fhost) {
              l=vhexclude(excludefile,ip);
              l=vhexclude(excludefile,url);
              if(!l)
	         totregsx++;
           }
        }

        if(l){
           if(strlen(date) > 0){
              if(idata >= dfrom && idata <= duntil)
	         l=1;else l=0;
 	   }
        }
        if(l){
           if(strlen(hm)>0){
  	      if(strncmp(hm,hora,strlen(hm))==0)
	         l=1;else l=0;
 	   }
        }
        if(l){
           if(strlen(site)>0){
  	      if(strstr(url,site)!=0)
	         l=1;else l=0;
 	   }
        }

        if(userip)
           strcpy(user,ip);

        if(strcmp(user,"-") == 0)
           strcpy(user,"nouser");
//	   strcpy(user,ip);
        if(strcmp(user," ") == 0)
	   strcpy(user,"nouser");
//	   strcpy(user,ip);
        if(strcmp(user,"") == 0)
	   strcpy(user,"nouser");
//	   strcpy(user,ip);

        if(puser) {
           sprintf(wuser,"%s:",user);
           if(strstr(userfile, wuser) == 0)
              continue;
        }
        
        if(l) {
           if(fuser) {
              l=vuexclude(excludeuser,user);
              if(!l)
	         totregsx++;
           }
        }

        if(l) {
           if(userip)
              fixip(user);
        }

        if(l) {
	   if(strcmp(user,"-") !=0 && strlen(url) > 0 && strcmp(user," ") !=0 && strcmp(user,"") !=0 && strcmp(user,":") !=0){
              sprintf(bufz, "%s %s %s %s %s %s %s %s\n",dia,hora,user,ip,url,tam,code,elap);
    	      fputs(bufz,fp_ou);
	      totregsg++;

              if(!totper){
	         totper++;
                 sprintf(periodo,"%s-",tbuf);
                 if(strlen(date)>0)
                    fixper(df, tbuf, periodo, cduntil);
                 if(debugz){
                    debugaz("tbuf",tbuf);
                    debugaz("periodo",periodo);
                 }
	      }
           }

           if(debugm){
	      printf("IP=%s ELAP=%s USER=%s DIA=%s HORA=%s FUNC=%s URL=%s CODE=%s CODE2=%s LEN=%s (%d) COMMON=%d NATIVE=%d\n",ip,user,dia,hora,fun,url,code,code2,tam,strlen(tam),common_log,squid_log);
	   }
	}
  }

   if(debug) {
      sprintf(msg, "   %s: %d, %s: %d, %s: %d",msg07,totregsl,msg08,totregsg,msg65,totregsx);
      debuga(msg);
  
      if((common_log) && (squid_log))
         debuga(msg09);
  
      if((common_log) && (!squid_log)) 
         debuga(msg10);
 
      if((!common_log) && (squid_log))
         debuga(msg11);
 
      if((!common_log) && (!squid_log)) {
         fprintf(stderr, "SQMGRLOG: %s\n",msg12);
         sprintf(msg, "");
         fclose(fp_in);
         fclose(fp_ou);
         unlink(tmp3);
         exit(0);
      }
   }
 
   if(!totregsg){
      fprintf(stderr, "SQMGRLOG: %s\n",msg13);
      fprintf(stderr, "SQMGRLOG: %s\n",msg18);
      fclose(fp_in);
      fclose(fp_ou);
      exit(0);
   }

   if(date[0] == '\0')
      strcat(periodo,tbuf);

   if(debugz){
      debugaz("data",dia);
      debugaz("tbuf",tbuf);
      debugaz("periodo",periodo);
   }

   if(debug){
     sprintf(msg, "%s: %s",msg14,periodo);
     debuga(msg);
   }

   fclose(fp_in);
   fclose(fp_ou);

   if(debug){
     sprintf(msg,"Sort: %s %s %s",msg15,tmp,msg16);
     debuga(msg);
     sprintf(msg, "%s: %s",msg17,tmp2);
     debuga(msg);
   }

   sprintf(csort,"sort -T %s -k 3,3 -k 5,5 -o %s %s", tmp, tmp2, tmp3);

   system(csort);
   unlink(tmp3);

   gerarel(tmp2,debug,periodo,debugz,iprel,outdir,addr,site,us,userip,email,wtemp2,BgColor,TxColor, TxBgColor,TiColor,LogoImage,LogoText,LogoTextColor,Width,Height,Title,BgImage,FontFace,HeaderColor,HeaderBgColor,FontSize,TempDir,Ip2Name,SortField1,SortField2,SortOrder1,SortOrder2,uagent,abuse,DateFormat,indexonly,PerUserLimitFile,PerUserLimit);

   unlink(tmp2);
 
   if(strlen(zip) > 0)
      recomp(arq, zip);

   if(debug)
      debuga(msg18);

   exit(0);

}


void getusers(char *pwdfile, int debug)
{

   FILE *fp_usr;
   char buf[255];
   char Msg[255];
   char user[255];
   unsigned long int nreg=0;
   int zz=0;

   if(debug) {
      sprintf(Msg,"%s: %s",msg57,pwdfile);
      debuga(Msg);
   }

   if ((fp_usr = fopen(pwdfile, "r")) == NULL) {
      fprintf(stderr, "SQMGRLOG: (getusers) %s: %s\n",msg42,pwdfile);
      exit(1);
   }

   nreg = lseek(fileno(fp_usr), 0, SEEK_END);
   nreg = nreg+5000; 
   lseek(fileno(fp_usr), 0, 0);

   if((userfile=(char *) malloc(nreg))==NULL){
      fprintf(stderr, "SQMGRLOG: %s (%d): %s\n",msg56,nreg);
      exit(1);
   }

   for(zz==0;zz<=strlen(userfile);zz++)
      userfile[zz]='\0';

   while(fgets(buf,300,fp_usr)!=NULL){
     getword(user,buf,':');
     strcat(userfile,user);
     strcat(userfile,":");
   }

   fclose(fp_usr);

   return;
}


void gethexclude(char *hexfile, int debug)
{

   FILE *fp_ex;
   char buf[255];
   char Msg[255];
   char host[255];
   unsigned long int nreg=0;
   int zz=0;

   if(debug) {
      sprintf(Msg,"%s: %s",msg64,hexfile);
      debuga(Msg);
   }

   if ((fp_ex = fopen(hexfile, "r")) == NULL) {
      fprintf(stderr, "SQMGRLOG: (gethexclude) %s: %s\n",msg42,hexfile);
      exit(1);
   }

   nreg = lseek(fileno(fp_ex), 0, SEEK_END);
   lseek(fileno(fp_ex), 0, 0);

   if((excludefile=(char *) malloc(nreg+11))==NULL){
      fprintf(stderr, "SQMGRLOG: %s (%d): %s\n",msg56,nreg);
      exit(1);
   }

   for(zz==0;zz<=strlen(excludefile);zz++)
      excludefile[zz]='\0';

   while(fgets(buf,300,fp_ex)!=NULL){
     if(strstr(buf,"#") != 0)
        continue;
     buf[strlen(buf)-1]='\0';
     strcat(excludefile,buf);
     strcat(excludefile," ");
   }

   strcat(excludefile,"*FIM* ");
printf("--->EXCLUDEFILE=%s\n",excludefile);

   fclose(fp_ex);

   return;
}


void getuexclude(char *uexfile, int debug)
{

   FILE *fp_ex;
   char buf[255];
   char Msg[255];
   char host[255];
   int  x=0;
   unsigned long int nreg=0;

   if(debug) {
      sprintf(Msg,"%s: %s",msg64,uexfile);
      debuga(Msg);
   }

   if ((fp_ex = fopen(uexfile, "r")) == NULL) {
      fprintf(stderr, "SQMGRLOG: (gethexclude) %s: %s\n",msg42,uexfile);
      exit(1);
   }

   nreg = lseek(fileno(fp_ex), 0, SEEK_END);
   lseek(fileno(fp_ex), 0, 0);

   if((excludeuser=(char *) malloc(nreg+11))==NULL){
      fprintf(stderr, "SQMGRLOG: %s (%d): %s\n",msg56,nreg);
      exit(1);
   }

   for(x==0;x<=strlen(excludeuser);x++)
      excludeuser[x]='\0';

   while(fgets(buf,300,fp_ex)!=NULL){
     if(strstr(buf,"#") != 0)
        continue;
     buf[strlen(buf)-1]='\0';
     strcat(excludeuser,buf);
     strcat(excludeuser," ");
   }

   strcat(excludeuser,"*FIM* ");

   fclose(fp_ex);

   return;
}
