/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

void geraindex(char *dirname, int *debug, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *DateFormat)
{

   FILE *fp_ou;
   DIR *dirp;
   struct dirent *direntp;
   char html[MAXLEN];
   char wdir[MAXLEN];
   char data[80];
   char tuser[20];
   char tbytes[20];
   char media[20];
   char ftime[128];

   sprintf(wdir,"%sindex.html",dirname);

   if(debug)
      debuga(msg50);

   if((fp_ou=fopen(wdir,"w"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (index) %s: %s\n",msg42,wdir);
      exit(1);
   }

   fputs("<html>\n",fp_ou);

   if(strlen(FontFace) > 0) {
      sprintf(html,"<font face=%s>\n",FontFace);
      fputs(html,fp_ou);
   }

   sprintf(html,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   fputs(html,fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   if(strlen(LogoImage) > 0) {
      sprintf(html,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(html,fp_ou);
   }

   sprintf(html,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(html,fp_ou);

   fputs("</table></center>\n",fp_ou);
   fputs("<center><table cellpadding=1 cellspacing=1>\n",fp_ou);
   fputs("<tr><td></td><td></td></tr>",fp_ou);


   sprintf(html,"<tr><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm14,HeaderBgColor,FontSize,HeaderColor,htm15,HeaderBgColor,FontSize,HeaderColor,htm16,HeaderBgColor,FontSize,HeaderColor,htm06,HeaderBgColor,FontSize,HeaderColor,htm09);
   fputs(html,fp_ou);

   dirp = opendir(dirname);

   while ( (direntp = readdir( dirp )) != NULL ){
      if(strstr(direntp->d_name,".html") != 0)
         continue;
      if(strcmp(direntp->d_name,".") == 0 || strcmp(direntp->d_name,"..") == 0 || strcmp(direntp->d_name, ".htaccess") == 0)
         continue;

      obtdate(dirname,direntp->d_name,data);
      obtuser(dirname,direntp->d_name,tuser);
      obttotal(dirname,direntp->d_name,tbytes,tuser,media);

      sprintf(html,"<tr><td bgcolor=%s><font size=%s><a href='%s/index.html'>%s</font></a></td><td bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,direntp->d_name,direntp->d_name,TxBgColor,FontSize,data,TxBgColor,FontSize,tuser,TxBgColor,FontSize,tbytes,TxBgColor,FontSize,media);
      fputs(html,fp_ou);
   }

   (void)closedir( dirp );

   strcpy(html,"</table></center>");
   fputs(html,fp_ou);

   zdate(ftime, DateFormat);

   sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",htm21,URL,PGM,VERSION,htm22,ftime);
   fputs(html,fp_ou);

   strcpy(html,"</html\n>");
   fputs(html,fp_ou);

   return;
}
