/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

void htmlrel(const char *dirname, int *debug, int *iprel, int *ipuser, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *SortField2, char *SortOrder2, char *DateFormat, int *indexonly, char *PerUserLimitFile, char *PerUserLimit)

{
   DIR *dirp;
   FILE *fp_in, *fp_ou, *fp_ip, *fp_ip2, *fp_usr;

   struct dirent *direntp;
   LONGLONGINT nnbytes=0, unbytes=0, tnbytes=0, totbytes=0, totbytes2=0;
   LONGLONGINT totelap=0, totelap2=0, nnelap=0, unelap=0, tnelap=0;
   LONGLONGINT incache=0, oucache=0, tnincache=0, tnoucache=0;
   char arqin[MAXLEN], arqou[MAXLEN], arqper[MAXLEN], arqip[MAXLEN];
   char nacc[15], nbytes[15], url[1024], purl[1024], tmsg[11], nelap[15], csort[MAXLEN];
   char periodo[MAXLEN],  html[MAXLEN], usuario[MAXLEN], wusuario[MAXLEN], u2[MAXLEN];
   char userbytes[15], userelap[15], userurl[1024], userip[MAXLEN], userhora[9], userdia[9];
   char olduserip[MAXLEN], tmp2[MAXLEN], tmp3[MAXLEN], incac[15], oucac[15];
   char *str;
   char ftime[128], warea[MAXLEN];
   char wtemp[MAXLEN], totuser[8];
   unsigned long tnacc=0, ttnacc=0, unacc=0;
   float perc=0, perc2=0, ouperc=0, inperc=0;

   if(indexonly)
      return;

   strcpy(tmp2,TempDir);
   strcat(tmp2,"/sqmgrtmp.unsort");

   strcpy(tmp3,TempDir);
   strcat(tmp3,"/sqmgrtmp.log");

/*
 * Obtem o periodo
 */

   strcpy(arqper,dirname);
   strcat(arqper,"/periodo");

   if ((fp_in = fopen(arqper, "r")) == 0){
      fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,arqper);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

/*
 * Obtem total geral de bytes trafegados
 */
   strcpy(arqper,dirname);
   strcat(arqper,"/geral");

   if ((fp_in = fopen(arqper, "r")) == 0){
      fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,arqper);
      exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if(strstr(buf,"TOTAL") == 0) {
         getword(wtemp,buf,' ');
         ttnacc=ttnacc+atol(buf);
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         totbytes=totbytes+atol(wtemp);
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         totelap=totelap+atol(wtemp);
      }
   }

   fclose(fp_in);

   dirp = opendir(dirname);

   while ( (direntp = readdir( dirp )) != NULL ) {
      if(strstr(direntp->d_name,".txt") ==0)
         continue;

      strcpy(usuario,direntp->d_name);
      wusuario[0]='\0';

      striptxt:
      getword(warea,usuario,'.');
      strcat(wusuario,warea);

      if(strcmp(usuario,"txt") !=0) {
         strcat(wusuario,".");
         goto striptxt;
      }

      report_day(dirname, wusuario, iprel, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, SortField2, SortOrder2, DateFormat, periodo);  

      strcpy(usuario,wusuario);
      strcpy(arqin,dirname);
      strcat(arqin,"/");
      strcpy(arqou,arqin);
      strcat(arqou,usuario);
      strcat(arqou,".html");
      strcat(arqin,direntp->d_name);

      if ((fp_in = fopen(arqin, "r")) == 0){
         fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,arqin);
         exit(1);
      }

      while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
         getword(wtemp,buf,' ');
         tnacc+=atol(wtemp);
         getword(wtemp,buf,' ');
         tnbytes+=atol(wtemp);
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         tnelap+=atol(wtemp);
         getword(wtemp,buf,' ');
         tnincache+=atol(wtemp);
         getword(wtemp,buf,' ');
         tnoucache+=atol(wtemp);
      }

      fclose(fp_in);

      if ((fp_in = fopen(arqin, "r")) == 0){
         fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,arqin);
         exit(1);
      }

      if ((fp_ou = fopen(arqou, "w")) == 0){
         fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,arqou);
         exit(1);
      }

/*
 * Grava HEADER para usuario
 */

      fputs("<html>\n",fp_ou);

      if(strlen(FontFace) > 0) {
         sprintf(html,"<font face=%s>\n",FontFace);
         fputs(html,fp_ou);
      }

      sprintf(html,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
      fputs(html,fp_ou);

      fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

      if(strlen(LogoImage) > 0) {
         sprintf(html,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s
   >%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
         fputs(html,fp_ou);
      }

      sprintf(html,"<tr><th align=center colspan=2><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
      fputs(html,fp_ou);
      fputs("<tr><td></td></tr><tr><td></td></tr>",fp_ou);

      strcpy(u2,usuario);
      if(ipuser){
         strcpy(u2,usuario);
         fixip(u2);
      }

      fputs("</table></center>\n",fp_ou);
      fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

      sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font><td align=left bgcolor=%s><font size=%s>%s</font></td></td></tr>\n",HeaderBgColor,FontSize,htm02,TxBgColor,FontSize,periodo);
      fputs(html,fp_ou);
      sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font><td align=left bgcolor=%s><font size=%s>%s</font></td></td></tr>\n",HeaderBgColor,FontSize,htm03,TxBgColor,FontSize,u2);
      fputs(html,fp_ou);
      sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font><td align=left bgcolor=%s><font size=%s>%s, %s</font></td></td></tr>\n",HeaderBgColor,FontSize,htm17,TxBgColor,FontSize,SortField2,SortOrder2);
      fputs(html,fp_ou);

      fputs("</table></center>\n",fp_ou);
      fputs("<center><table cellpadding=1 cellspacing=1>\n",fp_ou);
      fputs("<tr><td></td><td></td></tr>",fp_ou);

      sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%%%s</font></th><th bgcolor=%s colspan=2><font size=%s color=%s>%s-%s-%s</font></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%%%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm04,HeaderBgColor,FontSize,HeaderColor,htm05,HeaderBgColor,FontSize,HeaderColor,htm06,HeaderBgColor,FontSize,HeaderColor,htm06,HeaderBgColor,FontSize,HeaderColor,htm27,htm28,htm26,HeaderBgColor,FontSize,HeaderColor,htm07,HeaderBgColor,FontSize,HeaderColor,htm08,HeaderBgColor,FontSize,HeaderColor,htm12);
      fputs(html,fp_ou);

      if(debug){
         if(ipuser){
            strcpy(u2,usuario);
            fixip(u2);
            sprintf(msg, "%s: %s",msg58,u2);
         } else
            sprintf(msg, "%s: %s",msg58,usuario);
         debuga(msg);
      }

      fscanf(fp_in,"%s",nacc);
      fscanf(fp_in,"%s",nbytes);
      fscanf(fp_in,"%s",url);
      fscanf(fp_in,"%s",tmsg);
      fscanf(fp_in,"%s",nelap);
      fscanf(fp_in,"%s",incac);
      fscanf(fp_in,"%s",oucac);

      while(!feof(fp_in)) {
         strcpy(purl,url);
         if(strcmp(tmsg,"DENIED") == 0) {
            strcpy(purl,"<font COLOR=red>");
            strcat(purl,url);
	    strcat(purl,"</font>");
         }else {
            strcpy(purl,url);
            strncpy(tmsg,"           ",11);
         }

         nnbytes=atol(nbytes);
         nnelap=atol(nelap);
         incache=atol(incac);
         oucache=atol(oucac);

         if(nnbytes) {
            perc=nnbytes * 100;
            perc=perc / tnbytes;
	 } else {
            perc=0;
            ouperc=0;
         }

         if(nnelap) {
            perc2=nnelap * 100;
            perc2=perc2 / tnelap;
         } else perc2=0;

         if(incache) {
            inperc=incache * 100;
            inperc=inperc / nnbytes;
         } else inperc=0;

         if(oucache) {
            ouperc=oucache * 100;
            ouperc=ouperc / nnbytes;
         } else ouperc=0;


#if defined(__FreeBSD__)
         sprintf(html,"<tr><td align=left bgcolor=%s><font size=%s><a href=http://%s>%s</A></font></td><td align=right bgcolor=%s><font size=%s>%d</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%qu</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,url,purl,TxBgColor,FontSize,atoi(nacc),TxBgColor,FontSize,fixnum(nnbytes),TxBgColor,FontSize,perc,TxBgColor,FontSize,inperc,TxBgColor,FontSize,ouperc,TxBgColor,FontSize,buildtime(nnelap),TxBgColor,FontSize,nnelap,TxBgColor,FontSize,perc2,TxBgColor,FontSize,tmsg);
#elif defined(__alpha) || __ALPHA
         sprintf(html,"<tr><td align=left bgcolor=%s><font size=%s><a href=http://%s>%s</A></font></td><td align=right bgcolor=%s><font size=%s>%d</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%ld</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,url,purl,TxBgColor,FontSize,atoi(nacc),TxBgColor,FontSize,fixnum(nnbytes),TxBgColor,FontSize,perc,TxBgColor,FontSize,inperc,TxBgColor,FontSize,ouperc,TxBgColor,FontSize,buildtime(nnelap),TxBgColor,FontSize,nnelap,TxBgColor,FontSize,perc2,TxBgColor,FontSize,tmsg);
#else
         sprintf(html,"<tr><td align=left bgcolor=%s><font size=%s><a href=http://%s>%s</A></font></td><td align=right bgcolor=%s><font size=%s>%d</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%lld</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,url,purl,TxBgColor,FontSize,atoi(nacc),TxBgColor,FontSize,fixnum(nnbytes),TxBgColor,FontSize,perc,TxBgColor,FontSize,inperc,TxBgColor,FontSize,ouperc,TxBgColor,FontSize,buildtime(nnelap),TxBgColor,FontSize,nnelap,TxBgColor,FontSize,perc2,TxBgColor,FontSize,tmsg);
#endif
         fputs(html,fp_ou);

          if(iprel) {
             strcpy(arqip,dirname);
             strcat(arqip,"/");
             strcat(arqip,usuario);
             strcat(arqip,".ip");

             if ((fp_ip = fopen(arqip, "r")) == 0){
                fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,arqip);
                exit(1);
	     }

             if ((fp_ip2 = fopen(tmp2, "a")) == 0){
                fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,tmp2);
                exit(1);
	     }

             while(fgets(buf,sizeof(buf),fp_ip)!=NULL)
             {
                if(strstr(buf,url) != 0)
                   fputs(buf,fp_ip2);
             }

             fclose(fp_ip);
             fclose(fp_ip2);

             sprintf(csort,"sort -T %s -k 1,1 -k 5,5 -o %s %s",TempDir,tmp3,tmp2);

             system(csort);

             if ((fp_ip = fopen(tmp3, "r")) == 0){
                fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,tmp3);
                exit(1);
	     }

             fscanf(fp_ip,"%s",userip);
             fscanf(fp_ip,"%s",userurl);
             fscanf(fp_ip,"%s",userdia);
             fscanf(fp_ip,"%s",userhora);
             fscanf(fp_ip,"%s",userbytes);
             fscanf(fp_ip,"%s",userelap);

             strcpy(olduserip,userip);

             while(!feof(fp_ip))
             {

	        if(strcmp(userip,olduserip) != 0)
                {

#if defined(__FreeBSD__)
                   sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%qu</font></td></tr>\n",olduserip,fixnum(unbytes),buildtime(unelap),unelap);
#elif defined(__alpha) || __ALPHA
                   sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%ld</font></td></tr>\n",olduserip,fixnum(unbytes),buildtime(unelap),unelap);
#else
                   sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%lld</font></td></tr>\n",olduserip,fixnum(unbytes),buildtime(unelap),unelap);
#endif
                   fputs(html,fp_ou);

                   strcpy(olduserip,userip);
                   unacc=0;
                   unbytes=0;
                   unelap=0;
                }

                unbytes=unbytes+atol(userbytes);
                unelap=unelap+atol(userelap);

                fscanf(fp_ip,"%s",userip);
                fscanf(fp_ip,"%s",userurl);
                fscanf(fp_ip,"%s",userdia);
                fscanf(fp_ip,"%s",userhora);
                fscanf(fp_ip,"%s",userbytes);
                fscanf(fp_ip,"%s",userelap);

             }

	     fclose(fp_ip);

             unlink(tmp2);
             unlink(tmp3);

#if defined(__FreeBSD__)
             sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%qu</font></td></tr>\n",olduserip,fixnum(unbytes),buildtime(unelap),unelap);
#elif defined(__alpha) || __ALPHA
             sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%ld</font></td></tr>\n",olduserip,fixnum(unbytes),buildtime(unelap),unelap);
#else
             sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%lld</font></td></tr>\n",olduserip,fixnum(unbytes),buildtime(unelap),unelap);
#endif
             fputs(html,fp_ou);
	  }

          unacc=0;
          unbytes=0;
          unelap=0;

          fscanf(fp_in,"%s",nacc);
          fscanf(fp_in,"%s",nbytes);
          fscanf(fp_in,"%s",url);
          fscanf(fp_in,"%s",tmsg);
          fscanf(fp_in,"%s",nelap);
          fscanf(fp_in,"%s",incac);
          fscanf(fp_in,"%s",oucac);

       }

       if(iprel)
          unlink(arqip);
       unlink(arqin);

       strcpy(html,"<tr><td> </td></tr>");
       fputs(html,fp_ou);
       fputs(html,fp_ou);

       if(tnbytes) {
          perc=totbytes / 100;
          perc=tnbytes / perc;
       } else perc=0;

       if(tnelap) {
          perc2=totelap / 100;
          perc2=tnelap / perc2;
       } else perc2=0;

       if(tnoucache) {
          ouperc=tnoucache * 100;
          ouperc=ouperc / tnbytes;
       } else ouperc=0;

       if(tnincache) {
          inperc=tnincache * 100;
          inperc=inperc / tnbytes;
       } else inperc=0;

#if defined(__FreeBSD__)
       sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%d</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%qu</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm20,HeaderBgColor,FontSize,HeaderColor,tnacc,HeaderBgColor,FontSize,HeaderColor,fixnum(tnbytes),HeaderBgColor,FontSize,HeaderColor,perc,HeaderBgColor,FontSize,HeaderColor,buildtime(tnelap),HeaderBgColor,FontSize,HeaderColor,tnelap,HeaderBgColor,FontSize,HeaderColor,perc2);
#elif defined(__alpha) || __ALPHA
       sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%d</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%ld</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm20,HeaderBgColor,FontSize,HeaderColor,tnacc,HeaderBgColor,FontSize,HeaderColor,fixnum(tnbytes),HeaderBgColor,FontSize,HeaderColor,perc,HeaderBgColor,FontSize,HeaderColor,buildtime(tnelap),HeaderBgColor,FontSize,HeaderColor,tnelap,HeaderBgColor,FontSize,HeaderColor,perc2);
#else
       sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%d</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%lld</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm20,HeaderBgColor,FontSize,HeaderColor,tnacc,HeaderBgColor,FontSize,HeaderColor,fixnum(tnbytes),HeaderBgColor,FontSize,HeaderColor,perc,HeaderBgColor,FontSize,HeaderColor,inperc,HeaderBgColor,FontSize,HeaderColor,ouperc,HeaderBgColor,FontSize,HeaderColor,buildtime(tnelap),HeaderBgColor,FontSize,HeaderColor,tnelap,HeaderBgColor,FontSize,HeaderColor,perc2);
#endif
       fputs(html,fp_ou);
       fclose(fp_in);

      if(atoi(PerUserLimit) > 0) {
         if(tnbytes > (atoi(PerUserLimit)*1000000)) {
            if((fp_usr = fopen(PerUserLimitFile, "a")) == 0) {
               fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,PerUserLimitFile);
               exit(1);
            }
            sprintf(html,"%s\n",u2);
            fputs(html,fp_usr);
            fclose(fp_usr);

            if(debug){
               sprintf(msg, "%s %s %s (%s MB). %s %s",msg29,u2,msg73,PerUserLimit,msg74,PerUserLimitFile);
               debuga(msg);
            }
         }
      }

      strcpy(arqper,dirname);
      strcat(arqper,"/usuarios");

      if ((fp_in = fopen(arqper, "r")) == 0){
         fprintf(stderr, "SQMGRLOG: (html) %s: %s\n",msg42,arqper);
         exit(1);
      }

      fgets(totuser,8,fp_in);
      fclose(fp_in);

      totbytes2=totbytes/atol(totuser);
      totelap2=totelap/atol(totuser);

      if(totbytes2) {
         perc = totbytes / 100;
         perc = totbytes2 / perc;
      } else perc=0;

      if(totelap2) {
         perc2 = totelap / 100;
         perc2 = totelap2 / perc2;
      } else perc2=0;

#if defined(__FreeBSD__)
      sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%d</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%qu</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm09,HeaderBgColor,FontSize,HeaderColor,ttnacc/atol(totuser),HeaderBgColor,FontSize,HeaderColor,fixnum(totbytes2),HeaderBgColor,FontSize,HeaderColor,perc,HeaderBgColor,FontSize,HeaderColor,buildtime(totelap2),HeaderBgColor,FontSize,HeaderColor,totelap2,HeaderBgColor,FontSize,HeaderColor,perc2);
#elif defined(__alpha) || __ALPHA
      sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%d</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%ld</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm09,HeaderBgColor,FontSize,HeaderColor,ttnacc/atol(totuser),HeaderBgColor,FontSize,HeaderColor,fixnum(totbytes2),HeaderBgColor,FontSize,HeaderColor,perc,HeaderBgColor,FontSize,HeaderColor,buildtime(totelap2),HeaderBgColor,FontSize,HeaderColor,totelap2,HeaderBgColor,FontSize,HeaderColor,perc2);
#else
      sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%d</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s></font></th><th></th><th></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%lld</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,htm09,HeaderBgColor,FontSize,HeaderColor,ttnacc/atol(totuser),HeaderBgColor,FontSize,HeaderColor,fixnum(totbytes2),HeaderBgColor,FontSize,HeaderColor,HeaderBgColor,FontSize,HeaderColor,buildtime(totelap2),HeaderBgColor,FontSize,HeaderColor,totelap2,HeaderBgColor,FontSize,HeaderColor,perc2);
#endif
      fputs(html,fp_ou);

      tnacc=0;
      tnbytes=0;
      tnelap=0;
      tnincache=0;
      tnoucache=0;

      fputs("</center></table>\n",fp_ou);

      zdate(ftime, DateFormat);
      sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",htm21,URL,PGM,VERSION,htm22,ftime);
      fputs(html,fp_ou);

      fputs("</html>\n",fp_ou);

      fclose(fp_ou);

   }

   (void)closedir( dirp );

   return;
}
