/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

void getconf(debugm, ConfigFile, AccessLog, debug, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, PasswdFile, TempDir, OutputDir, OutputEmail, Ip2Name, SortField1, SortField2, SortOrder1, SortOrder2, UserAgentLog, ExcludeHosts, abuse, DateFormat, ExcludeUsers, PerUserLimitFile, PerUserLimit)
   int debug;
   unsigned int  debugm;
   unsigned char *ConfigFile;
   unsigned char *AccessLog;
   unsigned char *BgColor;
   unsigned char *TxColor;
   unsigned char *TxBgColor;
   unsigned char *TiColor;
   unsigned char *LogoImage;
   unsigned char *LogoText;
   unsigned char *LogoTextColor;
   unsigned char *Width;
   unsigned char *Height;
   unsigned char *Title;
   unsigned char *BgImage;
   unsigned char *FontFace;
   unsigned char *HeaderColor;
   unsigned char *HeaderBgColor;
   unsigned char *FontSize;
   unsigned char *PasswdFile;
   unsigned char *TempDir;
   unsigned char *OutputDir;
   unsigned char *OutputEmail;
   unsigned char *Ip2Name;
   unsigned char *SortField1;
   unsigned char *SortField2;
   unsigned char *SortOrder1;
   unsigned char *SortOrder2;
   unsigned char *UserAgentLog;
   unsigned char *ExcludeHosts;
   unsigned char *ExcludeUsers;
   unsigned char *abuse;
   unsigned char *DateFormat;
   unsigned char *PerUserLimitFile;
   unsigned char *PerUserLimit;
{

   FILE *fp_in;
   char buf[255];
   char wbuf[255];
   char Msg[255];
   char *str;

   if(debug) {
      sprintf(Msg,"%s: %s",msg55,ConfigFile);
      debuga(Msg);
   }

   if ((fp_in = fopen(ConfigFile, "r")) == NULL) {
      fprintf(stderr, "SQMGRLOG: (getconf) %s: %s\n",msg42,ConfigFile);
      exit(1);
   }

   while (fgets(buf, MAXLEN, fp_in) != NULL) {
      if(debugm)
         printf("CONF %s",buf);

      if((str=(char *) strstr(buf,"#")) != (char *) NULL)
         continue;

      if(strstr(buf,"background_color") != 0) {
         getword(wbuf,buf,' ');
         getword(BgColor,buf,'\0');
         BgColor[strlen(BgColor)-1]='\0';
      }

      if(strstr(buf,"text_color") != 0) {
         if(strstr(buf,"logo_text_color") == 0) {
            getword(wbuf,buf,' ');
            getword(TxColor,buf,'\0');
            TxColor[strlen(TxColor)-1]='\0';
         }
      }

      if(strstr(buf,"text_bgcolor") != 0) {
         getword(wbuf,buf,' ');
         getword(TxBgColor,buf,'\0');
         TxBgColor[strlen(TxBgColor)-1]='\0';
      }

      if(strstr(buf,"title_color") != 0) {
         getword(wbuf,buf,' ');
         getword(TiColor,buf,'\0');
         TiColor[strlen(TiColor)-1]='\0';
      }

      if(strstr(buf,"logo_image") != 0) {
         getword(wbuf,buf,' ');
         getword(LogoImage,buf,'\0');
         LogoImage[strlen(LogoImage)-1]='\0';
      }

      if(strstr(buf,"logo_text") != 0) {
         if(strstr(buf,"logo_text_color") == 0) {
            getword(wbuf,buf,'"');
            getword(LogoText,buf,'"');
         }
      }

      if(strstr(buf,"logo_text_color") != 0) {
         getword(wbuf,buf,' ');
         getword(LogoTextColor,buf,'\0');
         LogoTextColor[strlen(LogoTextColor)-1]='\0';
      }

      if(strstr(buf,"background_image") != 0) {
         getword(wbuf,buf,' ');
         getword(BgImage,buf,'\0');
         BgImage[strlen(BgImage)-1]='\0';
      }

      if(strstr(buf,"font_face") != 0) {
         getword(wbuf,buf,' ');
         getword(FontFace,buf,'\0');
         FontFace[strlen(FontFace)-1]='\0';
      }

      if(strstr(buf,"header_color") != 0) {
         getword(wbuf,buf,' ');
         getword(HeaderColor,buf,'\0');
         HeaderColor[strlen(HeaderColor)-1]='\0';
      }

      if(strstr(buf,"header_bgcolor") != 0) {
         getword(wbuf,buf,' ');
         getword(HeaderBgColor,buf,'\0');
         HeaderBgColor[strlen(HeaderBgColor)-1]='\0';
      }

      if(strstr(buf,"font_size") != 0) {
         getword(wbuf,buf,' ');
         getword(FontSize,buf,'\0');
         FontSize[strlen(FontSize)-1]='\0';
      }

      if(strstr(buf,"image_size") != 0) {
         getword(wbuf,buf,' ');
         getword(Width,buf,' ');
         getword(Height,buf,'\0');
         Height[strlen(Height)-1]='\0';
      }

      if(strstr(buf,"title") != 0) {
         getword(wbuf,buf,'"');
         getword(Title,buf,'"');
      }

      if(strstr(buf,"resolve_ip") != 0) {
         getword(wbuf,buf,' ');
         getword(Ip2Name,buf,'\0');
         Ip2Name[strlen(Ip2Name)-1]='\0';
      }

      if(strstr(buf,"date_format") != 0) {
         getword(wbuf,buf,' ');
         getword(DateFormat,buf,'\0');
         DateFormat[strlen(DateFormat)-1]='\0';
      }

      if(strstr(buf,"report1_sort_field") != 0) {
         getword(wbuf,buf,' ');
         getword(SortField1,buf,' ');
         getword(SortOrder1,buf,'\0');
         SortOrder1[strlen(SortOrder1)-1]='\0';
      }

      if(strstr(buf,"report2_sort_field") != 0) {
         getword(wbuf,buf,' ');
         getword(SortField2,buf,' ');
         getword(SortOrder2,buf,'\0');
         SortOrder2[strlen(SortOrder2)-1]='\0';
      }

      if(strstr(buf,"access_log") != 0) {
         getword(wbuf,buf,' ');
         getword(AccessLog,buf,' ');
         AccessLog[strlen(AccessLog)-1]='\0';
      }

      if(strstr(buf,"useragent_log") != 0) {
         getword(wbuf,buf,' ');
         getword(UserAgentLog,buf,' ');
         UserAgentLog[strlen(UserAgentLog)-1]='\0';
      }

      if(strstr(buf,"exclude_hosts") != 0) {
         getword(wbuf,buf,' ');
         getword(ExcludeHosts,buf,' ');
         ExcludeHosts[strlen(ExcludeHosts)-1]='\0';
      }

      if(strstr(buf,"exclude_users") != 0) {
         getword(wbuf,buf,' ');
         getword(ExcludeUsers,buf,' ');
         ExcludeUsers[strlen(ExcludeUsers)-1]='\0';
      }

      if(strstr(buf,"password") != 0) {
         getword(wbuf,buf,' ');
         getword(PasswdFile,buf,' ');
         PasswdFile[strlen(PasswdFile)-1]='\0';
      }

      if(strstr(buf,"temporary_dir") != 0) {
         getword(wbuf,buf,' ');
         getword(TempDir,buf,' ');
         TempDir[strlen(TempDir)-1]='\0';
      }

      if(strstr(buf,"output_dir") != 0) {
         if(strstr(buf,"output_dir_form") == 0) {
            getword(wbuf,buf,' ');
            getword(OutputDir,buf,' ');
            OutputDir[strlen(OutputDir)-1]='\0';
         }
      }

      if(strstr(buf,"output_email") != 0) {
         getword(wbuf,buf,' ');
         getword(OutputEmail,buf,' ');
         OutputEmail[strlen(OutputEmail)-1]='\0';
      }

      if(strstr(buf,"per_user_limit") != 0) {
         getword(wbuf,buf,' ');
         getword(PerUserLimitFile,buf,' ');
         getword(PerUserLimit,buf,'\0');
         PerUserLimit[strlen(PerUserLimit)-1]='\0';
      }

   }

   fclose(fp_in);

   return;
}
