/*
 * sqmgrlog - Squid user management log
 * Mar/98 - Pedro L Orso - orso@ineparnet.com.br
 */

#include "conf.h"
#include "extern.h"

int abuserel(char *dirname,char *debug,char *periodo,char *debugz,char *iprel,char *outdir,char *addr,char *site,char *us,char *userip,char *email,char *wtemp2,char *BgColor,char *TxColor, char *TxBgColor,char *TiColor,char *LogoImage,char *LogoText,char *LogoTextColor,char *Width,char *Height,char *Title,char *BgImage,char *FontFace,char *HeaderColor,char *HeaderBgColor,char *FontSize,char *TempDir,char *Ip2Name,char *SortField1,char *SortField2,char *SortOrder1,char *SortOrder2,char *UserAgentLog,char *abuse, char *DateFormat)

{

   FILE *fp_in, *fp_ou;
   char tmp[MAXLEN], tmp2[MAXLEN];
   char ip[MAXLEN], data[255], agent[255], user[255], wdata[255];
   char ip2[MAXLEN], data2[255], agent2[255], user2[255];
   char ipantes[MAXLEN], nameantes[MAXLEN], warea[MAXLEN];
   char fmt[255];
   char tagent[7];
   char csort[120];
   char msg[255];
   char ftime[128];
   char user_old[255]="$#%0a3bc6";
   char agent_old[255]="$#%0a3bc6";
   char html[255];
   char idate[MAXLEN], fdate[MAXLEN];
   int  agentot=0, agentot2=0, agentdif=0, cont=0;
   float perc=0;
   unsigned long totregsl=0;
   char dia[15], hora[10], min[5];
   char dia2[15], hora2[10];
   int  lip=0, luser=0, ldata=0, lagent=0, x=0;
   char h1[255], h2[255], h3[255], h4[255];
   time_t t;
   struct tm *local;

   ip[0]='\0';
   data[0]='\0';
   agent[0]='\0';
   user[0]='\0';
   user_old[0]='\0';
   agent_old[0]='\0';
   ipantes[0]='\0';
   nameantes[0]='\0';

   if(strlen(email)<1)
      strcpy(email,"stdout");

   sprintf(tmp,"%s/squagent.unsort",TempDir);
   sprintf(tmp2,"%s/squagent.log",TempDir);

   if((fp_in=fopen(UserAgentLog,"r"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (abuse) %s: %s\n",msg42,UserAgentLog);
      exit(1);
   }

   if((fp_ou=fopen(tmp,"w"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (email) %s: %s\n",msg42,tmp);
      exit(1);
   }

   if(debug) {
      sprintf(msg,"%s: %s",msg63,UserAgentLog);
      debuga(msg);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      totregsl++;
      getword(ip,buf,' ');
      getword(data,buf,'[');
      getword(data,buf,' ');
      if(totregsl == 1)
         strcpy(idate,data);
      getword(agent,buf,'"');
      getword(agent,buf,'"');

      if(strlen(buf)) {
         getword(user,buf,' ');
         getword(user,buf,'\n');
      }

      if(user[0] == '-')
         strcpy(user,ip);
      if(strlen(user) == 0)
         strcpy(user,ip);

      sprintf(buf,"%s\\%s\\%s\\%s\\\n",ip,data,agent,user);
      fputs(buf,fp_ou);
      user[0]='\0';
   }

   strcpy(fdate,data);

   if(debug) {
      sprintf(msg, "   %s: %d",msg07,totregsl);
      debuga(msg);
   }

   fclose(fp_in);
   fclose(fp_ou);

   sprintf(csort,"sort -t '\\' -k 4,4 -k 2,2 -k 1,1 -o %s %s",tmp2,tmp);
   system(csort);

   unlink(tmp);

   if((fp_in=fopen(tmp2,"r"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (abuse) %s: %s\n",msg42,tmp2);
      exit(1);
   }

   if((fp_ou=fopen(tmp,"w"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (abuse) %s: %s\n",msg42,tmp);
      exit(1);
   }

   if(debug)
      debuga(msg71);
   cont=0;

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(ip,buf,'\\');
      getword(data,buf,'\\');
      getword(agent,buf,'\\');
      getword(user,buf,'\\');

      strcpy(wdata,data);

      getword(dia,wdata,':');
      getword(hora,wdata,':');
      getword(min,wdata,':');
      strcat(hora,min);
     
      if(!cont) {
         strcpy(ip2,ip);
         strcpy(data2,data);
         strcpy(agent2,agent);
         strcpy(user2,user);
         strcpy(dia2,dia);
         strcpy(hora2,hora);
         cont++;
         continue;
      }
  
      if(strcmp(user,user2) == 0 && strcmp(dia,dia2) == 0 && strcmp(hora,hora2) == 0 && strcmp(ip,ip2) != 0) {

         if(strlen(ip) > lip)
            lip=strlen(ip);
         if(strlen(user) > luser)
            luser=strlen(user);
         if(strlen(agent) > lagent)
            lagent=strlen(agent);
         if(strlen(data) > ldata)
            ldata=strlen(data);

         if(strcmp(Ip2Name,"yes") == 0) {
            strcpy(ip2,ip);
            ip2name(ip2);
         } else strcpy(ip2,ip);

         sprintf(warea,"%s\\%s\\%s\\%s\\\n",ip2,data,agent,user);
         fputs(warea,fp_ou);
      }

      strcpy(ip2,ip);
      strcpy(data2,data);
      strcpy(agent2,agent);
      strcpy(user2,user);
      strcpy(dia2,dia);
      strcpy(hora2,hora);
   }

   fclose(fp_in);
   fclose(fp_ou);

   unlink(tmp2);

   if((fp_in=fopen(tmp,"r"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (abuse) %s: %s\n",msg42,tmp);
      exit(1);
   }

   if((fp_ou=fopen(tmp2,"w"))==NULL) {
      fprintf(stderr, "SQMGRLOG: (abuse) %s: %s\n",msg42,tmp2);
      exit(1);
   }

   cont=0;

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(ip,buf,'\\');
      getword(data,buf,'\\');
      getword(agent,buf,'\\');
      getword(user,buf,'\\');

      if(cont==0) {

         if(luser<6)
            luser=6;
         for(x=1;x<=luser;x++)
            strcat(h1,"-");
         for(x=1;x<=ldata;x++)
            strcat(h2,"-");
         if(strlen(ip)>lip)
            lip=strlen(ip);
         for(x=1;x<=lip;x++)
            strcat(h3,"-");
         for(x=1;x<=lagent;x++)
            strcat(h4,"-");

         sprintf(fmt,"%%-%ds %%-%ds %%-%ds %%-%ds\n",luser,ldata,lip,lagent);
         sprintf(warea,"\n%s\n%s: %s - %s\n\n",htm25,htm02,idate,fdate);
         if(strcmp(email,"stdout") !=0)
            fputs(warea,fp_ou);
          else
            fprintf(stdout,warea);

         sprintf(warea,fmt,htm11,htm23,htm24,htm19);
         if(strcmp(email,"stdout") !=0)
            fputs(warea,fp_ou);
          else
            fprintf(stdout,warea);

         sprintf(warea,"%s %s %s %s\n",h1,h2,h3,h4);
         if(strcmp(email,"stdout") !=0)
            fputs(warea,fp_ou);
          else
            fprintf(stdout,warea);

         cont++;
         sprintf(fmt,"%%-%ds %%-%ds %%-%ds %%-%ds\n",luser,ldata,lip,lagent);
      }

      sprintf(warea,fmt,user,data,ip,agent);
      if(strcmp(email,"stdout") !=0)
         fputs(warea,fp_ou);
       else
         fprintf(stdout,warea);

   }

   fclose(fp_in);
   fclose(fp_ou);

   t = time(NULL);
   local = localtime(&t);

   if(strcmp(email,"stdout") != 0) {
      sprintf(warea,"%s -s 'SQMGRLOG %s, %s' %s <%s",MAILX,msg52,asctime(local),email,tmp2);
      system(warea);
   }

   unlink(tmp);
   unlink(tmp2);

   if(debug) {
      if(!cont)
         debuga(msg13);
      debuga(msg18);
   }

   if(strcmp(email,"stdout") !=0)
      fprintf(stderr, "SQMGRLOG: %s %s\n",msg45,email);
}
