#ifndef RAYS_FILTER_H
#define RAYS_FILTER_H

/*
** File:       rays-filter.h
** Version:    1.14
** Purpose:    Header file for rays-filter.c
** Written by: R. Butler <butlerra@sbu.ac.uk>
** Date:       30-Jun-2000
** Revised:    08-Mar-2001
**
** Copyright (C) 2001 South Bank University, London
** (Please see the full copyright notice in 'copyright.txt')
*/

/* Some aspects of the program's behaviour may be customised by 
** changing the definitions below.  If any are deleted, default
** values will be used.
*/

/* REPLY_TEXT is the text sent back to the mail client if the
** message is rejected. The bad string(s) which caused the message to
** be rejected will be appended to this text in brackets (). 
** Default "Message was rejected because it contains signs " \
**         "of a possible virus" */

#define REPLY_TEXT "Message was rejected because it contains signs " \
                   "of a possible virus" 

/* A suspiciously long 'Date' header may be a sign that somebody
** is trying to exploit the buffer overrun bug which exists  in 
** some versions of Microsoft Outlook.  To guard against this,
** messages with 'Date' headers longer than DATE_LENGTH_LIMIT 
** will be rejected.
** Default: 60  */

#define DATE_LENGTH_LIMIT 60

/* FILENAME_TEMPLATE is a template for the name of the log file in
** which the message and annotations will be stored while it is
** being processed (see 'man mkstemp').  The path relative to the
** filter's working directory must be included. Must be in "quotes". 
** Default: "rejects/msg.XXXXXX" */ 

#define FILENAME_TEMPLATE  "rejects/msg.XXXXXX"

/* MSG_FILENAME_SIZE is a length sufficient to hold the absolute
** path to the working directory plus a filename based on the 
** FILENAME_TEMPLATE.
** Default: 255 */

#define MSG_FILENAME_SIZE  255

/* In the event of the message being rejected by the filter, the
** log file will be retained under a new name, which will include 
** part or all of the username taken from the 'From' header.
** USERNAME_LIMIT is the maximum number of characters from the username
** which will be included in the log file name.
** Default: 16  */

#define USERNAME_LIMIT 16

/* CONF_FILE_DIR is the location of the configuration files.
** Must be an absolute path and include the trailing '/'.
** Must be in quotes.
** Default: "/usr/local/etc/mail-filter/"  */

#define CONF_FILE_DIR "/usr/local/etc/mail-filter/"

/* HEADER_LIST_FILE is the name of the configuration file which
** contains the list of headers to be examined for the specified 
** suspect strings. Must include CONF_FILE_DIR. 
** Default: CONF_FILE_DIR "header-list.conf" */

#define HEADER_LIST_FILE  CONF_FILE_DIR "header-list.conf"

/* STRING_LIST_FILE is the name of the configuration file which
** contains the list of bad strings to be searched for in the 
** specified headers. Must include CONF_FILE_DIR.
** Default: CONF_FILE_DIR "string-list.conf" */

#define STRING_LIST_FILE  CONF_FILE_DIR "string-list.conf"


#endif
