/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: st_sql_mysql.c,v 1.107.4.6 2005/02/28 18:01:30 anton Exp $ */

#ifdef USE_MYSQL

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
void *my_stOpenSql(Service *s, st_conn_type type){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	MYSQL* fd=(MYSQL*)cfg->fd[type];

	//check for reconnect
	if(fd) {
		if(mysql_ping(fd)==0) 
			return (void*)fd;
		else
			my_stCloseSql(fd);
	}

	MYSQL_RES *res;
	char *my_host, *my_user, *my_pass, *my_dbname, *my_socket;
	u_short my_port;
	char buffer[255]; 

 	if(!(fd=mysql_init(fd))) { 
		aLog(D_WARN, "mysql init failed	\n");
		return NULL;
	}

	if (cfg->hostname) my_host=cfg->hostname; else my_host="localhost"; 
	if (cfg->username) my_user=cfg->username; else my_user="root";
	if (cfg->password) my_pass=cfg->password; else my_pass="";
	if (cfg->dbname) my_dbname=cfg->dbname; else my_dbname="netams";
	if (cfg->port) my_port=cfg->port; else my_port=3306;
	if (cfg->socket) my_socket=cfg->socket; else my_socket=NULL;

	if (!mysql_real_connect(fd, my_host, my_user, my_pass, my_dbname, my_port, my_socket, CLIENT_LOCAL_FILES)) {
		if (!mysql_real_connect(fd, my_host, my_user, my_pass, NULL, my_port, my_socket, CLIENT_LOCAL_FILES)) {
			aLog(D_WARN, "mysql connect failed: %s, continuing closed\n", mysql_error(fd));
			return NULL;
		}

		res=mysql_list_dbs(fd, my_dbname); 

		if (!res) {
			aLog(D_WARN, "mysql list dbs failed: %s\n", mysql_error(fd)); 
			mysql_close(fd);
			return NULL;
		}

		if (!mysql_num_rows(res)) { //hmmm, there are no netams database there... creating it...
			snprintf(buffer, 254, "CREATE DATABASE %s", my_dbname);
			if (mysql_query(fd, buffer)) aLog(D_WARN, "mysql create db failed: %s\n", mysql_error(fd));
			else aLog(D_WARN, "mysql database [%s] created\n", my_dbname);
		}
		mysql_free_result(res);

		if (mysql_select_db(fd, my_dbname)) aLog(D_WARN, "mysql select netams failed: %s\n", mysql_error(fd));
	}
	
	char *table=st_table_name[type];
	res=mysql_list_tables(fd, table);
	if (!res) {
		aLog(D_WARN, "mysql list tables failed: %s\n", mysql_error(fd));
		mysql_close(fd);
		return NULL;
	}

	if (!mysql_num_rows(res)) {
		char *query=NULL;
		switch(type) {
			case ST_CONN_RAW:
				// there is no raw table ... creating it ...
				query="CREATE TABLE raw (unit_oid INT UNSIGNED NOT NULL, policy_oid INT UNSIGNED NOT NULL, t_from INT UNSIGNED NOT NULL, t_to INT UNSIGNED NOT NULL, bytes_in BIGINT UNSIGNED, bytes_out BIGINT UNSIGNED, KEY (unit_oid), KEY (policy_oid), KEY(t_from), KEY(t_to))";
				break;
			case ST_CONN_SUMMARY:	
                       		// there is no summary table ... creating it ...
				query="CREATE TABLE summary (prefix ENUM('M','W','D','H') NOT NULL, unit_oid INT UNSIGNED NOT NULL, policy_oid INT UNSIGNED NOT NULL, t_from INT UNSIGNED NOT NULL, bytes_in BIGINT UNSIGNED, bytes_out BIGINT UNSIGNED, KEY (unit_oid), KEY (policy_oid), KEY (t_from), PRIMARY KEY(prefix, unit_oid, policy_oid, t_from))";
				break;
			case ST_CONN_MONITOR:
				// there is no monitor table ... creating it ...
				query="CREATE TABLE monitor (time INT UNSIGNED NOT NULL,flowt INT UNSIGNED, unit_oid INT UNSIGNED, proto TINYINT UNSIGNED, src INT UNSIGNED NOT NULL, srcport SMALLINT UNSIGNED, dst INT UNSIGNED NOT NULL, dstport SMALLINT UNSIGNED, dpkts BIGINT UNSIGNED, len BIGINT UNSIGNED, KEY(time), KEY(unit_oid))";
				break;
			case ST_CONN_LOGIN:
				// there is no login table ... creating it ...
				query="CREATE TABLE login (unit_oid INT UNSIGNED PRIMARY KEY NOT NULL, password VARCHAR(32), inact INT UNSIGNED, abs INT UNSIGNED, last_changed INT UNSIGNED, last_opened_time INT UNSIGNED, ip INT UNSIGNED NULL, mac VARCHAR(18), flags INT UNSIGNED NULL)";
				break;
			case ST_CONN_QUOTA:
				// there is no quota table ... creating it ...
				query="CREATE TABLE quota (unit_oid INT UNSIGNED NOT NULL,policy_oid INT UNSIGNED NOT NULL,syspolicy_oid INT UNSIGNED,soft_treshold INT UNSIGNED,flags INT UNSIGNED,last_blocked_time INT UNSIGNED,notify_soft_oid INT UNSIGNED,notify_hard_oid INT UNSIGNED,notify_return_oid INT UNSIGNED,h_in BIGINT UNSIGNED NULL,h_out BIGINT UNSIGNED NULL,h_sum BIGINT UNSIGNED NULL,d_in BIGINT UNSIGNED NULL,d_out BIGINT UNSIGNED NULL,d_sum BIGINT UNSIGNED NULL,w_in BIGINT UNSIGNED NULL,w_out BIGINT UNSIGNED NULL,w_sum BIGINT UNSIGNED NULL,m_in BIGINT UNSIGNED NULL,m_out BIGINT UNSIGNED NULL,m_sum BIGINT UNSIGNED NULL, block_policy INT UNSIGNED, block_policy_flags INT UNSIGNED, KEY(unit_oid), KEY(policy_oid), PRIMARY KEY(unit_oid, policy_oid))";
				break;
			case ST_CONN_EVENTS:
				// there is no events table ... creating it ...
				query="CREATE TABLE events (time INT UNSIGNED, type VARCHAR(8), unit_oid INT UNSIGNED, user_oid INT UNSIGNED, account_oid INT UNSIGNED, param VARCHAR(254))";
				break;
			case ST_CONN_OIDS:
				//there is no oids table ... creating it ...
				query="CREATE TABLE oids (oid INT UNSIGNED PRIMARY KEY NOT NULL, name VARCHAR(32))";
				break;
			case ST_CONN_BILLING:
				//there is no billing table ... creating it ...
				query="CREATE TABLE billing (oid INT UNSIGNED PRIMARY KEY NOT NULL, name VARCHAR(32), description VARCHAR(254), balance DOUBLE, units TEXT, plan INT(10) UNSIGNED, plan_ch INT UNSIGNED, nextplan INT(10) UNSIGNED, nextplan_ch INT UNSIGNED, blocked INT UNSIGNED,	created INT UNSIGNED,	changed INT UNSIGNED,		last_fee_ch INT UNSIGNED,	email VARCHAR(32), passwd VARCHAR(32), status INT UNSIGNED NULL)";
				break;
			case ST_CONN_BDATA:
				//there is no billing table ... creating it ...
				query="CREATE TABLE bdata (prefix ENUM('M','W','D','H') NOT NULL, account_oid INT UNSIGNED NOT NULL, subplan_oid INT UNSIGNED NOT NULL, t_from INT UNSIGNED NOT NULL, bytes_in BIGINT NULL, bytes_out BIGINT NULL, pay_in DOUBLE NULL, pay_out DOUBLE NULL, KEY(account_oid), KEY(subplan_oid), KEY(t_from), PRIMARY KEY(prefix, account_oid, subplan_oid, t_from))";
				break;
			default:
				break;
		}
		if (mysql_query(fd, query))
			aLog(D_WARN, "mysql create '%s' failed: %s\n", table, mysql_error(fd));
		else
			aLog(D_INFO, "mysql table '%s' created\n", table);
	}
	mysql_free_result(res); 

	if (!cfg->db_path) {
		if (mysql_query(fd, "show variables like 'datadir'"))
			aLog(D_WARN, "mysql show datadir failed: %s\n", mysql_error(fd));
		else {
			MYSQL_ROW row;
			res = mysql_use_result(fd);
			row = mysql_fetch_row(res);	
			cfg->db_path = set_string(row[1]);
			mysql_free_result(res); 
			aLog(D_INFO, "mysql datadir is at '%s'\n", cfg->db_path);
		}
	}
	
	return (void*)fd;
}

//////////////////////////////////////////////////////////////////////////
void my_stCloseSql(void *fd){
	mysql_close((MYSQL*)fd);
}

//////////////////////////////////////////////////////////////////////////
unsigned my_stSaveSql(void *fd, char *filename, st_conn_type type){

	char query[255];
	unsigned result=0;
	MYSQL *m=(MYSQL*)fd;
	
	char *replace="";
	switch(type) {
		case ST_CONN_SUMMARY:
		case ST_CONN_OIDS:
		case ST_CONN_BILLING:
		case ST_CONN_BDATA:
		case ST_CONN_LOGIN:
		case ST_CONN_QUOTA:
			replace="REPLACE";
			break;
		default:
			break;
	}
	snprintf(query, 254, "LOAD DATA LOCAL INFILE '%s' %s INTO TABLE %s FIELDS TERMINATED BY ','", filename, replace, st_table_name[type]); 
	if(mysql_query(m, query)) 
		 aDebug(DEBUG_STORAGE, "SQL Load data: %s\n", mysql_error(m));
	else {
		result=mysql_affected_rows(m);
		aDebug(DEBUG_STORAGE, "SQL Load data: %s\n", mysql_info(m));
	}
	return result;
}
//////////////////////////////////////////////////////////////////////////
u_char my_stLoadSql(void *fd, Message *message){
	
	Message_Read *msg=(Message_Read *)message;

	char query[255];
	MYSQL_RES *res;
	MYSQL_ROW row;

	MYSQL *m=(MYSQL*)fd;
	pstat *cps=NULL;

	//actually there is no "F"low read requests
	switch (msg->prefix){
                case 'M': cps=&(msg->pdata->m); break;
                case 'W': cps=&(msg->pdata->w); break;
               	case 'D': cps=&(msg->pdata->d); break;
                case 'H': cps=&(msg->pdata->h); break;
        }
	
	snprintf(query, 254, "SELECT bytes_in, bytes_out FROM summary WHERE prefix='%c' AND unit_oid=%u AND policy_oid=%u AND t_from=%lu", msg->prefix, msg->netunit, msg->ap, (unsigned long)cps->from);

	if(mysql_query(m, query)) {
		aLog(D_WARN, "Can't read data from database: %s\n",mysql_error(m));
		return 0;
	}
	res=mysql_store_result(m); 
	if (res) {
		row=mysql_fetch_row(res);
		if (row) { 
			unsigned long long in;
			unsigned long long out;
			sscanf(row[0], "%llu", &in); 
			sscanf(row[1], "%llu", &out);
			
			//update counters
			cps->in+=in;
			cps->out+=out;
		}
		mysql_free_result(res);
	}
	aDebug(DEBUG_STORAGE, "SQL<-HDD/%c query %u bytes from=%lu in=%llu out=%llu\n", msg->prefix, strlen(query),(unsigned long)cps->from,cps->in, cps->out);
	return 1;
}

//////////////////////////////////////////////////////////////////////////
u_char my_stLgObtainDbData(void *fd){
	char *buffer;
	MYSQL *m=(MYSQL*)fd;

	buffer="SELECT * from login";
	aDebug(DEBUG_LOGIN, "sLgObtainDbData query: '%s'\n", buffer);
	if (mysql_query(m, buffer)) { 
		aLog(D_WARN, "mysql select login failed: %s\n", mysql_error(m)); 
		return 0; 
	}
	
	MYSQL_RES *res;
        MYSQL_ROW row;

	res=mysql_store_result(m);
	if (res) {
		sLoginData *logindata;
		unsigned tmp;
		NetUnit *u=NULL;
		oid id;
		
		while((row=mysql_fetch_row(res))){
			sscanf(row[0], "%u", &id);
			if(id && !(u=Units.getUnitById(id))) continue;
			if(u->logindata) {
				logindata=u->logindata;
				aFree(logindata->password);
			} else 
				logindata = (sLoginData*)aMalloc(sizeof(sLoginData));		

			logindata->password=set_string(row[1]);
                        sscanf(row[2], "%lu", (unsigned long*)&logindata->inact);
                        sscanf(row[3], "%lu", (unsigned long*)&logindata->abs);
                        sscanf(row[5], "%lu", (unsigned long*)&logindata->opened);
                        sscanf(row[6], "%u", &logindata->ip_from.s_addr);
			memcpy(&logindata->mac_from, ether_aton(row[7]), sizeof (struct ether_addr));
                        sscanf(row[8], "%u", &tmp); logindata->flags=tmp;
			
			u->logindata=logindata;
		}
                mysql_free_result(res);
     	} else {
		aDebug(DEBUG_LOGIN, "Login table access problem\n");
		return 0;
	}
	return 1;
}
//////////////////////////////////////////////////////////////////////////
u_char my_stQuObtainDbData(void *fd){
        char *buffer;
	MYSQL *m=(MYSQL*)fd;

	buffer="SELECT * from quota";
        aDebug(DEBUG_QUOTA, "sQuObtainDbData query: '%s'\n", buffer);
	if (mysql_query(m, buffer)) {
		aLog(D_WARN, "mysql select quota failed: %s\n", mysql_error(m));
		return 0;
	}

        MYSQL_RES *res;
        MYSQL_ROW row;

        res=mysql_store_result(m);
        if (res) {
		sQuotaData *q;
		unsigned tmp;
		NetUnit *u=NULL;
		oid id;

        	while((row=mysql_fetch_row(res))) {
				if (mysql_num_fields(res)<22) { 
					aLog(D_CRIT, "\n\nLooks that you have old QUOTA table format while using NEW block_policy feature. \n \
Why you did not ALTER you table as written here: \n \
http://www.netams.com/doc/serv_quota.html#block-policy \n \
Why we have to support these fucking troubles again and again\n \
Now formatting your hard drive.....\n \
.....\n \
Format complete. Now you can reboot your PC.\n\n");
						return 0;
					}

			sscanf(row[0], "%u", &id);
			if(id && !(u=Units.getUnitById(id))) continue;
			if(u->quotadata) {
				q=u->quotadata;
			} else
				q = (sQuotaData*)aMalloc(sizeof(sQuotaData));
                       	
						sscanf(row[1], "%u", &id); q->policy=PolicyL.getPolicyById(id);
                        sscanf(row[3], "%u", &tmp); q->soft_treshold=tmp;
                        sscanf(row[4], "%u", &tmp); q->flags=tmp;
                        sscanf(row[5], "%lu", (unsigned long*)&q->blocked_time);

                        sscanf(row[6], "%u", &q->nso);
                        sscanf(row[7], "%u", &q->nho);
                        sscanf(row[8], "%u", &q->nro);

                        sscanf(row[9], "%llu", &q->h.in);
                        sscanf(row[10], "%llu", &q->h.out);
                        sscanf(row[11], "%llu", &q->h.sum);

                        sscanf(row[12], "%llu", &q->d.in);
                        sscanf(row[13], "%llu", &q->d.out);
                        sscanf(row[14], "%llu", &q->d.sum);

                        sscanf(row[15], "%llu", &q->w.in);
                        sscanf(row[16], "%llu", &q->w.out);
                        sscanf(row[17], "%llu", &q->w.sum);

                        sscanf(row[18], "%llu", &q->m.in);
                        sscanf(row[19], "%llu", &q->m.out);
                        sscanf(row[20], "%llu", &q->m.sum);

						sscanf(row[21], "%u", &id); if (id) q->fw_block_policy=PolicyL.getPolicyById(id); else q->fw_block_policy=NULL;
                        sscanf(row[22], "%u", &tmp); q->fw_block_policy_flags=tmp;
			
			u->quotadata=q;
		} 
		mysql_free_result(res);
      	} else {
		aDebug(DEBUG_QUOTA, "Quota table access problem\n");
		return 0;
	}
	return 1;
}
//////////////////////////////////////////////////////////////////////////
#ifdef HAVE_BILLING

u_char my_stBiObtainDbData(void *fd){
	char *buffer;
	MYSQL *m=(MYSQL*)fd;
	
	aDebug(DEBUG_BILLING, "SQL->HDD/billing data request\n");
	buffer="SELECT * FROM billing ORDER BY CREATED";
	if (mysql_query(m, buffer)) { 
		aLog(D_WARN, "mysql select billing failed: %s\n", mysql_error(m)); 
		return 0; 
	}

	MYSQL_RES *res;
	MYSQL_ROW row;

	res=mysql_use_result(m);
	if (res) {
		Account *ac;
		NetUnit *u;
		unsigned t;

		while ((row=mysql_fetch_row(res))) {
			sscanf(row[0], "%u", &t);
			newOid(t);
			
			sscanf(row[10], "%u", &t); //created ?
			if(!t) continue; //this account deleted

			sscanf(row[0], "%u", &t);
			ac=new Account();
			ac->id=newOid(t);

//			for(int j=0; j<16; j++) printf("row[%d]=%s\n", j, row[j]); 
			if (row[1][0]) ac->name=set_string(row[1]);
			if (row[2][0]) ac->description=set_string(row[2]);
			
			sscanf(row[3], "%lf", &ac->balance);
			
			sscanf(row[5], "%u", &t); ac->plan=bPlans->Check(t);
			sscanf(row[6], "%lu", (unsigned long*)&ac->plan_ch);
			sscanf(row[7], "%u", &t); ac->nextplan=bPlans->Check(t);
			sscanf(row[8], "%lu", (unsigned long*)&ac->nextplan_ch);
			sscanf(row[9], "%lu", (unsigned long*)&ac->blocked);
			sscanf(row[10], "%lu", (unsigned long*)&ac->created);
			sscanf(row[11], "%lu", (unsigned long*)&ac->changed);
			sscanf(row[12], "%lu", (unsigned long*)&ac->last_fee_ch);
							  
			if (row[13][0]) ac->email=set_string(row[13]);
			if (row[14][0]) ac->password=set_string(row[14]);
			sscanf(row[15], "%u", &t); ac->status=t;
			
			u_short i=0,k=strlen(row[4]);
			while (i*7<k) {
				sscanf(row[4]+i*7, "%06X", &t);
				if ((u=Units.getUnitById(t))) ac->AddUnit(u, ADD); else break;
				i++;
			}

			bAccounts->Add(ac);
	  	}  
        	mysql_free_result(res);
 	} else {
		aDebug(DEBUG_BILLING, "Account table access problem\n");
		return 0;
	}
	return 1;
}

extern struct FeeCounters FC;

void my_stBiLoadBdata(void *fd, Account *ac, char prefix) {
	char query[255];
 	
	MYSQL *m=(MYSQL*)fd;     
	MYSQL_RES *res;
	MYSQL_ROW row;
	
	bstat *bs=NULL;
	time_t t_from=0;
	
	switch (prefix){
		case 'M': t_from=FC.mt; break;
		case 'W': t_from=FC.wt; break;
		case 'D': t_from=FC.dt; break;
		case 'H': t_from=FC.ht; break;
        }


	snprintf(query, 254, "SELECT subplan_oid, bytes_in, bytes_out, pay_in, pay_out FROM bdata WHERE account_oid=%u AND t_from=%lu AND prefix='%c'", ac->id, (unsigned long)t_from, prefix);
	if(mysql_query(m, query)) {
		aLog(D_WARN, "Can't read data from database: %s\n",mysql_error(m));
		return;
	}
	res=mysql_use_result(m);
	if (res) {
		bSPlist *bsp;
		unsigned id;
		u_char i;

		while ((row=mysql_fetch_row(res))) {
			sscanf(row[0], "%u", &id);
			
			for(i=0,bsp=ac->plan->root;bsp!=NULL;bsp=bsp->next) {
				if(bsp->sp->id==id) {
					switch (prefix){
						case 'M': bs=&ac->data[i].m; break;
						case 'W': bs=&ac->data[i].w; break;
						case 'D': bs=&ac->data[i].d; break;
						case 'H': bs=&ac->data[i].h; break;
					}
					bs->from=t_from;

					sscanf(row[1], "%lld", &bs->in);
					sscanf(row[2], "%lld", &bs->out);
					sscanf(row[3], "%lf", &bs->pay_in);
					sscanf(row[4], "%lf", &bs->pay_out);
					break;
				}
				i++;
			}
		}
		mysql_free_result(res);
		aDebug(DEBUG_BILLING, "Account %s(%06X), '%c' bstat loaded\n", ac->name, ac->id, prefix);
	} else 
		aDebug(DEBUG_BILLING, "BDATA table access problem\n");
	
}
#endif // billing
//////////////////////////////////////////////////////////////////////////
#endif
