/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: st_sql.c,v 1.55.4.2 2005/02/18 18:03:28 anton Exp $ */

#include "netams.h"

//////////////////////////////////////////////////////////////////////////
char *db_type_name[ST_DB_TYPES_NUM]={ "UNKNOWN", "HASH", "MySQL", "POSTGRESQL", "ORACLE" };
//////////////////////////////////////////////////////////////////////////

#ifdef USE_ORACLE
char *st_table_name[ST_CONN_TYPES_NUM]={ "", "RAWDATA", "SUMMARY", "MONITOR",
                                          "LOGIN", "QUOTA", "EVENTS", "OIDS",
                                          "BILLING" , "BDATA", "CONFIG" };
#else
char *st_table_name[ST_CONN_TYPES_NUM]={ "", "raw", "summary", "monitor", "login", "quota", "events", "oids", 
		"billing" , "bdata", "config" };
#endif

//////////////////////////////////////////////////////////////////////////
void *stOpenSql(Service *s,st_conn_type type){

	if(!s) {
		aLog(D_WARN, "NULL storage in OpenSql\n");
		return NULL;
	}

        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	void *fd=NULL;

	switch (cfg->type) {
#ifdef USE_MYSQL
		case MY_SQL:
			fd=my_stOpenSql(s,type);
			break;
#endif
#ifdef USE_POSTGRES
		case POSTGRES:
			fd=pg_stOpenSql(s,type);
			break;
#endif
#ifdef USE_ORACLE
		case ORACLE:
			fd=ora_stOpenSql(s,type);
			break;
#endif
		case UNKNOWN:
		default:
			aLog(D_ERR, "SQL feature is not compiled in!\n");
			break;
	}

	if(fd){
		if(fd!=cfg->fd[type])
			aDebug(DEBUG_STORAGE, "%s DB:%u reuse connection to [%s] for %s\n",
				db_type_name[cfg->type],
				s->instance,
				cfg->dbname?cfg->dbname:"netams",
				st_table_name[type]);
		else 
			aDebug(DEBUG_STORAGE, "%s DB:%u opened [%s] for %s\n",
				db_type_name[cfg->type],
				s->instance,
				cfg->dbname?cfg->dbname:"netams",
				st_table_name[type]);
	}
	cfg->fd[type]=fd;
	return fd;
}
//////////////////////////////////////////////////////////////////////////
void stCloseSql(Service *s , st_conn_type type){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	void *fd=cfg->fd[type];
	
	if(!fd) return;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        my_stCloseSql(fd);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        pg_stCloseSql(fd);
			break;
#endif
#ifdef USE_ORACLE
                case ORACLE:
                        ora_stCloseSql(fd);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_WARN, "SQL feature is not compiled in!\n");
                        break;
        }
	cfg->fd[type]=NULL;
	aDebug(DEBUG_STORAGE, "%s DB:%u closed to database %s table %s\n",
		db_type_name[cfg->type],
                s->instance,
                cfg->dbname?cfg->dbname:"netams",
                st_table_name[type]
        );

}
//////////////////////////////////////////////////////////////////////////
unsigned stSaveSql(Service *s, char *filename, st_conn_type type){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	unsigned ret=0;
	struct stat sb;

	bzero(&sb, sizeof(struct stat));
	stat(filename, &sb);
	
	if(!(sb.st_mode&S_IFREG)) {
		aDebug(DEBUG_STORAGE, "stSaveSql: file %s not exist\n", filename);
		return 0;
	}
	
	void *fd=stOpenSql(s, type);
	
	if(!fd) return 0;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        ret=my_stSaveSql(fd,filename,type);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        ret=pg_stSaveSql(fd,filename,type);
                        break;
#endif
#ifdef USE_ORACLE
                case ORACLE:
                        ret=ora_stSaveSql(fd,filename,type);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "SQL feature is not compiled in!\n");
                        break;
        }
	
	if(ret) {
		aDebug(DEBUG_STORAGE, "SQL->HDD/%s %u affected\n", st_table_name[type], ret);
		unlink(filename);
	}
	else 
		aLog(D_WARN, "Failed load data into sql for %s try \"debug storage\"\n", st_table_name[type]);

	return ret;
}
//////////////////////////////////////////////////////////////////////////
u_char stLoadSql(Service *s, void *fd, Message *msg){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg *)s->cfg;
	u_char ret=0;

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
                        ret=my_stLoadSql(fd,msg);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
                        ret=pg_stLoadSql(fd,msg);
                        break;
#endif
#ifdef USE_ORACLE
        case ORACLE:
                        ret=ora_stLoadSql(fd,msg);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "SQL feature is not compiled in!\n");
                        break;
        }
return ret;
}
//////////////////////////////////////////////////////////////////////////
u_char stLgObtainDbData(Login_cfg *slcfg){
	ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)slcfg->st->cfg;
	u_char res=0;
	void *fd;
	
	if(!(fd=stOpenSql(slcfg->st,ST_CONN_LOGIN))) return 0;
	
	pthread_rwlock_wrlock(slcfg->rwlock);
	pthread_rwlock_rdlock(Units.rwlock);

	switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL: 
			res=my_stLgObtainDbData(fd);
			break;
#endif
#ifdef USE_POSTGRES
		case POSTGRES:
			res=pg_stLgObtainDbData(fd);
			break;
#endif
#ifdef USE_ORACLE
    case ORACLE:
			res=ora_stLgObtainDbData(fd);
			break;
#endif
		case UNKNOWN:
		default:
			aLog(D_ERR, "login service requires MySQL or Postgres storage [%d], exiting\n", cfg->type);
			break;
	}
	pthread_rwlock_unlock(Units.rwlock);
	pthread_rwlock_unlock(slcfg->rwlock);

	return res;
}
//////////////////////////////////////////////////////////////////////////
u_char stQuObtainDbData(Quota_cfg *sqcfg){
        ServiceStorage_cfg *cfg=(ServiceStorage_cfg*)sqcfg->st->cfg;
	void *fd;
	u_char res=0;
	
	if(!(fd=stOpenSql(sqcfg->st,ST_CONN_QUOTA))) return 0;
	
	pthread_rwlock_wrlock(sqcfg->rwlock);
	pthread_rwlock_rdlock(Units.rwlock);

        switch (cfg->type) {
#ifdef USE_MYSQL
                case MY_SQL:
			res=my_stQuObtainDbData(fd);
                        break;
#endif
#ifdef USE_POSTGRES
                case POSTGRES:
			res=pg_stQuObtainDbData(fd);
                        break;
#endif
#ifdef USE_ORACLE
        case ORACLE:
			res=ora_stQuObtainDbData(fd);
                        break;
#endif
                case UNKNOWN:
                default:
                        aLog(D_ERR, "quota service requires SQL storage [%d], exiting\n", cfg->type);
                        break;
        }
	pthread_rwlock_unlock(Units.rwlock);
	pthread_rwlock_unlock(sqcfg->rwlock);

	return res;
}
//////////////////////////////////////////////////////////////////////////////////////////
#ifdef HAVE_BILLING
u_char stBiObtainDbData(Billing_cfg *cfg){
	u_char res=0;
	void *fd;
	ServiceStorage_cfg *storagecfg=(ServiceStorage_cfg*)cfg->st->cfg;
	
	if(!(fd=stOpenSql(cfg->st,ST_CONN_BILLING))) return 0;

	switch (storagecfg->type) {
#ifdef USE_MYSQL
		case MY_SQL:
			res=my_stBiObtainDbData(fd);
			break;
#endif
#ifdef USE_POSTGRES
		case POSTGRES:
			res=pg_stBiObtainDbData(fd);
			break;
#endif
#ifdef USE_ORACLE
		case ORACLE:
			res=ora_stBiObtainDbData(fd);
			break;
#endif
		default:
			break;
	}
	return res;
}

u_char stBiLoadBdata(Billing_cfg *cfg) {
	void *fd;

	ServiceStorage_cfg *storagecfg=(ServiceStorage_cfg*)cfg->st->cfg;
	if(!(fd=stOpenSql(cfg->st,ST_CONN_BDATA))) return 0;

	switch (storagecfg->type) {
#ifdef USE_MYSQL
		case MY_SQL:
			for(Account *ac=bAccounts->root; ac!=NULL; ac=ac->next) {
				if(ac->plan) {
					my_stBiLoadBdata(fd, ac, 'M');
					my_stBiLoadBdata(fd, ac, 'W');
					my_stBiLoadBdata(fd, ac, 'D');
					my_stBiLoadBdata(fd, ac, 'H');
				}
			}
			break;
#endif
#ifdef USE_POSTGRES
		case POSTGRES:
			for(Account *ac=bAccounts->root; ac!=NULL; ac=ac->next) {
				if(ac->plan) {
					pg_stBiLoadBdata(fd, ac, 'M');
					pg_stBiLoadBdata(fd, ac, 'W');
					pg_stBiLoadBdata(fd, ac, 'D');
					pg_stBiLoadBdata(fd, ac, 'H');
				}
			}
			break;
#endif
#ifdef USE_ORACLE
		case ORACLE:
			for(Account *ac=bAccounts->root; ac!=NULL; ac=ac->next) {
				if(ac->plan) {
					ora_stBiLoadBdata(fd, ac, 'M');
					ora_stBiLoadBdata(fd, ac, 'W');
					ora_stBiLoadBdata(fd, ac, 'D');
					ora_stBiLoadBdata(fd, ac, 'H');
				}
			}
			break;
#endif
		default:
			break;
	}
	return 1;
}
#endif // HAVE_BILLING 

//////////////////////////////////////////////////////////////////////////////////////////
