/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: s_pvmgate.c,v 1.29 2005/01/17 13:13:22 jura Exp $ */

#include "netams.h"

void sPVMCancel(void *v);
FILE *sPVM_connect(char *s);

//////////////////////////////////////////////////////////////////////////
void sPVMInit(Service *s){
	PVM_cfg *cfg=(PVM_cfg*)aMalloc(sizeof(PVM_cfg));
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#endif
	s->cfg = cfg;
	cfg->queue=new FIFO(255);
	cfg->msg_send=0;
	cfg->msg_send_ok=0;
	cfg->host=NULL;
	cfg->path=NULL;
	cfg->io=NULL;
	pthread_create(&(s->t_id), NULL, &sPVM, s);
}

//////////////////////////////////////////////////////////////////////////
void sPVMProcessCfg(char *param[], Connection *conn, u_char no_flag){
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#else	
	int id;
	PVM_cfg *cfg=(PVM_cfg*)conn->service->cfg;

	if (!strcasecmp(param[0], "peer")) {
		id=strtol(param[1], NULL, 10);
		if(cfg->host) aFree(cfg->host); 
		if(cfg->path) aFree(cfg->path);
		cfg->host=set_string(param[2]);
		cfg->path=set_string(param[3]);
		aParse(conn, "peer %d host: '%s' path: '%s' \n", id, cfg->host, cfg->path);
	}
#endif
}
//////////////////////////////////////////////////////////////////////////
void *sPVM(void *ss){

#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#else
	Service *s=(Service*)ss; 
	PVM_cfg *cfg=(PVM_cfg*)s->cfg;
	Message *msg;
	Message_PVM_Billing *bmsg;
	Account *ac;
	char *text;
	aLog(D_INFO, "service PVMgateway thread started\n");
	
	pthread_cleanup_push(sPVMCancel, s);
	SET_CANCEL();
	s->t_id=pthread_self();

	// now we should sleep before starting actual server
	if(!(s->flags&SERVICE_RUN)) s->Sleep();
	
	/*int pvm_self=pvm_mytid();
	int pvm_server;
	int gr_id=pvm_joingroup("netams");
	if (gr_id<0) aLog(D_INFO, "failed to join group\n");
	*/

	// connect

	if (!cfg->host || !cfg->path) aLog(D_CRIT, "PVM gateway service requires remote host and path!\n");
 
	char conn_str[256];
	char buffer[1024];
	if (cfg->host && !strcasecmp(cfg->host, "localhost")) 
		snprintf(conn_str, 255, "%s", cfg->path);
	else snprintf(conn_str, 255, "ssh %s %s", cfg->host, cfg->path);

	int res, res1;
	while (1) {
		aDebug(DEBUG_PVM, "PVM loop...\n");
		
		/*//search for active receiver in that group ...
		pvm_server=-1;
		for (int j, i=0; i<pvm_gsize("netams"); i++ ) {
			if (pvm_self!=(j=pvm_gettid("netams", i))) { pvm_server=j; break; }
			}
		if (pvm_server==-1) { s->Sleep(1); continue; }

		*/
		if (cfg->io) fputs("\n", cfg->io);
		if (!cfg->io || fflush(cfg->io)==-1) {
			cfg->io=sPVM_connect(conn_str);
			aDebug(DEBUG_PVM, "Connecting to [%s]\n", conn_str); 
			if (cfg->io==NULL) { 
				aLog(D_CRIT, "Unable to create a pipe [%s]: %s!\n", conn_str, strerror(errno)); 
				s->Sleep(10); 
				continue; 
			}
		}

		while(cfg->queue->num_items > 0) {
			msg=cfg->queue->Pop();
			if (msg->type!=MSG_PVM_BILLING) { 
				MsgMgr.Delete(msg); 
				continue;
			}
			bmsg=(Message_PVM_Billing*)msg;
			ac=(Account*)bmsg->account;
			text=(char*)bmsg->text;
#ifdef HAVE_BILLING
			snprintf(buffer, 255, "%s\t%s\t%f\t%lu\t%s\t%s\t%s\n", ac->name, text, ac->balance, (unsigned long)bmsg->ts, ac->email?ac->email:(char*)"-", ac->plan?ac->plan->name:"-", ac->plan?ac->plan->description:"");
#endif
/*			buf_id=pvm_initsend(0);
        	pvm_pkstr(ac->name);
        	pvm_pkstr(text);
        	snprintf(buffer, 255, "%f", ac->balance); pvm_pkstr(buffer);
        	snprintf(buffer, 255, "%u", bmsg->ts); pvm_pkstr(buffer);
        	pvm_pkstr(ac->email?ac->email:(char*)"");
        	pvm_pkstr(ac->plan->name);
        	pvm_pkstr(ac->plan->description); 
			res=pvm_send(pvm_server, 0);	  */
			res=fwrite(buffer, strlen(buffer), 1, cfg->io);
			res1=fflush(cfg->io);
			if (res==1) cfg->msg_send_ok++;
			cfg->msg_send++;
			aFree(bmsg->text);
			MsgMgr.Delete(msg);
			aDebug(DEBUG_PVM, "sent IO %p, result %d [%s], %d\n", cfg->io, res, (res!=1)?strerror(errno):"-", res1);
		}
		s->Sleep(5); //sleep for 50 secs
	}

	pthread_cleanup_pop(0);
#endif
	return NULL;
}
//////////////////////////////////////////////////////////////////////////
void sPVMCancel(void *v){
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#else
	Service *s = (Service*)v;
	PVM_cfg *cfg=(PVM_cfg*)s->cfg;
	delete cfg->queue;
	pclose(cfg->io);
	if(cfg->host) aFree(cfg->host); 
	if(cfg->path) aFree(cfg->path);
	struct timeval now;
	gettimeofday(&now, NULL);
	aLog(D_INFO, "cancelling service PVMgateway:%d, processed %lu bcasts, %lu ok (%f%) (%lf bc/sec)\n", s->instance, cfg->msg_send, cfg->msg_send_ok, 100*(float)cfg->msg_send_ok/cfg->msg_send,(double)cfg->msg_send_ok / (now.tv_sec - program_start.tv_sec));
	aFree(cfg);
#endif
}

//////////////////////////////////////////////////////////////////////////
void sPVMListCfg(Service *s, FILE *f){
#ifndef PVM
	aLog(D_CRIT, "PVM gateway service is not compiled in!\n");
#endif
	PVM_cfg *cfg=(PVM_cfg*)s->cfg;

	if (cfg->host && cfg->path) fprintf(f, "peer 1 %s %s \n", cfg->host, cfg->path);
	fprintf(f, "\n");
}

//////////////////////////////////////////////////////////////////////////
void sPvmSend(Account *a, char *data){
#ifdef HAVE_BILLING
	Service *s=NULL;
	if(!(s=Services.getServiceNextByType(SERVICE_PVMGATE,s))) return;
	PVM_cfg *cfg=(PVM_cfg*)s->cfg;

	Message_PVM_Billing *msg;
	msg = (Message_PVM_Billing *)MsgMgr.New(MSG_PVM_BILLING);
	msg->account=a;
	msg->text=set_string(data);
	msg->ts=time(NULL);
	cfg->queue->Push((Message*)msg);
	aDebug(DEBUG_PVM, "queue account %s: %s\n", a->name, data);
#endif	
}

//////////////////////////////////////////////////////////////////////////
FILE *sPVM_connect(char *s) {
	return popen(s, "w");
}
//////////////////////////////////////////////////////////////////////////
