/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: policy_prefix.h,v 1.14 2005/01/17 13:13:21 jura Exp $ */

#define PREFIX_COMMENTED	0x01
#define PREFIX_INVERTED		0x02

typedef struct prefix {
	in_addr network;
	u_char mask;
	u_char flags;
	unsigned long long match;
} prefix;

class PrefixTree;

class PrefixFile {
	public:
		prefix *list;
		PrefixTree *ptree;
		char *filename;
		FILE *descriptor;
		unsigned num_prefixes;
		pthread_rwlock_t *rwlock;
		PrefixFile();
		~PrefixFile();
		int Load(char *filename); // *
		void Unload(); // *
		void Do(Connection *conn, char *action, char *action2=NULL);
		u_char Check(unsigned addr);  // we will check if adr match prefix
		void Dump(Connection *conn);
		void Save(Connection *conn);
};
/////////////////////////////////////////////////////////////////////////////////////////////
