/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: parse.c,v 1.55.4.1 2005/02/18 18:02:56 anton Exp $ */

#include "netams.h"

char *empty=" ";
char *empty_="";

//////////////////////////////////////////////////////////////////////////////////////////
// Configuration parse /////////////////////////////////////////////////////////////////// 

int aCommand(Connection *conn, char *cmd_orig){
	char *param[MAX_PARAM];
	u_char no_flag;
	
	char *a, *b;
	int i, j, return_state=PARSE_OK;
	char *cmd;
	
	if (cmd_orig[0]==10 || cmd_orig[0]=='\0') { 
		if(conn->service) {
        		if(conn!= cInternal && !(conn->service->flags&SERVICE_RUN)) {
				conn->service->Wakeup();
				conn->service->flags|=SERVICE_RUN;
               			aLog(D_INFO, "waking up %s:%u service\n", conn->service->getName(), conn->service->instance);
                	}
			conn->service=NULL;
		}
		return return_state; 
	} 
	if (cmd_orig[0]=='#' || cmd_orig[0]=='!') return return_state; 

	cmd=set_string(cmd_orig);
	char *cmd_before_split=cmd;
	
	// check if out command consist of several sub-commands separated by '&&' (as netamsctl)
	// if so, do several calls for the same aCommand();
	char *p=cmd, *pp, *quot; 
	u_char proceed;
	do {
		quot=strchr(p, '\''); if (!quot) quot=strchr(p, '\"'); 
		pp=strstr(p, "&&");
		proceed = pp && (!quot || (quot>pp));
		if (proceed) { 
			*pp='\0';
			int i=aCommand(conn, p); 
			if (i==PARSE_KILL || i==PARSE_SHUTDOWN || i==PARSE_RELOAD) termination(i);
			p=pp+3;
		}
	} while (proceed);
	cmd=p;
	// done subcommanding	

	no_flag=0;

	// now we will parse the input string for 'no' modifier and param[] array
	a=strstr(cmd, "\n"); if (a!=NULL) *a='\0';	
	a=strstr(cmd, "\r"); if (a!=NULL) *a='\0';
	b=cmd;

	if (conn->service) aDebug(DEBUG_COMMAND, "(%s)/%s:%u->%s\n", conn->getName(), conn->service->getName(), conn->service->instance, cmd);
	else aDebug(DEBUG_COMMAND, "(%s)->%s\n", conn->getName(), cmd);

	conn->t_lastcmd=time(NULL);

	for (i=0; i<MAX_PARAM; i++) param[i]=empty;
	i=0;
	while (NULL!=(a=strchr(b, ' '))) {
		if (b[0]=='"'){ 
			a=strchr(++b, '"');  
			if (a==NULL) { 
				aParse(conn, "Unterminated quotation, %s\n", b); 
				goto EXIT; 
			} 
		}
		if (b[0]=='\''){ 
			a=strchr(++b, '\'');  
			if (a==NULL) { 
				aParse(conn, "Unterminated quotation, %s\n", b); 
				goto EXIT; 
			} 
		}
		j=(a-b);
		if (strncasecmp(b, "no ", 3)==0 && i==0) { 
			no_flag=1; 	
			while (a[1]==' ') a++; 	
			b=a+1; 
			continue;  
		}
		param[i]=(char *)aMalloc(j+1); 
		param[i+1]=empty;
		strncpy(param[i], b, j);
		while (a[1]==' ') a++;
		b=a+1;
		if (++i==61) break;
	}
	
	if (b[0]=='"'){ 
		a=strchr(++b, '"'); 
		a[0]=0; 
		if (a==NULL) { 
			aParse(conn, "Unterminated quotation, %s\n", b); 
			goto EXIT;
		} 
	}
	if (b[0]=='\''){ 
		a=strchr(++b, '\''); 
		a[0]=0; 
		if (a==NULL) { 
			aParse(conn, "Unterminated quotation, %s\n", b); 
			goto EXIT;
		} 
	}
	if (b[0]!='\0') { 
		param[i]=set_string(b);
		param[i+1]=empty; 
	}

//	for (u_char k=0; k<MAX_PARAM; k++) if (param[k]!=empty) aDebug(DEBUG_PARSE,"[%d]=%s\n", k, param[k]); 
	
	// ok here param[0] switch clause
	if (!strcasecmp(param[0], "exit")) { 
			if (conn->service) {
				if(!(conn->service->flags&SERVICE_RUN) && !conn->service->Wakeup()) {
					aLog(D_INFO, "waking up %s:%u service\n", conn->service->getName(), conn->service->instance);
				}
				conn->service=NULL;
			} else return_state=PARSE_EXIT;
	} else if (conn->service) {
		conn->service->ProcessCfg(param, conn, no_flag);
	} else {
		if (!strcasecmp(param[0], "?")) cHelp(conn, no_flag, "?");
		else if	(!strcasecmp(param[0], "save")) cSave(conn);
		else if (!strcasecmp(param[0], "show")) {
			if(!strcasecmp(param[1], "config")) 
				if (!strcasecmp(param[2], "?")) cHelp(conn, no_flag, "show config");
#ifdef HAVE_BILLING
				else if (!strcasecmp(param[2], "billing") && Billing ) sBiListCfg(Billing , conn->stream_w);
#endif			
				else { 
					if (!strcasecmp(param[2], "nopasswords")) cShowConfig(NULL, conn, 1);
					else cShowConfig(NULL, conn);
					}
			else if (!strcasecmp(param[1], "connections") || !strcasecmp(param[1], "conn")) cShowConnections(conn);
			else if (!strcasecmp(param[1], "?")) cHelp(conn, no_flag, "show");
			else if (!strcasecmp(param[1], "quota")) cShowQuota(conn, param);
			else if (!strcasecmp(param[1], "quotactl")) cShowQuotactl(conn, param);
			else if (!strcasecmp(param[1], "login")) cShowLogin(conn, param);
#ifdef HAVE_BILLING
			else if (!strcasecmp(param[1], "plan")) cShowBillingPlan(conn, param);
			else if (!strcasecmp(param[1], "account")) cShowBillingAccount(conn, param);
#endif			
			else if (!strcasecmp(param[1], "users")) cShowUsers(conn);
			else if (!strcasecmp(param[1], "schedule")) cShowScheduleList(conn);
			else if (!strcasecmp(param[1], "units")) cShowUnits(conn, param);
			else if (!strcasecmp(param[1], "processor")) cShowProcessor(conn);
			else if (!strcasecmp(param[1], "alerter")) cShowAlerter(conn);
			else if (!strcasecmp(param[1], "version")) cShowVersion(conn);
			else if (!strcasecmp(param[1], "timeout") || !strcasecmp(param[1], "timeouts")) cShowTimeouts(conn);
			else if (!strcasecmp(param[1], "list"))
				if (!strcasecmp(param[2], "full" )) cShowUnitsList(conn, 1, param[3], param[4]); 
				else if (!strcasecmp(param[2], "?")) cHelp(conn, no_flag, "show list");
				else cShowUnitsList(conn, 0, param[2], param[3]);
			else if (!strcasecmp(param[1], "policy")) cShowPolicy(conn);
			else if (!strcasecmp(param[1], "perf")) cShowPerf(conn, param);
			else if (!strcasecmp(param[1], "ds")) cShowDS(conn);
			else if (!strcasecmp(param[1], "monitor")) cShowMonitor(conn);
			else if (!strcasecmp(param[1], "memory") || !strcasecmp(param[1], "mem")) cShowMemory(conn);
			else if (!strcasecmp(param[1], "health")) cShowSystemHealth(conn);
		} //end of show
		else if (!strcasecmp(param[0], "service")) cService(conn, param, no_flag);
		else if (!strcasecmp(param[0], "debug")) cDebug(conn, param, no_flag);
		else if (!strcasecmp(param[0], "user")) return_state=cUser(conn, param, no_flag);
		else if (!strcasecmp(param[0], "schedule")) return_state=cTask(conn, param, no_flag);
		else if (!strcasecmp(param[0], "send")) cSend(conn, param);
		else if (!strcasecmp(param[0], "html")) cHtml(conn, param, no_flag);
		else if (!strcasecmp(param[0], "auth")) sWLProcessCfg(param, conn, no_flag); // dirty hack here
		else if (!strcasecmp(param[0], "oid")) if (!strcmp(param[1], "?")) cHelp(conn, no_flag, "oid"); else cNewOid(conn, param[1]);
  		else if (!strcasecmp(param[0], "kill")) if (!aCheckPerm(conn, UPERM_SYSACTION)) { aParse(conn, "%s will be killed without database save and NOT restarted\n", aaa_fw_software_name); return_state=PARSE_KILL; } else aParse(conn, "no permissions to do it!\n");
		else if (!strcasecmp(param[0], "reload")) if (!aCheckPerm(conn, UPERM_SYSACTION)) { aParse(conn, "%s will be re-loaded again with database save\n", aaa_fw_software_name); return_state=PARSE_RELOAD; } else aParse(conn, "no permissions to do it!\n");
		else if (!strcasecmp(param[0], "shutdown")) if (!aCheckPerm(conn, UPERM_SYSACTION)) { aParse(conn, "%s will be shutted down with database save and NOT restarted\n", aaa_fw_software_name); return_state=PARSE_SHUTDOWN; } else aParse(conn, "no permissions to do it!\n");

		else if (!strcasecmp(param[0], "mode")) { if (!strcasecmp(param[1], "human")) { conn->user->mode=USER_HUMAN; aParse(conn, "switching to human mode\n"); }
			else if (!strcasecmp(param[1], "data-source")) { conn->user->mode=USER_DATASOURCE; aDebugRm(conn->debug, "all"); aParse(conn, "switching to data-source mode\n"); }
			else if (!strcasecmp(param[1], "storage")) { conn->user->mode=USER_STORAGE; aDebugRm(conn->debug, "all"); aParse(conn, "switching to storage mode\n"); }
			else if (!strcasecmp(param[1], "?")) cHelp(conn, no_flag, "mode");
			else aParse(conn, "unknown user mode: %s\n", param[1]);
			}

		else if (!strcasecmp(param[0], "auth")) sWLProcessCfg(param, conn, no_flag);
		else if (!strcasecmp(param[0], "rotate")) cRotate(conn,param);
		else aParse(conn, "Unknown command: %s\n", param[0]);
 		}
EXIT:
	// free temp cmd copy and out
	aFree(cmd_before_split);
	for (i=0; i<MAX_PARAM; i++) if (param[i]!=empty) aFree(param[i]);
	return return_state;
	}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
// here is general command processing
// valid list is: save, exit, reload, shutdown, kill, debug, show connections, show config *
int cLoad(Connection *conn, char *filename) {
	char *buffer;
	FILE *file;
	unsigned num=0;
	
	file = fopen(filename, "rt");
	if (file==NULL) return -1;
	
	buffer=(char *)aMalloc(4*1024+1);
	while (!feof(file)){
		fgets(buffer, 4*1024, file);
		aCommand(conn, buffer);
		num++;
		bzero(buffer, 4*1024);
	}
	fclose(file);
	aFree(buffer);
	return num;
}

void cSave(Connection *conn){
	if (aCheckPerm(conn, UPERM_SYSACTION)) return;
	FILE *c;
	c=fopen(config_file_name, "wt");
	if (c==NULL) aLog(D_INFO, "config write failed: %s\n", strerror(errno));
	else {
		cShowConfig(c, NULL);
		fclose(c);
	}
}

void cShowConfig(FILE *f, Connection *conn, int nopasswords){
	FILE *out;
	if (f) out=f; else if (conn) out=conn->stream_w; else out=stderr;

	// first we will output service-independent lines
	time_t t=time(NULL);
	fprintf(out, "#%s version %d.%d.%d (build %d", aaa_fw_software_name, aaa_fw_major_version, aaa_fw_minor_version, aaa_fw_subversion, aaa_fw_build_version);
	if (aaa_fw_build_version_local) fprintf(out, ".%d", aaa_fw_build_version_local);
	fprintf(out, ") compiled by %s\n", aaa_fw_build_person);
	fprintf(out, "#configuration built %s#begin\n", ctime(&t));
	fprintf(out, "#global variables configuration\n");

	fprintf(out, "debug ");
	if (aDebugIsSet(cInternal->debug, DEBUG_NONE)) fprintf(out, "none\n");
	else if (aDebugIsSet(cInternal->debug, DEBUG_ALL)) fprintf(out, "all\n");
	else { 
		for (u_char i=1; i<63; i++) if (aDebugIsSet(cInternal->debug, i)) fprintf(out, "%s ", debug_list[i]);
		fprintf(out, "\n");
	}

 	Users.listUsersCfg(out, nopasswords);
	Sched.listTasksCfg(out);
	// then check if various services are registered and call config lines output for each of them
	fprintf(out, "\n#services configuration\n");

	fprintf(out, "\n");
	Services.listCfg(out, nopasswords);

	// end of output
	fprintf(out, "\n#end\n");
}

void cDebug(Connection *conn, char *param[], u_char no_flag){
	u_char internal=0, i=1;
	
	if (!strcasecmp(param[1], "?")) { cHelp(conn, no_flag, "debug"); return; }
	
	while (strcmp(param[i], empty) && !internal) {
		if (!strcmp(param[i+1], "internal")) internal=1; else internal=0;
		if (!no_flag) {
			if (aDebugAdd(conn->debug, param[i])) {
				aDebugAdd(cInternal->debug, param[i]);
				aParse(conn, "debugging on %s is turned on\n", param[i]);
			}
			else aParse(conn, "cannot debug on %s\n", param[i]);
		}
		else {
			if (aDebugRm(conn->debug, param[i])) {
				aDebugRm(cInternal->debug, param[i]);
				aParse(conn, "debugging on %s is turned off\n", param[i]);
			}
			else aParse(conn, "cannot un-debug on %s\n", param[i]);
		}
		i++;
	}
	#ifndef DEBUG
	aParse(conn, "If you want enable debug compile it with DEBUG flag\n");
	#endif
}	

void cRotate(Connection *conn, char *param[]) {
	
	if (!strcasecmp(param[1], "?")) { cHelp(conn, 0, "rotate"); return; }
	if (!strcasecmp(param[1], "monitor")) {
		u_char instance=strtol(param[2], NULL, 10);
		Service *s=Services.getService(SERVICE_MONITOR, instance);
		if(!s) {aParse(conn, "Service monitor:%u not exist.\n",instance); return;}
		Monitor_cfg *cfg=(Monitor_cfg*)s->cfg;
		if(cfg->to!=MON_FILE) {aParse(conn,"Service monitor:%u not monitoring to file\n",instance); return;}
		
		aParse(conn, "Rotating monitor file %s for service %s:%u\n", cfg->name,s->getName(),s->instance);
		aLog(D_INFO, "Rotating monitor file %s for service %s:%u\n", cfg->name,s->getName(),s->instance);
		cfg->to=MON_NONE;
		fclose(cfg->fd);
		char filename[64],mytime[32];
		time_t t;
		time(&t);
		strftime(mytime,32,"%Y-%m-%d_%H:%M",localtime(&t));
	 	sprintf(filename,"%s.%s",cfg->name,mytime);	
		rename(cfg->name,filename);
		cfg->fd=fopen(cfg->name, "at");
		cfg->to=MON_FILE;
		}
	else if (!strcasecmp(param[1], "log")) {
		if(!flag_log) {aParse(conn,"There is no log file"); return;}
		aParse(conn, "Rotating log file %s\n",path_to_log);
		aLog(D_INFO, "Rotating log file %s\n",path_to_log);

		flag_log=0;
		fclose(LOGFILE);
		char filename[64],mytime[32];
               	time_t t;
               	time(&t);
               	strftime(mytime,32,"%Y-%m-%d_%H:%M",localtime(&t));
               	sprintf(filename,"%s.%s",path_to_log,mytime);
               	rename(path_to_log,filename);
               	LOGFILE=fopen(path_to_log, "at");
		flag_log=1;
		}
	else 
		aParse(conn, "Can't rotate service %s\n",param[1]);
}
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

