/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: net_units.h,v 1.54.4.1 2005/03/22 09:03:53 jura Exp $ */

#define NETUNIT_TYPES_NUM	6

enum netunit_type { NETUNIT_UNKNOWN=0, NETUNIT_USER=1, NETUNIT_HOST=2, NETUNIT_CLUSTER=3, NETUNIT_NET=4, NETUNIT_GROUP=5 };
extern char *netunit_type_name[NETUNIT_TYPES_NUM];

//flags for netunit
#define NETUNIT_CHANGED		0x01	//unit is changed
#define NETUNIT_NLP		0x02	//no-local-pass 
#define NETUNIT_BROKEN_FW_MF	0x04	//fw check for this unit might be broken
#define NETUNIT_BROKEN_ACCT_MF	0x08	//acct check for this unit might be broken
#define NETUNIT_POLICY_TARGET	0x10	//this unit used as policy target

typedef struct DSList{
	unsigned short id;
	DSList *next;
	} DSList;

void DSListAdd(NetUnit *u, u_char *i, Connection *conn, char *param[], u_char no_flag);
/////////////////////////////////////////////////////////////////////////////////////
class NetUnit {
	public:
		oid id;
		char *name;
		char *email;
		char *password;

		netunit_type type;
		//this is for Units list
		NetUnit *next;
		
		//this is for Units hash
		NetUnit *link;

		NetUnit *parent;
		PdList *ap;
		PdList *fp;
		struct DSList *dsl_root;
		void *monitor;
		sLoginData *logindata;
		sQuotaData *quotadata;
		
		BW *bw;
#ifdef HAVE_BILLING
		Account *account;
#endif

		SysPolicy sys_policy; 
		oid sys_policy_perm;
		u_char flags;
		
		NetUnit(netunit_type t);
		~NetUnit();
		void setName(char *n);
		void setBw(char *n);
		void setDSList(unsigned short ds_id);
		void clearDSList(unsigned short ds_id=0);
		struct DSList *getDSList();
		u_char checkDSList(unsigned short ds_id); 
		match Check(IPFlowStat *flow);
		void unit2tree(IPTree *iptree,u_char flag); // flag=1 add 0 -remove
		void NetUnit::unit2trees(u_char flag); //add unit to all correspondign trees
		void SetSysPolicy(SysPolicy sp, u_char flag, time_t now=time(NULL)); // flag=1 add 0 -remove
};

/////////////////////////////////////////////////////////////////////////////////////
class NetUnit_host: public NetUnit {
	public:
		struct in_addr ip;
		NetUnit_host *next;
		NetUnit_host();
		match Check(IPFlowStat *flow);
		void unit2tree(IPTree *iptree,u_char flag);
};

class NetUnit_cluster: public NetUnit {
	private:
		unsigned references;
		pthread_mutex_t *lock;
	public:
		NetUnit_host *root;
		NetUnit_host *last;
		NetUnit_cluster();
		~NetUnit_cluster();
		void Add(struct in_addr ip);
		void Remove(struct in_addr ip);
		match Check(IPFlowStat *flow);
		void unit2tree(IPTree *iptree,u_char flag);
		friend int cShowUnits(Connection *conn);
		friend void sHtmlAction(Html_cfg *cfg);
		friend void sProcessorListCfg(Service *s, FILE *f, u_char nopasswords);
	};

class NetUnit_net: public NetUnit {
	public:
		struct in_addr ip;
		struct in_addr mask;
		u_char auto_units_id;
		NetUnit_net();
		match Check(IPFlowStat *flow);
		void unit2tree(IPTree *iptree,u_char flag);
	};

class NetUnit_group: public NetUnit {
	private:
		unsigned references;
	public:
		u_char level;

		NetUnit_group();
		match Check(IPFlowStat *flow);
	};

class NetUnit_user: public NetUnit {
        public:
                struct in_addr ip;
		char *real_name;
                NetUnit_user *next;
                NetUnit_user();
                match Check(IPFlowStat *flow);
		void unit2tree(IPTree *iptree,u_char flag);
        };

/////////////////////////////////////////////////////////////////////////////////////
class NetUnitsList {
	public:
		NetUnit *root;
		NetUnit *last;
		unsigned num_units;
		pthread_rwlock_t *rwlock;
		unsigned long tries_lock;
		unsigned long tries_lock_failed;
		
		#define UNITS_HASH_SIZE 	0x0FFF
		#define UNITS_HASH(oid) 	(oid % UNITS_HASH_SIZE)
		NetUnit **hash;

		NetUnitsList();
		~NetUnitsList();
		void Insert(NetUnit *unit);
		void Delete(NetUnit *unit);
		void Delete(oid id);
		void SortGroups();
		NetUnit *getUnit(char *name);
		NetUnit *getUnitById(oid id);
		NetUnit *getUnitByIP(in_addr_t s);
		void DeletePolicyElsewhere(Policy *p);
		friend int cShowUnits(Connection *conn);
		u_char setMon(oid id, void *value);
		void showMon(FILE *out, void *to, u_char action); //action: 1-for show, 0- for config
		void listPasswordsHtml(Connection *conn);
		};

// this using in quotactl service as unit representation
typedef struct qUlist {
        NetUnit *u;
        qUlist *next;
	u_char q_soft,q_viol;
        } qUlist;
// this using un datasource service as unit representation
typedef struct dsUlist {
	NetUnit *u;
	dsUlist *next;
	
	//this used to organize matched units in list
	//for 0-account, 1-forward check
	dsUlist *link[2]; 
	match mf[2];

	//bw data
	BWdata *bwd;
} dsUlist;

//this is using weblogin service as unit representation
typedef struct wlUlist {
        NetUnit *u;
        wlUlist *next;
        time_t open;
        time_t timeout;
        time_t inact;
} wlUlist;
/////////////////////////////////////////////////////////////////////////////////////
int cUnit(Connection *conn, char *param[], u_char no_flag);
int cShowUnits(Connection *conn, char *param[]);
int cShowUnitsList(Connection *conn, u_char isfull, char *p1, char *p2);
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
