/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: lib.c,v 1.9 2005/01/17 13:13:21 jura Exp $ */

#include "config.h"

//stuff for my_fw_*()
fd_set allsocks;
struct timeval fd_tv;

#ifdef SOLARIS
//////////////////////////////////////////////////////////////////////////////////////////
// obtained from FreeBSD: /usr/src/lib/libc/gen/daemon.c 
int
daemon(int nochdir, int noclose)
{
        int fd;

        switch (fork()) {
        case -1:
                return (-1);
        case 0:
                break;
        default:
                _exit(0);
        }

        if (setsid() == -1)
                return (-1);

        if (!nochdir)
                (void)chdir("/");

        if (!noclose && (fd = open("/dev/null", O_RDWR, 0)) != -1) {
                (void)dup2(fd, STDIN_FILENO);
                (void)dup2(fd, STDOUT_FILENO);
                (void)dup2(fd, STDERR_FILENO);
                if (fd > 2)
                        (void)close(fd);
        }
        return (0);
}

int vasprintf(char **ret, const char *format, va_list ap)
{
  va_list ap2;
  int len= 100;        /* First guess at the size */
  if ((*ret= (char *)malloc(len)) == NULL) return -1;
  while (1)
  {
      int nchar;
      va_copy(ap2, ap);
      nchar= vsnprintf(*ret, len, format, ap2);
      if (nchar > -1 && nchar < len) return nchar;
      if (nchar > len)
          len= nchar+1;
      else
          len*= 2;
      if ((*ret= (char *)realloc(*ret, len)) == NULL)
      {
	free(*ret);
	return -1;
  }
  }
}

//obtained from FreeBSD /usr/src/lib/libc/net/ether_addr.c
/*
 * Convert an ASCII representation of an ethernet address to
 * binary form.
 */
struct ether_addr *ether_aton(const char *a)
{
        int i;
        static struct ether_addr o;
        unsigned int o0, o1, o2, o3, o4, o5;

        i = sscanf(a, "%x:%x:%x:%x:%x:%x", &o0, &o1, &o2, &o3, &o4, &o5);

        if (i != 6)
                return (NULL);

        o.ether_addr_octet[0]=o0;
        o.ether_addr_octet[1]=o1;
        o.ether_addr_octet[2]=o2;
        o.ether_addr_octet[3]=o3;
        o.ether_addr_octet[4]=o4;
        o.ether_addr_octet[5]=o5;

        return ((struct ether_addr *)&o);
}

/*
 * Convert a binary representation of an ethernet address to
 * an ASCII string.
 */
char *ether_ntoa(const struct ether_addr *n)
{
        int i;
        static char a[18];

        i = sprintf(a, "%02x:%02x:%02x:%02x:%02x:%02x",
            n->ether_addr_octet[0], n->ether_addr_octet[1], n->ether_addr_octet[2],
            n->ether_addr_octet[3], n->ether_addr_octet[4], n->ether_addr_octet[5]);
        if (i < 17)
                return (NULL);
        return ((char *)&a);
}

//////////////////////////////////////////////////////////////////////////////////////////
#endif
// obtained from flow-tools
// Copyright (c) 2001 Mark Fullmer and The Ohio State University
/*
 * function: bigsockbuf
 *
 * There is no portable way to determine the max send and receive buffers
 * that can be set for a socket, so guess then decrement that guess by
 * 2K until the call succeeds.  If n > 1MB then the decrement by .5MB
 * instead.
 *
 * returns size or -1 for error
*/
int bigsockbuf(int fd, int dir, int size)
{
  int n, tries;

  /* initial size */
  n = size;
  tries = 0;

  while (n > 4096) {

    if (setsockopt(fd, SOL_SOCKET, dir, (char*)&n, sizeof (n)) < 0) {

      /* anything other than no buffers available is fatal */
      if (errno != ENOBUFS) {
        return -1;
      }

      /* try a smaller value */

      if (n > 1024*1024) /* most systems not > 256K bytes w/o tweaking */
        n -= 1024*1024;
      else
        n -= 2048;

      ++tries;

    } else {
      return n;
    }

  } /* while */

  /* no increase in buffer size */
  return 0;

} /* bigsockbuf */
//////////////////////////////////////////////////////////////////////////////////////////
