/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: iptree.h,v 1.16 2005/01/17 13:13:21 jura Exp $ */

typedef struct IPTree_node {
	IPTree_node *up;
	IPTree_node **next;
	void *ptr;
} IPTree_node;
/////////////////////////////////////////////////////////////////////////////////////
class IPTree {
	public:
		unsigned long nodes; //number of IPTree_node allocated
		unsigned long dlink; //number of *IPTree_node[256] allocated;
		unsigned long unodes; //number of dsUlist allocated
		IPTree_node *root;
		pthread_rwlock_t *rwlock;
		u_char instance;

		IPTree(u_char instance);
		~IPTree();
		void FreeTree(IPTree_node *node); //this organize locks
		void freetree(IPTree_node *node); //this makes recursion and real free
		u_char cleanup(IPTree_node *node);
		void add2node(IPTree_node *node,NetUnit *u,u_char flag);
		void addr2tree(unsigned addr,u_char mask,NetUnit *u,u_char flag);
		dsUlist *checktree(IPFlowStat *flow, u_char check);
		void showtree(IPTree_node *node,unsigned addr,u_char depth);
		
		void ACCT(IPFlowStat *flow);
};
/////////////////////////////////////////////////////////////////////////////////////
class PrefixTree {
        public:
		unsigned long nodes; //number of IPTree_node allocated
		unsigned long dlink; //number of *IPTree_node[256] allocated;
                IPTree_node *root;
		// we do not need lock here cause it's worked in PrefixFile class and locked here
                PrefixTree();
                ~PrefixTree();
                void freetree(IPTree_node *node); //this makes recursion and real free
                void prefix2tree(prefix *p);
                u_char checktree(unsigned addr);
};
/////////////////////////////////////////////////////////////////////////////////////

		
