/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: html.c,v 1.28.4.3 2005/03/17 19:24:36 anton Exp $ */

#include "netams.h"

char mon_name[][12]={ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
//////////////////////////////////////////////////////////////////////////////////////////
//this bad because refers to hidden variables *file and full_path[]
#define HTML_PUSHD(path)	{ file=&path[strlen(path)]; sprintf(file, "/"); file++;}
#define HTML_POPD()		{ file=prefix; }

void cShowBillingHtml(Html_cfg *cfg, Connection *conn);
void cShowBillingAccountsHtml(Html_cfg *cfg, Connection *conn, struct tm *tm);

Connection *sHOpenFile(Connection *conn, char *fullname);
int sHSafeMkdir(char *temp);
void sHPrintHeader(Connection *conn, char *title, char *back, char *logopath=NULL);
void sPrintFooter(Connection *conn, char *back);
void sHPrintUnits(Html_cfg *cfg, FILE *f);
void sHPrintUnitsRoot(Html_cfg *cfg, FILE *f, NetUnit *p);
void sHPrintUnitsTree(Html_cfg *cfg, FILE *f, NetUnit *p, u_char isadmintool=0);
void sHPrintUnitST(FILE *f, NetUnit *p);
void sHPrintTHeader(FILE *f);

void HtmlCalendarY(FILE *f, char *path, char *file, struct tm *tm, const char *yhref, const char *mhref);
void HtmlCalendarM(FILE *f, char *path, char *file, struct tm *tm, const char *href);
void HtmlCalendarD(FILE *f, char *path, char *file, struct tm *tm, const char *href);

void HtmlRedirect(char *path, char *href);
//////////////////////////////////////////////////////////////////////////////////////////
void sHtmlAction(Html_cfg *cfg){
	if (!cfg->path) { aLog(D_INFO, "cannot create pages because no html dir is set!\n"); return; }
	
	//prepare connection
	Connection *conn = cfg->conn;

	NetUnit *u;

	char *param[64]; for (int i=0; i<64; i++) param[i]=empty;
	struct stat sb;
	bzero(&sb, sizeof (struct stat));

	//=================================================================================
	u_char len=strlen(cfg->path);
	char path[512];  		// better change then to dynamic allocation with len [len+256];
	// we have trick here 
	// actually cfg->path is presetted - so we can store it permanently and work only via offset 
	// pointed by *file
	strncpy(path, cfg->path, len);
	char *prefix=&path[len];	//prefix from cfg->path to actual filename
	char *file;			//from here filename will be printed
	
	char tmp[256];

	struct tm tm;
	// first, calculate current year, month, day and hour
	{
		time_t current=time(NULL);
		localtime_r(&current, &tm);
	}
	
	//create path
	snprintf(prefix, 255, "/%04d/%02d/%02d/%02d", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	if (sHSafeMkdir(path)) return;
	HTML_PUSHD(path);
	
	aDebug(DEBUG_HTML, "Creation main data in %s\n", path);

	//=================================================================================
	// if this is the end of hour, generate hourly report
	snprintf(file, 255, "time.html");
	conn=sHOpenFile(conn, path); if (!conn) return;
	snprintf(tmp, 255, "Traffic information from %02d.%02d.%04d %02d:00 to %02d.%02d.%04d %02d:00", tm.tm_mday, tm.tm_mon+1, tm.tm_year+1900, tm.tm_hour, tm.tm_mday, tm.tm_mon+1, tm.tm_year+1900, tm.tm_hour+1);
	sHPrintHeader(conn, tmp, "index.html");
	fprintf(conn->stream_w, "<div style=\"margin-left : 5%%; align: right;\">\n");
	sHPrintUnits(cfg, conn->stream_w);
	fprintf(conn->stream_w, "</div> \n");
	sPrintFooter(conn, "index.html");

	//=================================================================================
	// create index file
	snprintf(file, 255, "index.html");
	conn=sHOpenFile(conn, path); if (!conn) return;
	sHPrintHeader(conn, "Runtime information page", "../../../../index.html");

	fprintf(conn->stream_w, "<h3>Time period-derived statistics for %02d %s</h3>\n \
		<div style=\"margin-left : 5%%;\"> \n", tm.tm_mday, mon_name[tm.tm_mon]);
	
	// year table
	HtmlCalendarY(conn->stream_w, path, file, &tm, "../../../../%04d", "../../../../%04d/%02d/index.html");
	
	// month table
	HtmlCalendarM(conn->stream_w, path, file, &tm, "../../%02d/index.html");

	// day table
	HtmlCalendarD(conn->stream_w, path, file, &tm, "../%02d/time.html");

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	fprintf(conn->stream_w, "<h3>Objects statistics</h3>\n \
		<div style=\"margin-left : 5%%;\"> \n");

	if (cfg->cpages==CPAGES_ALL || cfg->cpages==CPAGES_GROUPS || cfg->cpages==CPAGES_GROUPLIST) {
		fprintf(conn->stream_w, "<b>Groups:</b><br>\n");
		for (u=Units.root; u!=NULL; u=u->next) if (u->type==NETUNIT_GROUP && u->name) {
			int k=0;
			if (cfg->cpages==CPAGES_GROUPLIST) for (Html_grouplist_item *item=cfg->grouproot; item!=NULL; item=item->next) if (item->groupid==u->id) k=1;
			if ((cfg->cpages==CPAGES_GROUPLIST && k) || cfg->cpages!=CPAGES_GROUPLIST)
				fprintf(conn->stream_w, "<a href=\"../../../../clients/%s/index.html\">%s</a>\n", u->name, u->name);
		}
	}

	if (cfg->cpages==CPAGES_ALL || cfg->cpages==CPAGES_GROUPLIST) {
		fprintf(conn->stream_w, "<br><b>Units:</b><br>\n");
		for (u=Units.root; u!=NULL; u=u->next) if (u->type!=NETUNIT_GROUP && u->name) {
			int k=0;
			if (cfg->cpages==CPAGES_GROUPLIST && u->parent) for (Html_grouplist_item *item=cfg->grouproot; item!=NULL; item=item->next) if (item->groupid==u->parent->id) k=1;
			if ((cfg->cpages==CPAGES_GROUPLIST && k) || cfg->cpages!=CPAGES_GROUPLIST)
				fprintf(conn->stream_w, "<a href=\"../../../../clients/%s/index.html\">%s</a>\n", u->name, u->name);
		}
	}

	fprintf(conn->stream_w, "<br><br></div>\n");

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	fprintf(conn->stream_w, "<h3>System status</h3>\n<div style=\"margin-left : 5%%; \">\n");
	if (cShowSystemHealth(conn)) fprintf(conn->stream_w, "<br><font color=red><b>WARNING! Your system is in wrong state!</b></font>");
	fprintf(conn->stream_w, "</div>\n");

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	fprintf(conn->stream_w, "<h3>Software statistics</h3>\n \
		<div style=\"margin-left : 5%%;\"> \n\
		Output of <a href=\"software-version.html\">show version</a><br> \n");
	if(Quota) fprintf(conn->stream_w, "Current <a href=\"software-quota.html\">quota state</a><br> \n");
 	if(Login) fprintf(conn->stream_w, "Current <a href=\"software-login.html\">logins state</a><br> \n");
	fprintf(conn->stream_w,	"Current <a href=\"software-config.html\">configuration</a><br>");
#ifdef HAVE_BILLING
	if(Billing) fprintf(conn->stream_w, "Current <a href=\"software-billing.html\">billing status</a><br>\n");
#endif
	fprintf(conn->stream_w, "</div>\n");
	sPrintFooter(conn, NULL);

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create SW version
	snprintf(file, 255, "software-version.html");
	conn=sHOpenFile(conn, path); if (!conn) return;
	sHPrintHeader(conn, "Software version", "index.html");
	fprintf(conn->stream_w, "<pre>\n");
	cShowVersion(conn);
	fprintf(conn->stream_w, "</pre>\n");
	sPrintFooter(conn, "index.html");

	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create Quota state
	if(Quota) {
		snprintf(file, 255, "software-quota.html");
		conn=sHOpenFile(conn, path); if (!conn) return;
		sHPrintHeader(conn, "Quota control state", "index.html");
		fprintf(conn->stream_w, "<pre>\n");
		cShowQuota(conn, param);
		fprintf(conn->stream_w, "</pre>\n");
		sPrintFooter(conn, "index.html");
	}
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create Login state
	if(Login) {
		snprintf(file, 255, "software-login.html");
		conn=sHOpenFile(conn, path); if (!conn) return;
		sHPrintHeader(conn, "Login control state", "index.html");
		fprintf(conn->stream_w, "<pre>\n");
		cShowLogin(conn, param);
		fprintf(conn->stream_w, "</pre>\n");
		sPrintFooter(conn, "index.html");
	}
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create SW log
	snprintf(file, 255, "software-config.html");
	conn=sHOpenFile(conn, path); if (!conn) return;
	sHPrintHeader(conn, "Running configuration", "index.html");
	fprintf(conn->stream_w, "<pre>\n");
	cShowConfig(NULL, conn, 1);
	fprintf(conn->stream_w, "</pre>\n");
	sPrintFooter(conn, "index.html");

#ifdef HAVE_BILLING
	//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// create billing log
	if(Billing) {
		snprintf(file, 255, "software-billing.html");
		conn=sHOpenFile(conn, path); if (!conn) return;
		sHPrintHeader(conn, "Billing service state", "index.html");
		cShowBillingHtml(cfg, conn);
		sPrintFooter(conn, "index.html");
		if (cfg->apages==APAGES_ALL) cShowBillingAccountsHtml(cfg, conn, &tm);
	}
#endif
	HTML_POPD(); 

	//=================================================================================
	// generate month index page
	snprintf(prefix, 255, "/%04d/%02d", tm.tm_year+1900, tm.tm_mon+1);
	HTML_PUSHD(path);

	snprintf(file, 255, "index.html");
	conn=sHOpenFile(conn, path); if (!conn) return;
	sHPrintHeader(conn, "Runtime information page", "../../index.html", "../..");

	fprintf(conn->stream_w, "<h3>Index pages for month: %s</h3>\n <div style=\"margin-left : 5%%;\"> \n", mon_name[tm.tm_mon]);
	
	// year table
	HtmlCalendarY(conn->stream_w, path, file, &tm, "../../%04d", "../../%04d/%02d/index.html");

	// month table
	file[0]=0;
	HtmlCalendarM(conn->stream_w, path, file, &tm, "%02d/index.html");
	
	fprintf(conn->stream_w, "<br></div><br>\n");
	sPrintFooter(conn, "../../index.html");
	
	//change file and cleanup
	HTML_POPD();

	//=================================================================================
	// create a master index file at path root, pointing to the current file
	snprintf(file, 255, "/index.html");
	snprintf(tmp, 255, "%04d/%02d/%02d/%02d/index.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday, tm.tm_hour);
	HtmlRedirect(path, tmp);

	//=================================================================================
	// generate day index redirect page
	snprintf(file, 255, "/%04d/%02d/%02d/index.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday);
	snprintf(tmp, 255, "%02d/index.html", tm.tm_hour);
	HtmlRedirect(path, tmp);

	//=================================================================================
	// generate per-client pages
	aDebug(DEBUG_HTML, "Generate clients pages\n");

	if (cfg->cpages!=CPAGES_NONE) for (u=Units.root; u!=NULL; u=u->next) {
		if (u->name == NULL) continue;

		if (!(cfg->cpages==CPAGES_ALL || cfg->cpages==CPAGES_GROUPLIST ||
			(cfg->cpages==CPAGES_GROUPS && u->type==NETUNIT_GROUP))) continue;	 // CPAGES_CHECK

		if (cfg->cpages==CPAGES_GROUPLIST) {
			if (!u->parent && u->type!=NETUNIT_GROUP) continue;
			if (u->type==NETUNIT_GROUP) {
				int k=0;
				for (Html_grouplist_item *item=cfg->grouproot; item!=NULL; item=item->next) if (item->groupid==u->id) k=1;
				if (k==0) continue; // skip this group as it is not belongs to group listed in GROUPLIST			
			}
			if (u->parent && u->type!=NETUNIT_GROUP) {
				int k=0;
				for (Html_grouplist_item *item=cfg->grouproot; item!=NULL; item=item->next) if (item->groupid==u->parent->id) k=1;
				if (k==0) continue; // skip this unit as it is not belongs to group listed in GROUPLIST			
			}
		}

		//create path
		snprintf(prefix, 255, "/clients/%s/%04d/%02d", u->name, tm.tm_year+1900, tm.tm_mon+1);
		if (sHSafeMkdir(path)) return;
		HTML_PUSHD(path);
		aDebug(DEBUG_HTML, "Creation client %s pages in %s\n", u->name, path);


		snprintf(file, 255, "index-day-%02d.html", tm.tm_mday);
		conn=sHOpenFile(conn, path); if (!conn) return;
		sHPrintHeader(conn, "Traffic information for selected unit", "../../index.html");

		switch (u->type) {
			case NETUNIT_HOST: {
				NetUnit_host *h;
				h = (NetUnit_host*)u;
				fprintf(conn->stream_w, "HOST: <b>%s</b><br>OID: <b>%06X</b><br> IP: <b>%-12s</b><br>\n", h->name, h->id, inet_ntoa(h->ip));
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_USER: {
				NetUnit_user *h;
				h = (NetUnit_user*)u;
				fprintf(conn->stream_w, "USER: <b>%s</b><br>OID: <b>%06X</b><br> IP: <b>%-12s</b><br>\n", h->name, h->id, inet_ntoa(h->ip));
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_CLUSTER: {
				NetUnit_cluster *h;
				NetUnit_host *t;
				h = (NetUnit_cluster*)u;
				fprintf(conn->stream_w, "CLUSTER: <b>%s</b><br>OID: <b>%06X</b><br>IPs:<b>\n", h->name, h->id);
				for (t=h->root; t!=NULL; t=t->next)	fprintf(conn->stream_w, "%s ", inet_ntoa(t->ip));
				fprintf(conn->stream_w, "</b><br>\n");
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_GROUP: {
				NetUnit_group *h;
				NetUnit *t;
				h = (NetUnit_group*)u;
				fprintf(conn->stream_w, "GROUP: <b>%s</b><br>OID: <b>%06X</b><br>Subs: <b>", h->name, h->id);
				for (t=Units.root; t!=NULL; t=t->next)	if (t->parent==u && t->name) {
					if (cfg->cpages==CPAGES_ALL || cfg->cpages==CPAGES_GROUPLIST) fprintf(conn->stream_w, "<a href=\"../../../%s/index.html\">%s</a> ", t->name, t->name);
					else fprintf(conn->stream_w, "%s ", t->name);
				}
				fprintf(conn->stream_w, "</b><br>\n");
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			case NETUNIT_NET: {
				NetUnit_net *h;
				h = (NetUnit_net*)u;
				fprintf(conn->stream_w, "NET: <b>%s</b><br>OID: <b>%06X</b><br>NETWORK: <b>%s</b>\n", h->name, h->id, inet_ntoa(h->ip));
				fprintf(conn->stream_w, " NET_MASK: <b>%s</b><br>\n", inet_ntoa(h->mask));
				if (u->parent && u->parent->name) fprintf(conn->stream_w, "PARENT: <b><a href=\"../../../%s/index.html\">%10s</a></b><br>\n", u->parent->name, u->parent->name);
				} break;
			default:
				fprintf(conn->stream_w, "<UNKNOWN><br> OID: <b>%06X</b>\n", u->id);
				break;
		}

		//++++++++++++++++++++++++++++++++++++++++++
		// year/month table (client)
		fprintf(conn->stream_w, "<br><b>Calendar:</b><br>");
		HtmlCalendarY(conn->stream_w, path, file, &tm, "../../%04d", "../../%04d/%02d/index.html");

		// month table (client)
		HtmlCalendarM(conn->stream_w, path, file, &tm, "index-day-%02d.html");
		//+++++++++++++++++++++++++++++++++++++++++

		fprintf(conn->stream_w, "<h3>Generalized statistics for %s, actual for creation time ONLY!</h3>\n <div style=\"margin-left : 5%%;\"> \n", u->name);

		if (u->type!=NETUNIT_GROUP) sHPrintTHeader(conn->stream_w);
		sHPrintUnitsTree(cfg, conn->stream_w, u);
		if (u->type!=NETUNIT_GROUP) fprintf(conn->stream_w, "</table><br>\n");

		fprintf(conn->stream_w, "</div><br>");

		sPrintFooter(conn, "../../index.html");
		
		// generate month index page
		snprintf(file, 255, "index.html");
		conn=sHOpenFile(conn, path); if (!conn) return;
		sHPrintHeader(conn, "Runtime information page", "../../index.html");

		fprintf(conn->stream_w, "<h3>Index pages for month: %s</h3>\n <div style=\"margin-left : 5%%;\"> \n", mon_name[tm.tm_mon]);

		// days table
		HtmlCalendarM(conn->stream_w, path, file, &tm, "index-day-%02d.html");

		fprintf(conn->stream_w, "<br></div><br>\n");
		sPrintFooter(conn, "../../index.html");
		
		//cleanup and  restore *file
		HTML_POPD();

		// create a master index file at client root, pointing to the current file
                snprintf(file, 255, "/clients/%s/index.html", u->name);
                snprintf(tmp, 255, "%04d/%02d/index-day-%02d.html", tm.tm_year+1900, tm.tm_mon+1, tm.tm_mday);
                HtmlRedirect(path, tmp);

		if (cfg->is_htaccess && u->flags&NETUNIT_CHANGED) {
			if (u->password) {
				snprintf(file, 255, "/clients/%s/.htaccess", u->name);
				conn=sHOpenFile(conn, path); if (!conn) return;
				fprintf(conn->stream_w, "AuthName \"NeTAMS User Login\"\n Require user");
				Users.listUsersHtml(conn);
				fprintf(conn->stream_w, " %s\n<Files *.gif>\nRequire valid-user\nSatisfy Any\n</Files>\nAuthType Basic\nAuthUserFile %s/.htpasswd\n\n", u->name, cfg->path);
				u->flags&=~NETUNIT_CHANGED;
			}
		}
	} // 'for' loop, all clients

	//=================================================================================
	// if htaccess==1 AND UserList changed flag is set, generate new .htaccess and .htpasswd
	if (cfg->is_htaccess) {
		if (Users.changed_user) {
			snprintf(file, 255, "/.htaccess");
			conn=sHOpenFile(conn, path); if (!conn) return;
			fprintf(conn->stream_w, "AuthName \"NeTAMS Administrators Only\"\n Require user");
			Users.listUsersHtml(conn);
			fprintf(conn->stream_w, "\n<Files *.gif>\nRequire valid-user\nSatisfy Any\n</Files>\nAuthType Basic\nAuthUserFile %s/.htpasswd\n\n", cfg->path);
			Users.changed_user=0;
		}

		if (Users.changed_pw) {
			snprintf(file, 255, "/.htpasswd");
			conn=sHOpenFile(conn, path); if (!conn) return;
			Users.listPasswordsHtml(conn);
			Units.listPasswordsHtml(conn);
		}
	}
	//=================================================================================
	//clear connection
	if(conn->stream_w) { fclose(conn->stream_w); conn->stream_w=NULL; }
}
//////////////////////////////////////////////////////////////////////////////////////////
Connection *sHOpenFile(Connection *conn, char *name){
	int f;
	
	if(conn->stream_w) { fclose(conn->stream_w); conn->stream_w=NULL; }

	f=open(name, O_RDWR|O_CREAT|O_TRUNC, 0644);
	if(f==-1) {
		aLog(D_WARN, "Can't create file %s : %s\n", name, strerror(errno));
		return NULL;
	}
	aDebug(DEBUG_HTML, "%s : %s\n", name, (f+1)?"ok":"fail");
	conn->stream_w=fdopen(f, "w");
	return conn;
}
//////////////////////////////////////////////////////////////////////////////////////////
int sHSafeMkdir(char *temp){  // this equal to  mkdir -p 
	struct stat sb;
	bzero(&sb, sizeof (struct stat));
	
	int i=stat(temp, &sb);
	if (!(sb.st_mode & S_IFDIR) || i) {
		i=mkdir(temp, 0711);
		if (i) {
			i=(strrchr(temp, '/')-temp);
			if(i>0) {
				char *prefix=(char*)aMalloc(i+1);
				strncpy(prefix, temp, i);     //find prefix
	
				i=sHSafeMkdir(prefix);		//recurse
				aFree(prefix);
			
				if(i) return -1;		//if error on previous level no need to continue

				i=mkdir(temp, 0711);		//there is no error, retry to create
			} else  i=-1;	//ensure this is error

			if(i) {
				aLog(D_INFO, "failed to create %s: %s \n", temp, strerror(errno));
				return -1;
			}
		}
		aDebug(DEBUG_HTML, "make directory %s\n", temp);
	} else if (!(sb.st_mode & S_IFDIR)) {
		aLog(D_INFO, "failed to create %s, file already exist and not directory\n", temp);
		return -1;
	}
	return 0;
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintHeader(Connection *conn, char *title, char *back, char *logopath){

	fprintf(conn->stream_w, "<html><head><title>NeTAMS - %s</title><META http-equiv=\"Pragma\" content=\"no-cache\"><META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\"></HEAD> \n\
		<body bgcolor=white marginheight=0 leftmargin=0 topmargin=0 marginwidth=0> \n\
		<table width=100%% align=left border=0 cellpadding=5 cellspacing=0> \n\
		<tr bgcolor='white' align=left><td width=359> \n\
		<A href=\"http://www.netams.com/index.html\"> \n\
		<img src=\"%s/images/logo-small.gif\" width=359 height=49 border=0></a></td> \n\
		<td valign=middle align=left width=80%%> This is automatically built \n\
		<a href=\"http://www.netams.com/index.html\"><b>NeTAMS</b></a> \n\
		report<br> <b>Software version:</b>", title, logopath?logopath:"../../../..");
	fprintf(conn->stream_w, "%d.%d.%d (build %d", aaa_fw_major_version, aaa_fw_minor_version, aaa_fw_subversion, aaa_fw_build_version);
	if (aaa_fw_build_version_local) fprintf(conn->stream_w, ".%d", aaa_fw_build_version_local);
	fprintf(conn->stream_w, ")<br>\n");

	char buff[32];
	fprintf(conn->stream_w, "<b>Creation time:</b> %s<br> </td></tr> <tr bgcolor='#ccccff'><td colspan=2> \n\
		<h3>%s", timeU2T(time(NULL), buff), title);
	if (back) fprintf(conn->stream_w, "<font face=monospace size=-1><b> [<a href=\"%s\"> <- back</a> ]</b></font>", back);
	fprintf(conn->stream_w, "</h3></td></tr><tr><td colspan=2>\n");
}
//////////////////////////////////////////////////////////////////////////////////////////
void sPrintFooter(Connection *conn, char *back){
	fprintf(conn->stream_w, "</td></tr>\n");
	if (back) fprintf(conn->stream_w, "<tr bgcolor='#ccccff'><td colspan=2><font face=monospace size=-1><b>[<a href=\"%s\"> <- back</a> ]</b></font></td></tr>", back);
	fprintf(conn->stream_w, "</table>\n</body></html> \n");
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnits(Html_cfg *cfg, FILE *f){

	Units.tries_lock++;
	int err=pthread_rwlock_tryrdlock(Units.rwlock);
	if (err==EBUSY) { Units.tries_lock_failed++; pthread_rwlock_rdlock(Units.rwlock); }

	sHPrintUnitsRoot(cfg, f, NULL);

	if (err!=EDEADLK) pthread_rwlock_unlock(Units.rwlock);
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnitsRoot(Html_cfg *cfg, FILE *f, NetUnit *p){
	NetUnit *u;

	for (u=Units.root; u!=NULL; u=u->next)
		if (u->parent==p && u->type==NETUNIT_GROUP) sHPrintUnitsTree(cfg, f, u, 1);

	sHPrintTHeader(f);
	
	for (u=Units.root; u!=NULL; u=u->next)
		if (u->parent==p && u->type!=NETUNIT_GROUP) sHPrintUnitsTree(cfg, f, u, 1);
    
	fprintf(f, "</table><br>\n");
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnitsTree(Html_cfg *cfg, FILE *f, NetUnit *u, u_char isadmintool){

	if (u->type==NETUNIT_GROUP) {
		sHPrintTHeader(f);
		fprintf(f, "<tr bgcolor='#000000'><td colspan=11 height=2> </td></tr><tr bgcolor='#ffffcc'><td colspan=11>GROUP: <b>%s</b> <font size=-1>oid %06X</font>", u->name?u->name:"", u->id);
		fprintf(f, "</td></tr>\n");
		sHPrintUnitST(f, u);
		fprintf(f, "<tr bgcolor='#ccffcc'><td colspan=11 align=right>\n");

		sHPrintUnitsRoot(cfg, f, u);

		fprintf(f, "</td></tr>\n");
		fprintf(f, "</table><br>\n");
    	} else {
		if (isadmintool) fprintf(f, "<tr bgcolor='#ffffcc'><td colspan=11><A href=\"../../../../admintool.cgi?oid=%06X\"><img src=\"../../../../images/admintool-logo.gif\" width=20 height=20 border=1 align=absmiddle></a> ", u->id);
		else fprintf(f, "<tr bgcolor='#ffffcc'><td colspan=11>");

		if (u->type==NETUNIT_HOST) fprintf(f, "HOST");
		else if (u->type==NETUNIT_USER) fprintf(f, "USER");
		else if (u->type==NETUNIT_NET) fprintf(f, "NET");
		else fprintf(f, "CLUSTER");
		fprintf(f, " <b>%s</b> <font size=-1>oid %06X</font>", u->name?u->name:"", u->id);

		if (u->type==NETUNIT_HOST) fprintf(f, " IP: <i>%-12s</i>", inet_ntoa(((NetUnit_host*)u)->ip));
		else if (u->type==NETUNIT_USER) fprintf(f, " IP: <i>%-12s</i>", inet_ntoa(((NetUnit_user*)u)->ip));
		else if (u->type==NETUNIT_NET) {
			fprintf(f, " IP: <i>%-12s</i>", inet_ntoa(((NetUnit_net*)u)->ip));
			fprintf(f, " MASK: <i>%-12s</i>", inet_ntoa(((NetUnit_net*)u)->mask));
		}
		if (isadmintool && cfg && u->ap && cfg->servlet_url) { 
			policy_data *cpd; char *p=NULL;  
			time_t now=time(NULL);
			pthread_rwlock_rdlock(u->ap->rwlock);
			for (cpd=u->ap->root; cpd!=NULL; cpd=cpd->next) print_to_string(&p, "%d:", cpd->policy->id);
			pthread_rwlock_unlock(u->ap->rwlock);
			if (p) fprintf(f, "&nbsp;<A href=\"%s/NetamsView/netams?action=table&unit_oid=%d&policies_oids=%s&time_from=%ld000&time_to=%ld000&timespan=M\"><img src=\"../../../../images/showtable-logo.gif\" width=20 height=20 border=1 align=absmiddle></a>", cfg->servlet_url, u->id, p, now, now);
			aFree(p);
			}
  		fprintf(f, "</td></tr>\n\n");
		sHPrintUnitST(f, u);
	}
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintUnitST(FILE *f, NetUnit *u){
	if(!u->ap) return; //nothing to do
	policy_data *cpd;
	static char b2qt[8][32];

	pthread_rwlock_rdlock(u->ap->rwlock);
	for (cpd=u->ap->root; cpd!=NULL; cpd=cpd->next) {
		fprintf(f, "<tr align=right><td valign=middle bgcolor='#ffffaa'>%s</td>\n", cpd->policy->name?cpd->policy->name:"<\?\?>");
		fprintf(f, "<td>%10s</td><td>%10s</td>", bytesQ2T(cpd->h.in, b2qt[0]), bytesQ2T(cpd->h.out, b2qt[1]));
		fprintf(f, "<td>%10s</td><td>%10s</td>", bytesQ2T(cpd->d.in, b2qt[2]), bytesQ2T(cpd->d.out, b2qt[3]));
		fprintf(f, "<td>%10s</td><td>%10s</td>", bytesQ2T(cpd->w.in, b2qt[4]), bytesQ2T(cpd->w.out, b2qt[5]));
		fprintf(f, "<td>%10s</td><td>%10s</td></tr>\n", bytesQ2T(cpd->m.in, b2qt[6]), bytesQ2T(cpd->m.out, b2qt[7]));
	}
	pthread_rwlock_unlock(u->ap->rwlock);
}
//////////////////////////////////////////////////////////////////////////////////////////
void sHPrintTHeader(FILE *f){

	fprintf(f, "<table cellpadding=3 cellspacing=0 border=1 width=95%% bgcolor=white>\n");
	fprintf(f, "<tr bgcolor=navy align=center><td rowspan=2 valign=middle><font face=monospace size=-1 color=yellow>acct-policy</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>HOUR</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>DAY</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>WEEK</font></td> \
		<td colspan=2><font face=monospace size=-1 color=yellow>MONTH</font></td> \
		</tr><tr bgcolor=black align=center> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		<td><font color=white size=-1> in</font></td><td><font color=white size=-1>out</font></td> \
		</tr>\n");
}
//////////////////////////////////////////////////////////////////////////////////////////
void HtmlCalendarY(FILE *f, char *path, char *file, struct tm *tm, const char *yhref, const char *mhref) {
	struct stat sb; bzero(&sb, sizeof (struct stat));
	
	// years table
	fprintf(f, "<table border=1 cellpadding=3 cellspacing=0> \n");
	for (u_short yr=2000; yr<=tm->tm_year+1900; yr++) {
		snprintf(file, 255, yhref, yr);
		if (!stat(path, &sb)) {
			fprintf(f, "<tr><td bgcolor=silver><b>%d</b></td>\n", yr);
			for (int mon=1; mon<=12; mon++) {
				snprintf(file, 255, mhref, yr, mon);
				if (!stat(path, &sb)) {
					fprintf(f, "<td><a href=\"");
					fprintf(f, mhref, yr, mon);
					fprintf(f, "\">%s</a></td>", mon_name[mon-1]);
				} else
					fprintf(f, "<td>%s</td>", mon_name[mon-1]);
			}
			fprintf(f, "</tr>\n");
		}
	}
	fprintf(f, "</table>\n");
}

void HtmlCalendarM(FILE *f, char *path, char *file, struct tm *tm, const char *href) {
	struct stat sb; bzero(&sb, sizeof (struct stat));

	// month table
	fprintf(f, "<b>This month:</b><br>\n");
	for (u_char day=1; day<=31; day++){
		snprintf(file, 255, href, day);
		if (!stat(path, &sb)) {
			fprintf(f, "<a href=\"");
			fprintf(f, href, day);
			fprintf(f, "\">%d</a> ", day);
		} else
			fprintf(f, "%d ", day);
	}
	fprintf(f, "<br>\n");
}

void HtmlCalendarD(FILE *f, char *path, char *file, struct tm *tm, const char *href) {
	struct stat sb; bzero(&sb, sizeof (struct stat));

	// day table
	fprintf(f, "<b>This day:</b><br>\n");
	for (u_char hour=0; hour<=11; hour++){
		snprintf(file, 255, href, hour);
		if (!stat(path, &sb)) {
			fprintf(f, "<a href=\"");
			fprintf(f, href, hour);
			fprintf(f, "\">%02d-%02d</a> ", hour, hour+1);
		} else
			fprintf(f, "%02d-%02d ", hour, hour+1);
	}
	
	fprintf(f, "<br>\n");
	
	for (u_char hour=12; hour<=23; hour++){
		snprintf(file, 255, href, hour);
		if (!stat(path, &sb)) {
			fprintf(f, "<a href=\"");
			fprintf(f, href, hour);
			fprintf(f, "\">%02d-%02d</a> ", hour, hour+1);
		} else
			fprintf(f, "%02d-%02d ", hour, hour+1);
	}
	fprintf(f, "<br></div>\n");
}
//////////////////////////////////////////////////////////////////////////////////////////
void HtmlRedirect(char *path, char *href) {
	FILE *f=fopen(path, "w");
        
	if(!f) {
		aLog(D_WARN, "Can't create file %s : %s\n", path, strerror(errno));
		return;
	}

	fprintf(f, "<html><HEAD><META http-equiv=\"Pragma\" content=\"no-cache\"><META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\"></HEAD><body><h1>Redirecting to this day index...</h1><script> \
		document.location.href=\"%s\"</script></body></html>\n", href);
	
	fclose(f);
}
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
#ifdef HAVE_BILLING

void cShowBillingHtml(Html_cfg *cfg, Connection *conn){
	Service *s=Billing;
	if(!s) return;

	Account *ac;
//	Account *acx=NULL;
//	int isfull=0;
	char *blocked, *bcolor;

	fprintf(conn->stream_w, "<table cellpadding=3 cellspacing=0 border=1 width=95%% bgcolor=white>\n");
	fprintf(conn->stream_w, "<tr bgcolor=navy align=center><td valign=middle><font face=monospace size=-1 color=yellow>Account name</font></td> \
		<td><font face=monospace size=-1 color=yellow>Balance</font></td> \
		<td><font face=monospace size=-1 color=yellow>Status</font></td> \
		<td><font face=monospace size=-1 color=yellow>Plan</font></td> \
		<td><font face=monospace size=-1 color=yellow>Units</font></td></tr>\n");
	 
	for (ac=bAccounts->root; ac!=NULL; ac=ac->next){
		if (ac->status&ACCOUNT_DELETED) continue; //this account deleted
		if(ac->status&ACCOUNT_BLOCKED ) { blocked="BLOCKED"; bcolor="pink"; }
		else if (ac->status&ACCOUNT_BEBLOCKED) { blocked="BEBLOCKED"; bcolor="#ffffe0"; }
		else { blocked="UNBLOCKED"; bcolor="white"; }

		fprintf(conn->stream_w, "<tr><td><a href=\"../../../../accounts/%s/index.html\">%s</a></td><td align=center bgcolor=%s>%.4f</td><td align=center bgcolor=%s>%s</td><td>%s</td><td>&nbsp;", ac->name, ac->name, ac->balance>0?"white":"#ffffe0", ac->balance, bcolor, blocked, ac->plan?(ac->plan->name?ac->plan->name:"<\?\?>"):"-");
		for (bUlist *bu=ac->bUroot; bu!=NULL; bu=bu->next) {
			NetUnit *u=bu->u;
			if(cfg->cpages==CPAGES_ALL) 
				fprintf(conn->stream_w, "<a href=\"../../../../clients/%s/index.html\">%s</a> ", u->name?u->name:"<\?\?>", u->name?u->name:"-");
			else 
				fprintf(conn->stream_w, "%s", u->name?u->name:"<\?\?>");
		}
		fprintf(conn->stream_w, "</td></tr>\n");
	} // for
	fprintf(conn->stream_w, "</table>\n");
}
//////////////////////////////////////////////////////////////////////////////////////////
void cShowBillingAccountsHtml(Html_cfg *cfg, Connection *conn, struct tm *tm){
	Service *s=Billing;
	if(!s) return;
	ServiceStorage_cfg *st = (ServiceStorage_cfg*)((Billing_cfg*)s->cfg)->st->cfg;

	Account *ac;
	struct stat sb; bzero(&sb, sizeof (struct stat));
	char *blocked, *bcolor;

	u_char len=strlen(cfg->path);
	char path[512];			// better change then to dynamic allocation with len [len+256];
	strncpy(path, cfg->path, len);
	char *prefix=&path[len];        //prefix from cfg->path to actual filename
	char *file;                     //from here filename will be printed
	char tmp[256];

	for (ac=bAccounts->root; ac!=NULL; ac=ac->next){
		if (ac->status&ACCOUNT_DELETED) continue; //this account deleted
		if(ac->status&ACCOUNT_BLOCKED ) { blocked="BLOCKED"; bcolor="pink"; }
		else if (ac->status&ACCOUNT_BEBLOCKED) { blocked="BEBLOCKED"; bcolor="#ffffe0"; }
		else { blocked="UNBLOCKED"; bcolor="white"; }
		
		//create path
	
		snprintf(prefix, 255, "/accounts/%s/%04d/%02d", ac->name, tm->tm_year+1900, tm->tm_mon+1);
		if (sHSafeMkdir(path)) return;
		HTML_PUSHD(path);
		aDebug(DEBUG_HTML, "Creation account %s pages in %s\n", ac->name, path);

		// account current page
		snprintf(file, 255, "index-day-%02d.html", tm->tm_mday);
		conn=sHOpenFile(conn, path); if (!conn) return;
		sHPrintHeader(conn, "Balance for selected account", "../../index.html");

		fprintf(conn->stream_w, "<b>Acount name:</b> %s<br>\n", ac->name);
		fprintf(conn->stream_w, "<b>Balance:</b> %.4f (<small>actual for the date shown above</small>)<br>\n", ac->balance);
		fprintf(conn->stream_w, "<b>Status:</b> <font style=\"background-color:%s\";>&nbsp;%s&nbsp;</font><br>\n", bcolor, blocked);
		fprintf(conn->stream_w, "<b>Plan:</b> %s<br>\n", ac->plan?(ac->plan->name?ac->plan->name:"<\?\?>"):"-");

		//++++++++++++++++++++++++++++++++++++++++++
		// year/month table (account)
		fprintf(conn->stream_w, "<br><b>Calendar:</b><br>");
		HtmlCalendarY(conn->stream_w, path, file, tm, "../../%04d", "../../%04d/%02d/index.html");

		// days table (account)
		HtmlCalendarM(conn->stream_w, path, file, tm, "index-day-%02d.html");
		//+++++++++++++++++++++++++++++++++++++++++

		fprintf(conn->stream_w, "<h3>Generalized statistics for %s, actual for creation time ONLY!</h3>\n <div style=\"margin-left : 5%%;\"> \n", ac->name);

		sHPrintTHeader(conn->stream_w);
		for (bUlist *bu=ac->bUroot; bu!=NULL; bu=bu->next) {
			sHPrintUnitsTree(cfg, conn->stream_w, bu->u);
		}

		fprintf(conn->stream_w, "</table></div><br>");
		sPrintFooter(conn, "../../index.html");
		
		snprintf(file, 255, "index.html");
		conn=sHOpenFile(conn, path); if (!conn) return;
		sHPrintHeader(conn, "Runtime information page", "../../index.html");

		fprintf(conn->stream_w, "<h3>Index pages for month: %s</h3>\n <div style=\"margin-left : 5%%;\"> \n", mon_name[tm->tm_mon]);

		// days table
		HtmlCalendarD(conn->stream_w, path, file, tm, "index-day-%02d.html");

		fprintf(conn->stream_w, "<br></div><br>\n");
		sPrintFooter(conn, "../../index.html");
		
		//change file and cleanup
		HTML_POPD();
		
		// create a master index file at account root, pointing to the current file
		snprintf(file, 255, "/accounts/%s/index.html", ac->name);
		snprintf(tmp, 255, "%04d/%02d/index-day-%02d.html", tm->tm_year+1900, tm->tm_mon+1, tm->tm_mday);
		HtmlRedirect(path, tmp);

		// check if .htaccess file should be created or changed
		snprintf(file, 255, "/accounts/%s/.htaccess", ac->name);
		if (cfg->is_htaccess && stat(path, &sb)) {
			snprintf(file, 255, "/accounts/%s/.htaccess", ac->name);
			conn=sHOpenFile(conn, path); if (!conn) return;
			fprintf(conn->stream_w, "AuthName \"NeTAMS Account Login\"\n Require user");
			Users.listUsersHtml(conn);
			fprintf(conn->stream_w, " %s\n<Files *.gif>\nRequire valid-user\nSatisfy Any\n</Files>\nAuthType Basic\n\n", ac->name);
			fprintf(conn->stream_w, "Auth_MYSQL on\n");
			fprintf(conn->stream_w, "Auth_MySQL_Username             %s\n", st->username?st->username:"root");
			if (st->password) fprintf(conn->stream_w, "Auth_MySQL_Password             %s\n", st->password);
			fprintf(conn->stream_w, "Auth_MySQL_DB                   %s\n", st->dbname?st->dbname:"netams");
			fprintf(conn->stream_w, "Auth_MySQL_Password_Table       billing\n");
			fprintf(conn->stream_w, "Auth_MySQL_Username_Field       name\n");
			fprintf(conn->stream_w, "Auth_MySQL_Password_Field       passwd\n");
			fprintf(conn->stream_w, "Auth_MySQL_Empty_Passwords      on\n");
			fprintf(conn->stream_w, "Auth_MySQL_Encryption_Types     Plaintext\n");
		}

	} // loop for all accounts
}
#endif
//////////////////////////////////////////////////////////////////////////////////////////
