/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: flow.h,v 1.31 2005/01/17 13:13:21 jura Exp $ */

//////////////////////////////////////////////////////////////////////////
#define CHECK_EXPIRE 		ProcessorCfg.delay	//10	//seconds between expire checks
#define ACTIVE_TIMEOUT 		ProcessorCfg.lifetime	//60
#define INACTIVE_TIMEOUT	60 //
#define MESSAGE_LIFETIME	ProcessorCfg.lifetime	//PROCESSOR_LIFETIME

#define FLOWS_PER_PAK 		30//test should be 30
#define FLOW_VERSION		1

// bitmasks
#define ENTRY_EXPIRED		1
#define ENTRY_BLOCKED		2

//////////////////////////////////////////////////////////////////////////
typedef struct entry {
	in_addr srcaddr;    /* Source IP Address */
	in_addr dstaddr;    /* Destination IP Address */
	in_addr nexthop;    /* Next hop router's IP Address */
	ushort input;          /* Input interface index */
	ushort output;         /* Output interface index */

	unsigned long dPkts;           /* Packets sent in Duration */
	unsigned long dOctets;         /* Octets sent in Duration. */
	unsigned long First;           /* SysUptime at start of flow */
	unsigned long Last;            /* and of last packet of flow */

	unsigned short srcport;        /* TCP/UDP source port number or equivalent */
	unsigned short dstport;        /* TCP/UDP destination port number or equivalent */
	unsigned char pad;
	unsigned char tcp_flags;      /* Cumulative OR of tcp flags */
	unsigned char prot;           /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
	
	unsigned char tos;            /* IP Type-of-Service */
//	unsigned short src_as;         /* originating AS of source address */
//	unsigned short dst_as;         /* originating AS of destination address */
//	unsigned char src_mask;       /* source address prefix mask bits */
//	unsigned char dst_mask;       /* destination address prefix mask bits */
//	ushort reserved;

	//NOTE: fields before should be in sync with IPFlowStat below!!!
	//ALSO fields should be in sync with IPFlow5Stat from netflow.h 
	//for correct work with Netflowv5 packets
	u_char flags;   //EXPIRED,BLOCKED etc
	unsigned id;
	bwUlist *bwRoot;
	entry *next;
} entry;
//////////////////////////////////////////////////////////////////////////
typedef struct FlowStatHdr {
    	ushort version;
    	ushort count;           /* The number of records in PDU. */
//    	unsigned long SysUptime;       /* Current time in millisecs since router booted */
//    	unsigned long unix_secs;       /* Current seconds since 0000 UTC 1970 */
//    	unsigned long unix_nsecs;      /* Residual nanoseconds since 0000 UTC 1970 */
    	unsigned long flow_sequence;   /* Seq counter of total flows seen */
    	unsigned char engine_type;     /* Type of flow switching engine */
    	unsigned char engine_id;       /* ID number of the flow switching engine */
//    	ushort reserved;
} FlowStatHdr;

typedef struct IPFlowStat {
    	in_addr srcaddr;    /* Source IP Address */
    	in_addr dstaddr;    /* Destination IP Address */
    	in_addr nexthop;    /* Next hop router's IP Address */
    	ushort input;          /* Input interface index */
    	ushort output;         /* Output interface index */

    	unsigned long dPkts;           /* Packets sent in Duration */
    	unsigned long dOctets;         /* Octets sent in Duration. */
    	unsigned long First;           /* SysUptime at start of flow */
    	unsigned long Last;            /* and of last packet of flow */

    	unsigned short srcport;        /* TCP/UDP source port number or equivalent */
    	unsigned short dstport;        /* TCP/UDP destination port number or equivalent */
    	unsigned char pad;
	unsigned char tcp_flags;      /* Cumulative OR of tcp flags */
    	unsigned char prot;           /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
    	unsigned char tos;            /* IP Type-of-Service */
//    	unsigned short src_as;         /* originating AS of source address */
//    	unsigned short dst_as;         /* originating AS of destination address */
//    	unsigned char src_mask;       /* source address prefix mask bits */
//    	unsigned char dst_mask;       /* destination address prefix mask bits */
//    	ushort reserved;
} IPFlowStat;

typedef struct IPStatMsg {
    FlowStatHdr header;
    IPFlowStat  records[FLOWS_PER_PAK];
    IPStatMsg  *next;
} IPStatMsg;

//////////////////////////////////////////////////////////////////////////
class Flow {
	public:
		IPTree *IPtree;
		u_char instance;

#define MAX_CHUNK               2048 //protection against DoS - max chunks per hash node

#define IPV4_HASH_SIZE  0x10000
#define IPV4_HASH_MASK 	(IPV4_HASH_SIZE-1)

//old - symmetric
#define IPV4_HASH(addr1, addr2, port1, port2, proto) ((((addr1) + (addr2)) + (port1) + (port2)+ (proto))&IPV4_HASH_MASK)
//new - assymentric
#define IPV4_ADDR_HASH(addr1,addr2)	(((addr1 >> 16) ^ (addr2 & 0xFFFF) ) & IPV4_HASH_MASK)
#define IPV4_FULL_HASH(addr1, addr2, port1, port2) 	(((addr1 >> 16) ^ (addr2 & 0xFFFF) ^ ((port1 ^ port2)) )& IPV4_HASH_MASK)

#define FLOW_FW_CHECK   0x01
		u_char flags;
		
		entry **table;
		entry *ready;

		struct timeval *tv; //we need this for bw 

		time_t t;
		time_t t_now;

		time_t t_msg;	//time message created

		unsigned  e_used;
		unsigned  e_total;

		unsigned last_id, expired_id;
		unsigned long long sent_flows;
		unsigned long long sent_packets;
		
		DS_FIFO *fifo;
		IPStatMsg *message;

		Flow(Service *s, u_char skip_fw_check);
		~Flow();
		void CheckExpire(entry *e);
		void Expiresearch(struct timeval *tv);
		unsigned char Processpacket(struct ip *ip);
		void FlushAll();
		void ToSend(entry *e);
		void DoSend();
		
		u_char FW(IPFlowStat *flow);	
	
		unsigned bw_used;
		unsigned bw_total;
		bwUlist *bwReady;
		void AddBW2entry(BWdata *bw, entry *e, match mf);
		void FreeBWentry(entry *e);
};
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

