/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: events.c,v 1.6 2005/01/17 13:13:21 jura Exp $ */

#include "netams.h"

char *events[]= { "SYSTEM","ACCESS","LOGIN","QUOTA","BILLING",NULL };
pthread_mutex_t event_lock = PTHREAD_MUTEX_INITIALIZER;
FILE *event_file=NULL;
time_t event_load=0;

#define EVENT_DELAY   60      //delay between load into sql

void LogEvent(event_type event, oid uid, oid usid, oid aid, char const *fmt, ...){

	#if !defined(USE_MYSQL) && !defined(USE_POSTGRES) && !defined(USE_ORACLE)
                
//		aLog(D_ERR, "SQL feature is not compiled in!\n");
		return;
	#endif

	// find if we can write this event to somewhere
	// it must be first registered storage at processor
	st_unit *st;
	st=ProcessorCfg.st_root;

	if (!st || !st->s) return; // there are no suitable storages here
	char *filename="events.0";
	time_t now=time(NULL);
	va_list ap;

	pthread_mutex_lock(&event_lock);

	if(!event_file) {
		event_file=fopen(filename,"a");
		if(!event_file) {
			aLog(D_WARN, "Can't create temporary file %s: %s\n", filename, strerror(errno));
			goto END;
		}
		setlinebuf(event_file);
	}

	//NOTE! There is should not be commas in fmt and aps
	va_start(ap, fmt);
	fprintf(event_file, "%u,%s,%u,%u,%u,", now, events[event], uid, usid, aid);
	vfprintf(event_file, fmt, ap);
	fprintf(event_file, "\n");
	va_end(ap);

	if(event_file && event_load < now) {
		event_load+=EVENT_DELAY;
		fclose(event_file);
		stSaveSql(st->s,filename,ST_CONN_EVENTS);
		event_file=NULL;
	}

END:
	pthread_mutex_unlock(&event_lock);
}

