/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ds_ipfw.c,v 1.19 2005/01/17 13:13:21 jura Exp $ */

#ifdef FREEBSD
#include "netams.h"

/////////////////////////////////////////////////////////////////////////////////////
void ds_ipfw_cancel(void *ptr);
/////////////////////////////////////////////////////////////////////////////////////
void* ds_ipfw(void *ss) {
	Service *s=(Service*)ss;
	ServiceDS_cfg *cfg=(ServiceDS_cfg*)s->cfg;
	        
	struct sockaddr_in ds;
	socklen_t size_ds = sizeof(ds);
        int* socketid=(int*)aMalloc(sizeof(int));
	Flow *flow=cfg->flow;
	u_char process_result;
	unsigned len;
	struct timeval start;
	unsigned char *packet=cfg->packet;
	
        ds.sin_family = AF_INET;
        ds.sin_addr.s_addr = INADDR_ANY;
        ds.sin_port = htons(cfg->port);


        if ((*socketid = socket(PF_INET, SOCK_RAW, IPPROTO_DIVERT)) < 0) {
		aLog(D_ERR, "divert socket\n");
		goto END;
	}
        if (bind(*socketid, (struct sockaddr *)&(ds), sizeof(ds))) {
		aLog(D_ERR, "bind divert socket: %d\n", *socketid);
		goto END;
	}
	SET_POLL(*socketid);

	pthread_cleanup_push(ds_ipfw_cancel, (void*) socketid);
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

	aLog(D_INFO,"IPFW packet processing for data-source:%u initialized\n",s->instance);
	
	int status;

	while(1) {
		CHECK_POLL(status);

                gettimeofday(&start, NULL);
		flow->Expiresearch(&start);  
		if(!status) continue;

		len=recvfrom(*socketid, packet, MAX_PKT_SIZE, 0, (struct sockaddr *)&ds, &size_ds);
		process_result=flow->Processpacket((struct ip*) packet);
		if (process_result && (cfg->flags==DS_DIVERT)) 
			sendto(*socketid, packet, len, 0, (struct sockaddr *)&ds, size_ds);
		sDSMeasure(cfg, &start, len);
	}
	pthread_cleanup_pop(0);
END:	
	aFree(socketid);
	return NULL;
}
/////////////////////////////////////////////////////////////////////////////////////
void ds_ipfw_cancel(void *ptr) {
	int *socketid=(int*)ptr;
	shutdown(*socketid, SHUT_RDWR);
	close(*socketid);
	aFree(socketid);
}
/////////////////////////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////////////////////////
