/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: common.h,v 1.41 2005/01/17 13:13:21 jura Exp $ */

//////////////////////////////////////////////////////////////////////////////////////////
// Logging Management ///////////////////////////////////////////////////////////////////
void aParse(Connection *conn, char const *fmt, ...);
void aLog(u_char level, char const *fmt, ...);

#define	D_EMERG	    0x0000  /* for program start/stop records*/
#define	D_ALERT	    0x0001  /* for threads start/stop, db open/close ? */
#define	D_CRIT	    0x0002  /* die without data save */
#define	D_ERR	    0x0003  /* errors, program will be closed with save */
#define	D_WARN	    0x0004  /* warnings, should be logged */
#define	D_NOTICE    0x0005  /* */
#define	D_INFO	    0x0006  /* informational messages for daily run*/
#define	D_DEBUG	    0x0007  /* all debugging info is on */
#define	D_DEFAULT_DEBUG	    D_INFO

enum event_type { SYSTEM=0, ACCESS, LOGIN, QUOTA, BILLING };	
 
//////////////////////////////////////////////////////////////////////////////////////////

typedef unsigned oid;
oid newOid(oid newid=0);

//////////////////////////////////////////////////////////////////////////////////////////
// Debugging management
typedef long long Debug;

#if defined(DEBUG ) || defined(OLD_GCC)
void aDebug(u_char d, char const *fmt, ...);
#else
#define aDebug(...)
#endif

void aDebugInit();
u_char aDebugAdd(Debug &d, char *str);
u_char aDebugRm(Debug &d, char *str);
u_char aDebugIsSet(Debug d, u_char u);

extern char *debug_list[64]; 

#define DEBUG_NONE		0
#define	DEBUG_COMMAND		1
#define DEBUG_PARSE		2
#define DEBUG_SLEEP		3
#define DEBUG_SERVER		4
#define DEBUG_PROC_MUX 		5
#define DEBUG_DS_IP 		6
#define DEBUG_STORAGE 		7
#define DEBUG_ALERT 		8
#define DEBUG_SCHED		9
#define DEBUG_HTML		11
#define DEBUG_MONITOR		12
#define DEBUG_LOGIN		13
#define DEBUG_QUOTA		14
#define DEBUG_IPTREE		15
#define DEBUG_FLOW		16
#define DEBUG_DS_MUX		17
#define DEBUG_MEMORY		18
#define DEBUG_POLICY		19
#define DEBUG_BILLING		20
#define DEBUG_PVM		21
#define DEBUG_ALL		63

//////////////////////////////////////////////////////////////////////////////////////////
char *timeU2T(time_t time, char *buf);
time_t timeT2U(char *buf, time_t *time);
char *bytesQ2T(unsigned long long bytes, char *buf);
unsigned long long bytesT2Q(char *buf);

void termination(int signal=SIGTERM);
void logrotate(int signal);
//////////////////////////////////////////////////////////////////////////////////////////
struct time_counters {
	time_t ht;
	time_t dt;
	time_t wt;
	time_t mt;
};

void PrepareTimeCounters(struct time_counters *tc, time_t t=time(NULL));
void FillTimeCounters(policy_data *np,struct time_counters *tc);
time_t aGetActual(char prefix, time_t t=time(NULL));
//////////////////////////////////////////////////////////////////////////////////////////
void cHelp(Connection *conn, u_char no_flag, char *str);
void aShowVersion (FILE*);
void print_to_string(char **string, char const *fmt, ...);
char* set_string(char *string);
void cExec(char *cmd, char **buffer);
//////////////////////////////////////////////////////////////////////////////////////////
u_char mask2mlen(in_addr *addr);
/* taken from http://groups.google.com/groups?hl=ru&lr=&threadm=cl3a87%24pa5%244%40wagner.wagner
.home&rnum=1&prev=/groups%3Fq%3D%25D0%25BC%25D0%25B0%25D1%2581%25D0%25BA%25D0%25B0%2B%25D1%2581%
25D0%25B5%25D1%2582%25D0%25B8%2Bgroup:*ru*unix.prog%26hl%3Dru%26lr%3D%26scoring%3Dr%26selm%3Dcl3
a87%2524pa5%25244%2540wagner.wagner.home%26rnum%3D1  */
#define MLEN2MASK(mlen) ((mlen)?(((in_addr_t)~(uint32_t)0) << (32 - (mlen))):0)
#define MASK2MLEN(mask) mask2mlen(mask)
//////////////////////////////////////////////////////////////////////////////////////////
void aOidsInit();
int cNewOid(Connection *c, char *type);
int cShowPerf(Connection *conn, char *param[]);
int cShowSystemHealth(Connection *conn);
u_char getAddr(char *str, in_addr *addr, in_addr *mask=NULL);
int getdayofweek(char *str);
extern char *daysofweek[7];
//////////////////////////////////////////////////////////////////////////////////////////
