/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: alert_report.h,v 1.10 2005/01/17 13:13:21 jura Exp $ */

#define MAX_ID_PER_ALERT 10

//////////////////////////////////////////////////////////////////////////
// alert structure

enum alert_type { MAIL };

typedef struct alert {
	unsigned alert_id;
	oid	report_id;
	oid user_id[MAX_ID_PER_ALERT];
	oid unit_id[MAX_ID_PER_ALERT]; 
	unsigned unit_id_recursive[MAX_ID_PER_ALERT];
	time_t sent;
	alert_type type;
	char *data;
	time_t expired;
	unsigned tries;
	} alert;

//////////////////////////////////////////////////////////////////////////
// alerter service

typedef struct ServiceAlerter_cfg {
	FIFO *queue;
	Service *self;
	char *smtp_server;
	char *sms_server;
	char *pager_server;
	} ServiceAlerter_cfg; 

void sAlerterInit(Service *s);
void sAlerterProcessCfg(char *param[], Connection *conn, u_char no_flag);
void sAlerterListCfg(Service *s, FILE *f);
void cShowAlerter(Connection *conn);

void *sAlerter(void *s);
void sAlerterCancel(void *);
int cSend(Connection *conn, char *param[]);
int cProcessAlert(Service *s, alert *al);
void cReport(char **message, NetUnit *u, oid report_id, u_char is_recursive, u_char level=0); 

//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

